/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.jsf;

import com.intellij.jsp.javaee.web.el.impl.CustomJsfVariableResolverProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.el.SpringBeansAsElVariableUtil;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import java.util.List;
import org.jetbrains.annotations.NonNls;

final class SpringJsfVariableResolverProvider
implements CustomJsfVariableResolverProvider {
    @NonNls
    private static final List<String> VARIABLE_RESOLVER_CLASS_NAMES = List.of("org.springframework.web.jsf.DelegatingVariableResolver", "org.springframework.web.jsf.SpringBeanVariableResolver", "org.springframework.web.jsf.el.SpringBeanFacesELResolver");

    SpringJsfVariableResolverProvider() {
    }

    public boolean acceptVariableResolver(String className, Module module) {
        return VARIABLE_RESOLVER_CLASS_NAMES.contains(className) || SpringJsfVariableResolverProvider.isInheritor(className, module);
    }

    private static boolean isInheritor(String className, Module module) {
        if (module == null || StringUtil.isEmptyOrSpaces((String)className)) {
            return false;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(className, SpringGlobalSearchScopes.moduleWithDependencies(module));
        if (psiClass != null) {
            for (String name : VARIABLE_RESOLVER_CLASS_NAMES) {
                if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (String)name)) continue;
                return true;
            }
        }
        return false;
    }

    public void addVars(List<PsiVariable> resultVars, Module module) {
        SpringBeansAsElVariableUtil.addVariables(resultVars, module);
    }
}

