/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.spring.model.search.PsiClassImmutableSearchParams;
import com.intellij.spring.model.search.PsiTypeImmutableSearchParams;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.CollectionFactory;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringModelSearchParameters {
    private static final Logger LOG = Logger.getInstance(SpringModelSearchParameters.class);
    private static final Map<String, BeanName> ourCachedBeanNames = CollectionFactory.createConcurrentWeakKeyWeakValueMap();

    protected SpringModelSearchParameters() {
    }

    public abstract boolean canSearch();

    public static BeanClass byClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringModelSearchParameters.$$$reportNull$$$0(0);
        }
        PsiUtilCore.ensureValid((PsiElement)psiClass);
        return new PsiClassImmutableSearchParams(psiClass);
    }

    public static BeanClass byType(@NotNull PsiType psiType) {
        if (psiType == null) {
            SpringModelSearchParameters.$$$reportNull$$$0(1);
        }
        if (psiType instanceof PsiPrimitiveType) {
            return new PsiTypeImmutableSearchParams((PsiPrimitiveType)psiType);
        }
        if (psiType instanceof PsiClassType) {
            return new PsiTypeImmutableSearchParams((PsiClassType)psiType);
        }
        return new BeanClass(psiType);
    }

    public static BeanName byName(@NotNull String beanName) {
        if (beanName == null) {
            SpringModelSearchParameters.$$$reportNull$$$0(2);
        }
        return ourCachedBeanNames.computeIfAbsent(beanName, BeanName::new);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/SpringModelSearchParameters";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "byClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "byType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "byName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class BeanClass
    extends SpringModelSearchParameters {
        private final PsiType myType;
        protected byte myOptions;
        private static final byte CAN_SEARCH = 1;
        private static final byte WITH_INHERITORS = 2;
        private static final byte EFFECTIVE_BEAN_TYPES = 4;
        private static final byte SEARCH_IN_LIBRARIES = 8;

        protected BeanClass(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                BeanClass.$$$reportNull$$$0(0);
            }
            this.myType = JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createType(psiClass, BeanClass.getSubstitutor(psiClass));
            this.myOptions = BitUtil.set((byte)this.myOptions, (byte)1, (boolean)SpringCommonUtils.isSpringBeanCandidateClass(psiClass));
            this.myOptions = BitUtil.set((byte)this.myOptions, (byte)8, (boolean)BeanClass.isSearchInLibraries(psiClass));
            this.assertSearchClass(psiClass);
        }

        @NotNull
        private static PsiSubstitutor getSubstitutor(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                BeanClass.$$$reportNull$$$0(1);
            }
            PsiSubstitutor psiSubstitutor = psiClass.isValid() ? JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createRawSubstitutor((PsiTypeParameterListOwner)psiClass) : PsiSubstitutor.EMPTY;
            if (psiSubstitutor == null) {
                BeanClass.$$$reportNull$$$0(2);
            }
            return psiSubstitutor;
        }

        protected BeanClass(@NotNull PsiType psiType) {
            if (psiType == null) {
                BeanClass.$$$reportNull$$$0(3);
            }
            this.myType = psiType;
            PsiClass searchClass = PsiTypesUtil.getPsiClass((PsiType)psiType);
            this.myOptions = BitUtil.set((byte)this.myOptions, (byte)1, (searchClass == null || SpringCommonUtils.isSpringBeanCandidateClass(searchClass) ? 1 : 0) != 0);
            this.myOptions = BitUtil.set((byte)this.myOptions, (byte)8, (boolean)BeanClass.isSearchInLibraries(searchClass));
            this.assertSearchClass(searchClass);
        }

        private static boolean isSearchInLibraries(@Nullable PsiClass searchClass) {
            if (searchClass != null) {
                PsiFile containingFile = searchClass.getContainingFile();
                if (containingFile == null) {
                    return true;
                }
                VirtualFile virtualFile = containingFile.getVirtualFile();
                if (virtualFile == null) {
                    return true;
                }
                return !ProjectScope.getProjectScope((Project)searchClass.getProject()).contains(virtualFile) || SpringCommonUtils.canBeScannedFromNonSpringLibraries(searchClass);
            }
            return true;
        }

        private void assertSearchClass(@Nullable PsiClass psiClass) {
            if (psiClass instanceof PsiAnonymousClass) {
                LOG.error("cannot search for anonymous class: " + psiClass + " " + this.myType.getClass() + ": " + this.myType.getCanonicalText());
            }
            if (psiClass != null && psiClass.getQualifiedName() == null) {
                LOG.error("cannot search for null FQN class: " + psiClass + " " + this.myType.getClass() + ": " + this.myType.getCanonicalText());
            }
        }

        @Override
        public boolean canSearch() {
            return BitUtil.isSet((byte)this.myOptions, (byte)1);
        }

        public boolean isSearchInLibraries() {
            return BitUtil.isSet((byte)this.myOptions, (byte)8);
        }

        public BeanClass withInheritors() {
            this.myOptions = BitUtil.set((byte)this.myOptions, (byte)2, (boolean)true);
            return this;
        }

        public BeanClass effectiveBeanTypes() {
            this.myOptions = BitUtil.set((byte)this.myOptions, (byte)4, (boolean)true);
            return this;
        }

        public BeanClass searchInLibraries(boolean searchInLibraries) {
            this.myOptions = BitUtil.set((byte)this.myOptions, (byte)8, (boolean)searchInLibraries);
            return this;
        }

        @NotNull
        public PsiType getSearchType() {
            PsiType psiType = this.myType;
            if (psiType == null) {
                BeanClass.$$$reportNull$$$0(4);
            }
            return psiType;
        }

        public boolean isWithInheritors() {
            return BitUtil.isSet((byte)this.myOptions, (byte)2);
        }

        public boolean isEffectiveBeanTypes() {
            return BitUtil.isSet((byte)this.myOptions, (byte)4);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BeanClass)) {
                return false;
            }
            BeanClass beanClass = (BeanClass)o;
            if (this.myOptions != beanClass.myOptions) {
                return false;
            }
            if (!this.myType.isValid() || !beanClass.getSearchType().isValid()) {
                return false;
            }
            return this.myType.equals(beanClass.getSearchType());
        }

        public int hashCode() {
            int result = this.myType.hashCode();
            result = 31 * result + this.myOptions;
            return result;
        }

        public String toString() {
            return "SpringModelSearchParameters.BeanClass{myType=" + (this.myType.isValid() ? this.myType : "INVALID") + ", myOptions=" + this.myOptions + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/SpringModelSearchParameters$BeanClass";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/SpringModelSearchParameters$BeanClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubstitutor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSearchType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getSubstitutor";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static final class BeanName
    extends SpringModelSearchParameters
    implements Immutable {
        @NotNull
        private final String myBeanName;

        private BeanName(@NotNull String beanName) {
            if (beanName == null) {
                BeanName.$$$reportNull$$$0(0);
            }
            this.myBeanName = StringUtil.isNotEmpty((String)beanName) ? beanName : "";
        }

        @Override
        public boolean canSearch() {
            return !this.myBeanName.isEmpty();
        }

        @NotNull
        public String getBeanName() {
            String string = this.myBeanName;
            if (string == null) {
                BeanName.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BeanName)) {
                return false;
            }
            BeanName name = (BeanName)o;
            return this.myBeanName.equals(name.myBeanName);
        }

        public int hashCode() {
            return this.myBeanName.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "beanName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/SpringModelSearchParameters$BeanName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/SpringModelSearchParameters$BeanName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBeanName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static interface Immutable {
    }
}

