/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.generate;

import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LanguageAnnotationSupport;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationSupport;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.actions.generate.GenerateSpringBeanDependenciesUtil;
import com.intellij.spring.model.actions.generate.SpringGenerateTemplatesHolder;
import com.intellij.spring.model.jam.stereotype.SuperClassSpringComponentStub;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtilImpl;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GenerateAutowiredDependenciesUtil {
    public static List<SpringGenerateTemplatesHolder> generateAutowiredDependencies(@NotNull PsiClass psiClass, List<? extends SpringBeanPointer<?>> dependencies, CommonSpringModel model) {
        if (psiClass == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(0);
        }
        return (List)WriteCommandAction.writeCommandAction((Project)psiClass.getProject()).compute(() -> {
            ArrayList<SpringGenerateTemplatesHolder> springInjections = new ArrayList<SpringGenerateTemplatesHolder>();
            for (SpringBeanPointer bean : dependencies) {
                SpringGenerateTemplatesHolder templatesHolder = GenerateAutowiredDependenciesUtil.createAutowiredDependency(psiClass, bean, model);
                if (templatesHolder == null) continue;
                springInjections.add(templatesHolder);
            }
            return springInjections;
        });
    }

    @Nullable
    private static SpringGenerateTemplatesHolder createAutowiredDependency(@NotNull PsiClass psiClass, @NotNull SpringBeanPointer<?> bean, @NotNull CommonSpringModel model) {
        SpringGenerateTemplatesHolder templatesHolder;
        PsiField setter;
        if (psiClass == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(1);
        }
        if (bean == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(2);
        }
        if (model == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(3);
        }
        if ((setter = GenerateAutowiredDependenciesUtil.createField(psiClass, bean, templatesHolder = new SpringGenerateTemplatesHolder(psiClass.getProject()), model)) != null) {
            return templatesHolder;
        }
        return null;
    }

    @Nullable
    private static PsiField createField(@NotNull PsiClass currentBeanClass, @NotNull SpringBeanPointer<?> candidateBean, @NotNull SpringGenerateTemplatesHolder templatesHolder, @NotNull CommonSpringModel model) {
        PsiClass[] candidateBeanClasses;
        if (currentBeanClass == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(4);
        }
        if (candidateBean == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(5);
        }
        if (templatesHolder == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(6);
        }
        if (model == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(7);
        }
        if ((candidateBeanClasses = (PsiClass[])candidateBean.getEffectiveBeanTypes().stream().map(type -> PsiTypesUtil.getPsiClass((PsiType)type)).filter(Objects::nonNull).toArray(PsiClass[]::new)).length > 0) {
            if (!GenerateSpringBeanDependenciesUtil.ensureFileWritable(currentBeanClass)) {
                return null;
            }
            PsiField field = GenerateAutowiredDependenciesUtil.createAutowiredField(candidateBean, currentBeanClass, candidateBeanClasses, model);
            GenerateAutowiredDependenciesUtil.addCreateFieldTemplate(field, candidateBean, candidateBeanClasses, templatesHolder);
            return field;
        }
        return null;
    }

    @NotNull
    private static PsiField createAutowiredField(@NotNull SpringBeanPointer<?> candidateBean, @NotNull PsiClass currentBeanClass, PsiClass @NotNull [] candidateBeanClasses, @NotNull CommonSpringModel model) {
        PsiField psiField;
        if (candidateBean == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(8);
        }
        if (currentBeanClass == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(9);
        }
        if (model == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(10);
        }
        if (candidateBeanClasses == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(11);
        }
        try {
            String qualifierName = GenerateAutowiredDependenciesUtil.getQualifierName(candidateBean);
            PsiNameHelper psiNameHelper = PsiNameHelper.getInstance((Project)currentBeanClass.getProject());
            PsiClass candidateBeanClass = candidateBeanClasses[0];
            String beanName = candidateBean.getName();
            String name = beanName == null || !psiNameHelper.isIdentifier(beanName) ? candidateBeanClass.getName() : beanName;
            PsiManager psiManager = currentBeanClass.getManager();
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
            PsiClassType type = candidateBeanClass != null ? elementFactory.createType(candidateBeanClass) : PsiType.getJavaLangObject((PsiManager)psiManager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)psiManager.getProject()));
            psiField = elementFactory.createField(StringUtil.decapitalize((String)StringUtil.notNullize((String)name)), (PsiType)type);
            psiField = (PsiField)currentBeanClass.add((PsiElement)psiField);
            psiField.getModifierList().addAnnotation("org.springframework.beans.factory.annotation.Autowired");
            SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass(candidateBeanClass).withInheritors().effectiveBeanTypes();
            if (SpringModelSearchers.findBeans(model, searchParameters).size() > 1 && !StringUtil.isEmptyOrSpaces((String)qualifierName)) {
                PsiAnnotation annotation = psiField.getModifierList().addAnnotation("org.springframework.beans.factory.annotation.Qualifier");
                PsiAnnotationSupport support = (PsiAnnotationSupport)LanguageAnnotationSupport.INSTANCE.forLanguage(annotation.getLanguage());
                annotation.setDeclaredAttributeValue("value", (PsiAnnotationMemberValue)support.createLiteralValue(qualifierName, (PsiElement)annotation));
            }
            GenerateSpringBeanDependenciesUtil.reformat((PsiMember)psiField);
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
        PsiField psiField2 = psiField;
        if (psiField2 == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(12);
        }
        return psiField2;
    }

    @Nullable
    public static String getQualifierName(@NotNull SpringBeanPointer<?> candidateBean) {
        if (candidateBean == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(13);
        }
        if (candidateBean.getSpringBean() instanceof SuperClassSpringComponentStub) {
            return null;
        }
        for (SpringQualifier qualifier : candidateBean.getSpringBean().getSpringQualifiers()) {
            String value = qualifier.getQualifierValue();
            if (StringUtil.isEmptyOrSpaces((String)value)) continue;
            return value;
        }
        return candidateBean.getName();
    }

    private static void addCreateFieldTemplate(PsiField psiField, SpringBeanPointer<?> candidateBean, PsiClass[] psiClasses, SpringGenerateTemplatesHolder templatesHolder) {
        Set<String> existedNames = GenerateAutowiredDependenciesUtil.getExistedNames(psiField);
        PsiType type = psiField.getType();
        Collection<String> suggestedNames = GenerateAutowiredDependenciesUtil.suggestPsiFieldNames(type, candidateBean, existedNames);
        templatesHolder.addTemplateFactory((PsiElement)psiField, (Factory<Template>)((Factory)() -> {
            Collection<PsiClass> variants = GenerateSpringBeanDependenciesUtil.getSuperTypeVariants(psiClasses);
            PsiTypeElement typeElement = psiField.getTypeElement();
            Expression interfaces = GenerateAutowiredDependenciesUtil.getSuperTypesExpression(typeElement.getType().getCanonicalText(), variants);
            Expression ids = GenerateAutowiredDependenciesUtil.getPsiFieldSuggestNamesExpression(psiField, suggestedNames, existedNames);
            TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)psiField);
            if (variants.size() > 1) {
                builder.replaceElement((PsiElement)typeElement, "type", interfaces, true);
            }
            builder.replaceElement((PsiElement)psiField.getNameIdentifier(), "names", ids, true);
            return builder.buildInlineTemplate();
        }));
    }

    @NotNull
    private static Set<String> getExistedNames(@NotNull PsiField psiField) {
        if (psiField == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(14);
        }
        HashSet<String> existedNames = new HashSet<String>();
        PsiClass containingClass = psiField.getContainingClass();
        if (containingClass != null) {
            for (PsiField field : containingClass.getAllFields()) {
                if (field == psiField) continue;
                existedNames.add(field.getName());
            }
        }
        HashSet<String> hashSet = existedNames;
        if (hashSet == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(15);
        }
        return hashSet;
    }

    private static Expression getPsiFieldSuggestNamesExpression(final @NotNull PsiField psiField, final @NotNull Collection<String> suggestions, @NotNull Set<String> existedNames) {
        if (psiField == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(16);
        }
        if (suggestions == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(17);
        }
        if (existedNames == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(18);
        }
        return new Expression(){

            public Result calculateResult(ExpressionContext context) {
                PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
                PsiIdentifier psiIdentifier = psiField.getNameIdentifier();
                return new TextResult(psiIdentifier.getText());
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
                LinkedHashSet<LookupElementBuilder> items = new LinkedHashSet<LookupElementBuilder>();
                for (String name : suggestions) {
                    items.add(LookupElementBuilder.create((String)name));
                }
                return items.toArray(LookupElement.EMPTY_ARRAY);
            }

            @NotNull
            public LookupFocusDegree getLookupFocusDegree() {
                LookupFocusDegree lookupFocusDegree = LookupFocusDegree.UNFOCUSED;
                if (lookupFocusDegree == null) {
                    1.$$$reportNull$$$0(0);
                }
                return lookupFocusDegree;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil$1", "getLookupFocusDegree"));
            }
        };
    }

    private static Collection<String> suggestPsiFieldNames(@NotNull PsiType psiType, @NotNull SpringBeanPointer<?> bean, @NotNull Set<String> existedNames) {
        if (psiType == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(19);
        }
        if (bean == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(20);
        }
        if (existedNames == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(21);
        }
        assert (bean.isValid());
        Project project = bean.getContainingFile().getProject();
        PsiNameHelper psiNameHelper = PsiNameHelper.getInstance((Project)project);
        HashSet<String> names2 = new HashSet<String>();
        String beanName = bean.getName();
        if (beanName != null) {
            for (String name : bean.getAliases()) {
                if (!psiNameHelper.isIdentifier(name) || existedNames.contains(name)) continue;
                names2.add(name);
            }
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        Set<String> suggestions = SpringBeanCoreUtils.getSanitizedBeanNameSuggestions(codeStyleManager, psiType);
        suggestions.removeAll(existedNames);
        names2.addAll(suggestions);
        return names2;
    }

    static Expression getSuperTypesExpression(String psiType, Collection<? extends PsiClass> psiClasses) {
        return new ConstantNode(psiType).withLookupItems((Collection)ContainerUtil.map(psiClasses, psiClass -> JavaClassNameCompletionContributor.createClassLookupItem((PsiClass)psiClass, (boolean)true)));
    }

    public static boolean isAnnotatedComponent(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(22);
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClassInSpringProject(psiClass) || psiClass.isRecord()) {
            return false;
        }
        return SpringCommonUtils.isStereotypeComponentOrMeta(psiClass) || SpringCommonUtils.isConfigurationOrMeta(psiClass) || SpringTestContextUtilImpl.isSpringTestContextConfiguration(psiClass);
    }

    public static boolean isAnnotatedOrMapped(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            GenerateAutowiredDependenciesUtil.$$$reportNull$$$0(23);
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClassInSpringProject(psiClass) || psiClass.isRecord()) {
            return false;
        }
        if (SpringCommonUtils.isStereotypeComponentOrMeta(psiClass) || SpringCommonUtils.isConfigurationOrMeta(psiClass) || SpringTestContextUtilImpl.isSpringTestContextConfiguration(psiClass)) {
            return true;
        }
        return SpringJavaClassInfo.getSpringJavaClassInfo(psiClass).isCalculatedMapped();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentBeanClass";
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateBean";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templatesHolder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateBeanClasses";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestions";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existedNames";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createAutowiredField";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistedNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateAutowiredDependencies";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAutowiredDependency";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createField";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createAutowiredField";
                break;
            }
            case 12: 
            case 15: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getExistedNames";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFieldSuggestNamesExpression";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "suggestPsiFieldNames";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatedComponent";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatedOrMapped";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 15 -> new IllegalStateException(string);
        };
    }
}

