/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.cacheable.highlighting;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.semantic.SemService;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.cacheable.jam.SpringJamCacheableElement;
import com.intellij.spring.model.cacheable.jam.custom.SpringJamCustomCachePut;
import com.intellij.spring.model.cacheable.jam.custom.SpringJamCustomCacheable;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCachePut;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCacheable;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public final class SpringCacheableAndCachePutInspection
extends SpringUastInspectionBase {
    public SpringCacheableAndCachePutInspection() {
        super(UMethod.class);
    }

    public ProblemDescriptor @Nullable [] checkMethod(@NotNull UMethod umethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (umethod == null) {
            SpringCacheableAndCachePutInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringCacheableAndCachePutInspection.$$$reportNull$$$0(1);
        }
        if (SpringCommonUtils.isInSpringEnabledModule((UElement)umethod)) {
            List<SpringJamCacheableElement> cachePutElements;
            PsiMethod method = umethod.getJavaPsi();
            PsiElement sourcePsi = umethod.getSourcePsi();
            if (sourcePsi == null) {
                return null;
            }
            List<SpringJamCacheableElement> cacheableElements = SpringCacheableAndCachePutInspection.getCacheableElements(method);
            if (cacheableElements.size() > 0 && (cachePutElements = SpringCacheableAndCachePutInspection.getCachePutElements(method)).size() > 0) {
                ProblemsHolder holder = new ProblemsHolder(manager, sourcePsi.getContainingFile(), isOnTheFly);
                SpringCacheableAndCachePutInspection.registerProblems(cacheableElements, holder);
                SpringCacheableAndCachePutInspection.registerProblems(cachePutElements, holder);
                return holder.getResultsArray();
            }
        }
        return null;
    }

    private static void registerProblems(List<SpringJamCacheableElement> cacheableElements, ProblemsHolder holder) {
        for (SpringJamCacheableElement element : cacheableElements) {
            PsiElement annotation = UAnnotationKt.getNamePsiElement((UAnnotation)((UAnnotation)UastContextKt.toUElement((PsiElement)element.getAnnotation(), UAnnotation.class)));
            if (annotation == null) continue;
            holder.registerProblem(annotation, SpringBundle.message("cacheable.and.cache.put.on.the.same.method", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static List<SpringJamCacheableElement> getCacheableElements(@NotNull PsiMethod method) {
        if (method == null) {
            SpringCacheableAndCachePutInspection.$$$reportNull$$$0(2);
        }
        SmartList elements = new SmartList();
        elements.addAll(SemService.getSemService((Project)method.getProject()).getSemElements(SpringJamCacheable.CACHEABLE_JAM_KEY, (PsiElement)method));
        elements.addAll(SemService.getSemService((Project)method.getProject()).getSemElements(SpringJamCustomCacheable.CUSTOM_CACHEABLE_JAM_KEY, (PsiElement)method));
        return elements;
    }

    private static List<SpringJamCacheableElement> getCachePutElements(@NotNull PsiMethod method) {
        if (method == null) {
            SpringCacheableAndCachePutInspection.$$$reportNull$$$0(3);
        }
        SmartList elements = new SmartList();
        elements.addAll(SemService.getSemService((Project)method.getProject()).getSemElements(SpringJamCachePut.CACHE_PUT_JAM_KEY, (PsiElement)method));
        elements.addAll(SemService.getSemService((Project)method.getProject()).getSemElements(SpringJamCustomCachePut.CUSTOM_CACHE_PUT_JAM_KEY, (PsiElement)method));
        return elements;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "umethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/cacheable/highlighting/SpringCacheableAndCachePutInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethod";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCacheableElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCachePutElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

