/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.converters.BeanPropertyConverter;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.properties.SpringPropertyReference;
import com.intellij.spring.model.properties.SpringPropertyReferenceSet;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanPropertyConverterImpl
extends BeanPropertyConverter {
    public List<BeanProperty> fromString(@Nullable String s, @NotNull ConvertContext context) {
        if (context == null) {
            BeanPropertyConverterImpl.$$$reportNull$$$0(0);
        }
        if (s == null) {
            return null;
        }
        GenericAttributeValue value = (GenericAttributeValue)context.getInvocationElement();
        SpringPropertyReference[] references = this.createReferences((GenericDomValue<List<BeanProperty>>)value, (PsiElement)value.getXmlAttributeValue(), context);
        if (references.length == 0) {
            return Collections.emptyList();
        }
        ResolveResult[] results = references[references.length - 1].multiResolve(false);
        ArrayList<BeanProperty> beanProperties = new ArrayList<BeanProperty>(results.length);
        for (ResolveResult result : results) {
            PsiMethod method = (PsiMethod)result.getElement();
            if (method == null) continue;
            BeanProperty beanProperty = BeanProperty.createBeanProperty((PsiMethod)method);
            ContainerUtil.addIfNotNull(beanProperties, (Object)beanProperty);
        }
        return beanProperties;
    }

    @Override
    @NotNull
    public List<BeanPropertyConverter.BeanPropertyType> getPropertyTypes(ConvertContext context) {
        GenericAttributeValue value = (GenericAttributeValue)context.getInvocationElement();
        SpringPropertyReference[] references = this.createReferences((GenericDomValue<List<BeanProperty>>)value, (PsiElement)value.getXmlAttributeValue(), context);
        if (references.length == 0) {
            List<BeanPropertyConverter.BeanPropertyType> list = Collections.emptyList();
            if (list == null) {
                BeanPropertyConverterImpl.$$$reportNull$$$0(1);
            }
            return list;
        }
        Collection<PsiMethod> psiMethods = references[references.length - 1].guessMethodsForConverter();
        ArrayList<BeanPropertyConverter.BeanPropertyType> propertyTypes = new ArrayList<BeanPropertyConverter.BeanPropertyType>(psiMethods.size());
        for (PsiMethod method : psiMethods) {
            BeanProperty beanProperty = BeanProperty.createBeanProperty((PsiMethod)method);
            if (beanProperty == null) continue;
            PsiType propertyType = beanProperty.getPropertyType();
            ContainerUtil.addIfNotNull(propertyTypes, (Object)new BeanPropertyConverter.BeanPropertyType(method, propertyType));
        }
        ArrayList<BeanPropertyConverter.BeanPropertyType> arrayList = propertyTypes;
        if (arrayList == null) {
            BeanPropertyConverterImpl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public String toString(@Nullable List<BeanProperty> beanProperty, @NotNull ConvertContext context) {
        if (context == null) {
            BeanPropertyConverterImpl.$$$reportNull$$$0(3);
        }
        return null;
    }

    public SpringPropertyReference @NotNull [] createReferences(GenericDomValue<List<BeanProperty>> genericDomValue, PsiElement element, ConvertContext context) {
        if (element == null) {
            return new SpringPropertyReference[0];
        }
        CommonSpringBean springBean = SpringConverterUtil.getCurrentBeanCustomAware(context);
        assert (springBean != null);
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (this.isAbstractBeanTemplate(springBean, beanClass, context)) {
            return new SpringPropertyReference[0];
        }
        SpringPropertyReference[] springPropertyReferenceArray = new SpringPropertyReferenceSet(element, beanClass, genericDomValue, context, springBean).getPsiReferences();
        if (springPropertyReferenceArray == null) {
            BeanPropertyConverterImpl.$$$reportNull$$$0(4);
        }
        return springPropertyReferenceArray;
    }

    public boolean isAbstractBeanTemplate(@NotNull CommonSpringBean springBean, @Nullable PsiClass beanClass, @NotNull ConvertContext context) {
        SpringModel model;
        boolean isAbstractBeanWithNoClass;
        if (springBean == null) {
            BeanPropertyConverterImpl.$$$reportNull$$$0(5);
        }
        if (context == null) {
            BeanPropertyConverterImpl.$$$reportNull$$$0(6);
        }
        boolean bl = isAbstractBeanWithNoClass = beanClass == null && springBean instanceof SpringBean && ((SpringBean)springBean).isAbstract();
        return isAbstractBeanWithNoClass && (model = SpringConverterUtil.getSpringModel(context)) != null && SpringModelVisitorUtils.getDescendants(model, BeanService.getInstance().createSpringBeanPointer(springBean)).size() == 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/BeanPropertyConverterImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/BeanPropertyConverterImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyTypes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAbstractBeanTemplate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4 -> new IllegalStateException(string);
        };
    }
}

