/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodQuickFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringBeanLookupMethodConverter;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.LookupMethod;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanLookupMethodConverterImpl
extends SpringBeanLookupMethodConverter {
    @Override
    @Nullable
    protected PsiClass getPsiClass(ConvertContext context) {
        SpringBean springBean = (SpringBean)context.getInvocationElement().getParentOfType(SpringBean.class, false);
        return springBean != null ? PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType()) : null;
    }

    @Override
    protected boolean checkModifiers(PsiMethod method) {
        return method.hasModifierProperty("public") || method.hasModifierProperty("protected");
    }

    @Override
    protected boolean checkReturnType(ConvertContext context, PsiMethod method, boolean forCompletion) {
        Collection<PsiType> possibleReturnTypes;
        PsiType returnType = method.getReturnType();
        if (PsiTypes.voidType().equals((Object)returnType) || returnType instanceof PsiPrimitiveType) {
            return false;
        }
        if (forCompletion && !(possibleReturnTypes = SpringBeanLookupMethodConverterImpl.getValidReturnTypes(context)).isEmpty() && returnType != null) {
            for (PsiType possibleReturnType : possibleReturnTypes) {
                if (!possibleReturnType.isAssignableFrom(returnType)) continue;
                return true;
            }
            return false;
        }
        return super.checkReturnType(context, method, forCompletion);
    }

    @Override
    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        Collection<PsiType> validReturnTypes = SpringBeanLookupMethodConverterImpl.getValidReturnTypes(context);
        if (validReturnTypes.isEmpty()) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        DomSpringBean springBean = SpringConverterUtil.getCurrentBean(context);
        if (springBean == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        GenericDomValue element = (GenericDomValue)context.getInvocationElement();
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        String elementName = element.getStringValue();
        if (psiClass == null || elementName == null || StringUtil.isEmpty((String)elementName)) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        ArrayList<CreateMethodQuickFix> fixes = new ArrayList<CreateMethodQuickFix>();
        for (PsiType returnType : validReturnTypes) {
            CreateMethodQuickFix fix2 = CreateMethodQuickFix.createFix((PsiClass)psiClass, (String)SpringBeanLookupMethodConverterImpl.getNewMethodSignature(elementName, returnType), (String)SpringBeanLookupMethodConverterImpl.getNewMethodBody());
            if (fix2 == null) continue;
            fixes.add(fix2);
        }
        return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    @NonNls
    private static String getNewMethodBody() {
        return "return null;";
    }

    @NonNls
    private static String getNewMethodSignature(@NotNull String elementName, @NotNull PsiType psiType) {
        if (elementName == null) {
            SpringBeanLookupMethodConverterImpl.$$$reportNull$$$0(0);
        }
        if (psiType == null) {
            SpringBeanLookupMethodConverterImpl.$$$reportNull$$$0(1);
        }
        return "public " + psiType.getCanonicalText() + " " + elementName + "()";
    }

    private static Collection<PsiType> getValidReturnTypes(ConvertContext context) {
        SpringBeanPointer beanPointer;
        LookupMethod lookupMethod = (LookupMethod)context.getInvocationElement().getParentOfType(LookupMethod.class, false);
        if (lookupMethod != null && (beanPointer = (SpringBeanPointer)lookupMethod.getBean().getValue()) != null) {
            return beanPointer.getEffectiveBeanTypes();
        }
        return Collections.emptySet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "elementName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "psiType";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/model/converters/SpringBeanLookupMethodConverterImpl";
        objectArray[2] = "getNewMethodSignature";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

