/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.autowire;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UastContextKt;

public final class SpringUastAutowiredMembersChecker {
    public static void checkClass(@NotNull UClass uClass, @NotNull ProblemsHolder holder, @NotNull Map<PsiClass, SpringJavaClassInfo.MappedBeanInfo> mappedBeanInfos) {
        SpringJavaClassInfo.MappedBeanInfo info;
        PsiClass aClass;
        if (uClass == null) {
            SpringUastAutowiredMembersChecker.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SpringUastAutowiredMembersChecker.$$$reportNull$$$0(1);
        }
        if (mappedBeanInfos == null) {
            SpringUastAutowiredMembersChecker.$$$reportNull$$$0(2);
        }
        if ((aClass = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)uClass, PsiClass.class)) == null) {
            return;
        }
        PsiElement sourcePsiElement = UElementKt.getSourcePsiElement((UElement)uClass);
        if (sourcePsiElement == null) {
            return;
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClassInSpringProject(aClass)) {
            return;
        }
        if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"org.springframework.web.context.support.SpringBeanAutowiringSupport")) {
            return;
        }
        if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"org.springframework.beans.factory.FactoryBean")) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
        if (!(module == null || !SpringCommonUtils.isSpringConfigured(module) || (info = mappedBeanInfos.get(aClass)) == null || info.isStereotypeJavaBean() || SpringUastAutowiredMembersChecker.isSpringComponent(aClass, info) || SpringTestContextUtil.getInstance().isTestContextConfigurationClass(aClass) || SpringUastAutowiredMembersChecker.constraintValidator(aClass))) {
            for (PsiField psiField : aClass.getFields()) {
                SpringUastAutowiredMembersChecker.checkMemberIsNotAutowired(holder, (PsiMember)psiField);
            }
            for (PsiField psiField : aClass.getMethods()) {
                SpringUastAutowiredMembersChecker.checkMemberIsNotAutowired(holder, (PsiMember)psiField);
            }
        }
    }

    private static boolean constraintValidator(@NotNull PsiClass aClass) {
        if (aClass == null) {
            SpringUastAutowiredMembersChecker.$$$reportNull$$$0(3);
        }
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"javax.validation.ConstraintValidator") || InheritanceUtil.isInheritor((PsiClass)aClass, (String)"jakarta.validation.ConstraintValidator");
    }

    private static void checkMemberIsNotAutowired(ProblemsHolder holder, PsiMember psiMember) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiMember, (boolean)true, (String[])new String[]{"org.springframework.beans.factory.annotation.Autowired"});
        if (annotation == null) {
            return;
        }
        UAnnotation uAnnotation = (UAnnotation)UastContextKt.toUElement((PsiElement)annotation, UAnnotation.class);
        if (uAnnotation == null) {
            return;
        }
        PsiElement annotationSourcePsi = uAnnotation.getSourcePsi();
        if (annotationSourcePsi == null) {
            return;
        }
        if (annotationSourcePsi.getContainingFile() != holder.getFile()) {
            return;
        }
        PsiElement elementToReport = UAnnotationKt.getNamePsiElement((UAnnotation)uAnnotation);
        if (elementToReport == null) {
            return;
        }
        holder.registerProblem(elementToReport, SpringBundle.message("class.is.not.spring.bean.autowired", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
    }

    private static boolean isSpringComponent(@NotNull PsiClass aClass, SpringJavaClassInfo.MappedBeanInfo info) {
        if (aClass == null) {
            SpringUastAutowiredMembersChecker.$$$reportNull$$$0(4);
        }
        return info.isMapped() || SpringUastAutowiredMembersChecker.isJamSpringComponent(aClass) || SpringUastAutowiredMembersChecker.isAbstractBaseComponent(aClass);
    }

    private static boolean isJamSpringComponent(@NotNull PsiClass aClass) {
        if (aClass == null) {
            SpringUastAutowiredMembersChecker.$$$reportNull$$$0(5);
        }
        return SpringCommonUtils.isStereotypeComponentOrMeta(aClass) || SpringTestContextUtil.getInstance().isTestContextConfigurationClass(aClass) || SpringUastAutowiredMembersChecker.isAbstractConfiguration(aClass) || AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, Arrays.asList("javax.servlet.annotation.WebServlet", "jakarta.servlet.annotation.WebServlet"), (int)1) || AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, Arrays.asList("javax.ws.rs.Path", "jakarta.ws.rs.Path"), (int)1) || AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"org.springframework.test.context.ContextHierarchy", (int)1) || AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"org.springframework.beans.factory.annotation.Configurable", (int)1) || InheritanceUtil.isInheritor((PsiClass)aClass, (String)"org.springframework.data.repository.Repository");
    }

    private static boolean isAbstractConfiguration(@NotNull PsiClass aClass) {
        if (aClass == null) {
            SpringUastAutowiredMembersChecker.$$$reportNull$$$0(6);
        }
        return aClass.hasModifierProperty("abstract") && AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"org.springframework.context.annotation.Configuration", (int)1);
    }

    private static boolean isAbstractBaseComponent(@NotNull PsiClass aClass) {
        if (aClass == null) {
            SpringUastAutowiredMembersChecker.$$$reportNull$$$0(7);
        }
        Ref ref = new Ref();
        ref.set((Object)false);
        PsiModifierList modifierList = aClass.getModifierList();
        if (modifierList != null && modifierList.hasModifierProperty("abstract")) {
            ClassInheritorsSearch.search((PsiClass)aClass).forEach(psiClass -> {
                if (SpringUastAutowiredMembersChecker.isJamSpringComponent(psiClass)) {
                    ref.set((Object)true);
                    return false;
                }
                return true;
            });
        }
        return (Boolean)ref.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappedBeanInfos";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/highlighting/autowire/SpringUastAutowiredMembersChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "constraintValidator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isSpringComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isJamSpringComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isAbstractConfiguration";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isAbstractBaseComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

