/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.MakeVoidQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.model.highlighting.jam.MethodParametersRemovingFix;
import com.intellij.spring.model.highlighting.jam.SpringJavaInspectionBase;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/spring/model/highlighting/jam/ScheduledMethodInspection;", "Lcom/intellij/spring/model/highlighting/jam/SpringJavaInspectionBase;", "<init>", "()V", "checkMethod", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiMethod;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.spring.core"})
@SourceDebugExtension(value={"SMAP\nScheduledMethodInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScheduledMethodInspection.kt\ncom/intellij/spring/model/highlighting/jam/ScheduledMethodInspection\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,88:1\n37#2,2:89\n*S KotlinDebug\n*F\n+ 1 ScheduledMethodInspection.kt\ncom/intellij/spring/model/highlighting/jam/ScheduledMethodInspection\n*L\n38#1:89,2\n*E\n"})
public final class ScheduledMethodInspection
extends SpringJavaInspectionBase {
    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (SpringLibraryUtil.isAtLeastVersion(ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiMethod)), SpringLibraryUtil.SpringVersion.V_6_0)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiMethod), (Collection)CollectionsKt.listOf((Object)"org.springframework.scheduling.annotation.Scheduled"))) {
            PsiIdentifier psiIdentifier;
            SmartList fixes = new SmartList();
            if (!Intrinsics.areEqual((Object)PsiTypes.voidType(), (Object)psiMethod.getReturnType())) {
                fixes.add((Object)new MakeVoidQuickFix(null));
            }
            if (psiMethod.getParameterList().getParametersCount() > 0) {
                fixes.add((Object)new MethodParametersRemovingFix(psiMethod));
            }
            if (!((Collection)fixes).isEmpty() && (psiIdentifier = psiMethod.getNameIdentifier()) != null) {
                ProblemsHolder problemsHolder;
                PsiIdentifier it = psiIdentifier;
                boolean bl = false;
                ProblemsHolder $this$checkMethod_u24lambda_u241_u24lambda_u240 = problemsHolder = new ProblemsHolder(manager, psiMethod.getContainingFile(), isOnTheFly);
                boolean bl2 = false;
                Collection $this$toTypedArray$iv = (Collection)fixes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
                $this$checkMethod_u24lambda_u241_u24lambda_u240.registerProblem((PsiElement)it, SpringBundle.message("ScheduledMethodInspection.incorrect.signature", new Object[0]), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                return problemsHolder.getResultsArray();
            }
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }
}

