/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.uast.UastHintedVisitorAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J*\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u001e\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/spring/model/highlighting/jam/SpringConfigurationProxyMethodsInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "hints", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "[Ljava/lang/Class;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isSpringComponentOrBeanSource", "sourcePsiClass", "Lcom/intellij/psi/PsiClass;", "checkMethodCall", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "configurationAnnotation", "Lcom/intellij/spring/model/jam/stereotype/SpringConfiguration;", "intellij.spring.core"})
public final class SpringConfigurationProxyMethodsInspection
extends LocalInspectionTool {
    @NotNull
    private final Class<? extends UElement>[] hints;

    public SpringConfigurationProxyMethodsInspection() {
        Class[] classArray = new Class[]{UCallExpression.class};
        this.hints = classArray;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)holder.getFile()));
        if (module == null || !SpringCommonUtils.isSpringConfigured(module)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        return UastHintedVisitorAdapter.Companion.create$default((UastHintedVisitorAdapter.Companion)UastHintedVisitorAdapter.Companion, (Language)language, (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(this, holder){
            final /* synthetic */ SpringConfigurationProxyMethodsInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public boolean visitCallExpression(UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.visit(node);
                return super.visitCallExpression(node);
            }

            private final void visit(UCallExpression node) {
                if (node.hasKind(UastCallKind.METHOD_CALL)) {
                    UElement $this$getParentOfType_u24default$iv = (UElement)node;
                    boolean strict$iv = true;
                    boolean $i$f$getParentOfType22 = false;
                    UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UMethod.class, (boolean)strict$iv);
                    UDeclaration $i$f$getParentOfType22 = UDeclarationKt.getContainingDeclaration((UElement)((UElement)uMethod));
                    UClass uClass = $i$f$getParentOfType22 instanceof UClass ? (UClass)$i$f$getParentOfType22 : null;
                    if (uClass == null) {
                        return;
                    }
                    UClass uClass2 = uClass;
                    PsiClass sourcePsiClass = uClass2.getJavaPsi();
                    if (!SpringCommonUtils.isSpringBeanCandidateClass(sourcePsiClass)) {
                        return;
                    }
                    SpringConfiguration configurationAnnotation = (SpringConfiguration)SpringConfiguration.META.getJamElement((PsiModifierListOwner)sourcePsiClass);
                    if (configurationAnnotation != null && configurationAnnotation.isProxyBeanMethods()) {
                        return;
                    }
                    if (!SpringConfigurationProxyMethodsInspection.access$isSpringComponentOrBeanSource(this.this$0, sourcePsiClass)) {
                        return;
                    }
                    SpringConfigurationProxyMethodsInspection.access$checkMethodCall(this.this$0, node, configurationAnnotation, sourcePsiClass, this.$holder);
                }
            }
        }, (Class[])this.hints, (boolean)false, (int)8, null);
    }

    private final boolean isSpringComponentOrBeanSource(PsiClass sourcePsiClass) {
        if (SpringCommonUtils.isConfigurationOrMeta(sourcePsiClass)) {
            return true;
        }
        return SpringCommonUtils.isStereotypeComponentOrMeta(sourcePsiClass);
    }

    private final void checkMethodCall(UCallExpression node, SpringConfiguration configurationAnnotation, PsiClass sourcePsiClass, ProblemsHolder holder) {
        UIdentifier uIdentifier = node.getMethodIdentifier();
        if (uIdentifier == null || (uIdentifier = uIdentifier.getSourcePsi()) == null) {
            return;
        }
        UIdentifier methodName = uIdentifier;
        PsiMethod psiMethod = node.resolve();
        if (psiMethod == null) {
            return;
        }
        PsiMethod callExprMethod = psiMethod;
        PsiClass psiClass = callExprMethod.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass callTargetClass = psiClass;
        if (ContextJavaBean.METHOD_META.getJamElement((PsiModifierListOwner)callExprMethod) == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)sourcePsiClass, (PsiClass)callTargetClass, (boolean)true)) {
            return;
        }
        String message = configurationAnnotation != null ? SpringBundle.message("bean.method.called.from.configuration.without.proxy", new Object[0]) : SpringBundle.message("bean.method.called.without.proxy", new Object[0]);
        holder.registerProblem((PsiElement)methodName, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
    }

    public static final /* synthetic */ boolean access$isSpringComponentOrBeanSource(SpringConfigurationProxyMethodsInspection $this, PsiClass sourcePsiClass) {
        return $this.isSpringComponentOrBeanSource(sourcePsiClass);
    }

    public static final /* synthetic */ void access$checkMethodCall(SpringConfigurationProxyMethodsInspection $this, UCallExpression node, SpringConfiguration configurationAnnotation, PsiClass sourcePsiClass, ProblemsHolder holder) {
        $this.checkMethodCall(node, configurationAnnotation, sourcePsiClass, holder);
    }
}

