/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.openapi.impl.JavaRenameRefactoringImpl;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.SpringJavaExternalBean;
import com.intellij.spring.model.jam.javaConfig.SpringOldJavaConfigurationUtil;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringExternalBeanReferencesRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            SpringExternalBeanReferencesRenameHandler.$$$reportNull$$$0(0);
        }
        return false;
    }

    public boolean isRenaming(@NotNull DataContext dataContext) {
        DomSpringBean springBean;
        if (dataContext == null) {
            SpringExternalBeanReferencesRenameHandler.$$$reportNull$$$0(1);
        }
        if ((springBean = SpringExternalBeanReferencesRenameHandler.getTargetSpringBean(dataContext)) == null) {
            return false;
        }
        List<SpringJavaExternalBean> list = SpringOldJavaConfigurationUtil.findExternalBeanReferences(springBean);
        return list.size() > 0;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        DomSpringBean springBean;
        if (project == null) {
            SpringExternalBeanReferencesRenameHandler.$$$reportNull$$$0(2);
        }
        if ((springBean = SpringExternalBeanReferencesRenameHandler.getTargetSpringBean(dataContext)) != null) {
            ExternalBeanRenameDialog dialog = new ExternalBeanRenameDialog(springBean, editor);
            dialog.show();
        }
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            SpringExternalBeanReferencesRenameHandler.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            SpringExternalBeanReferencesRenameHandler.$$$reportNull$$$0(4);
        }
    }

    public static void doRename(DomSpringBean externalBean, String newName, boolean searchInComments) {
        PsiElement psiElement = BeanService.getInstance().createSpringBeanPointer(externalBean).getPsiElement();
        if (psiElement == null) {
            return;
        }
        JavaRenameRefactoringImpl rename = new JavaRenameRefactoringImpl(psiElement.getProject(), psiElement, newName, searchInComments, false);
        HashSet<PsiElement> psiElements = new HashSet<PsiElement>();
        List<SpringJavaExternalBean> list = SpringOldJavaConfigurationUtil.findExternalBeanReferences(externalBean);
        for (SpringJavaExternalBean springBean : list) {
            psiElements.add(springBean.getIdentifyingPsiElement());
            for (SpringBeanPointer<?> pointer : SpringOldJavaConfigurationUtil.findExternalBeans(springBean.getPsiElement())) {
                if (pointer.isReferenceTo(externalBean)) continue;
                ContainerUtil.addIfNotNull(psiElements, (Object)pointer.getPsiElement());
            }
            for (PsiElement element : psiElements) {
                rename.addElement(element, newName);
            }
        }
        rename.run();
    }

    @Nullable
    private static DomSpringBean getTargetSpringBean(DataContext dataContext) {
        DomElement element;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            PsiElement targetPsiElement = TargetElementUtil.findTargetElement((Editor)editor, (int)1);
            CommonSpringBean value = SpringBeanUtils.getInstance().findBean(targetPsiElement);
            if (value instanceof DomSpringBean) {
                return (DomSpringBean)value;
            }
        }
        return (element = DomUtil.getContextElement((Editor)editor)) instanceof DomSpringBean && !(element instanceof CustomBeanWrapper) ? (DomSpringBean)element : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/highlighting/jam/SpringExternalBeanReferencesRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isRenaming";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ExternalBeanRenameDialog
    extends RenameDialog {
        private final DomSpringBean myExternalBean;

        protected ExternalBeanRenameDialog(DomSpringBean externalBean, Editor editor) {
            super(editor.getProject(), (PsiElement)externalBean.getXmlTag(), null, editor);
            this.myExternalBean = externalBean;
        }

        protected void doAction() {
            String newName = this.getNewName();
            boolean searchInComments = this.isSearchInComments();
            SpringExternalBeanReferencesRenameHandler.doRename(this.myExternalBean, newName, searchInComments);
            this.close(0);
        }
    }
}

