/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelVisitor;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.spring.model.xml.beans.SpringKey;
import com.intellij.spring.model.xml.beans.SpringRef;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.spring.model.xml.beans.SpringValueHolder;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.spring.model.xml.beans.TypeHolderUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectionValueStyleInspection
extends SpringBeanInspectionBase {
    @NonNls
    private static final String KEY = "key";
    @NonNls
    private static final String VALUE = "value";
    @NonNls
    private static final String VALUE_REF = "value-ref";
    @NonNls
    private static final String KEY_REF = "key-ref";
    @NonNls
    private static final String REF = "ref";

    @Override
    protected SpringModelVisitor createVisitor(final DomElementAnnotationHolder holder, @NotNull Beans beans, @Nullable CommonSpringModel model) {
        if (beans == null) {
            InjectionValueStyleInspection.$$$reportNull$$$0(0);
        }
        return new SpringModelVisitor(){

            @Override
            protected boolean visitValueHolder(SpringValueHolder valueHolder) {
                InjectionValueStyleInspection.checkValueHolder(holder, valueHolder);
                return true;
            }
        };
    }

    private static void checkValueHolder(DomElementAnnotationHolder holder, @NotNull SpringValueHolderDefinition valueHolder) {
        if (valueHolder == null) {
            InjectionValueStyleInspection.$$$reportNull$$$0(1);
        }
        InjectionValueStyleInspection.checkValue(valueHolder, holder);
        InjectionValueStyleInspection.checkRefBean(valueHolder, holder);
        if (valueHolder instanceof SpringEntry) {
            InjectionValueStyleInspection.checkValue(((SpringEntry)valueHolder).getKey(), holder);
            InjectionValueStyleInspection.checkRefBean(((SpringEntry)valueHolder).getKey(), holder);
        }
    }

    private static void checkValue(@NotNull SpringValueHolderDefinition valueHolder, DomElementAnnotationHolder holder) {
        String s;
        PsiType type;
        if (valueHolder == null) {
            InjectionValueStyleInspection.$$$reportNull$$$0(2);
        }
        if ((type = TypeHolderUtil.getRequiredType(valueHolder)) != null && Properties.class.getName().equals(type.getCanonicalText())) {
            return;
        }
        GenericDomValue<?> value = valueHolder.getValueElement();
        if (!(value == null || value instanceof GenericAttributeValue || (s = value.getRawText()) == null || InjectionValueStyleInspection.isMultiline(s) || value instanceof SpringValue && DomUtil.hasXml(((SpringValue)value).getType()))) {
            XmlTag tag = value.getXmlTag();
            if (tag != null && tag.getValue().hasCDATA()) {
                return;
            }
            ValueQuickFix fix2 = new ValueQuickFix(valueHolder instanceof SpringKey);
            holder.createProblem(value, HighlightSeverity.ERROR, SpringBundle.message("model.inspection.injection.value.style.message", new Object[0]), new LocalQuickFix[]{fix2}).highlightWholeElement();
        }
    }

    private static boolean isMultiline(String s) {
        return s.trim().indexOf(10) >= 0;
    }

    private static void checkRefBean(SpringValueHolderDefinition valueHolder, DomElementAnnotationHolder holder) {
        SpringRef ref;
        GenericAttributeValue<SpringBeanPointer<?>> bean;
        if (valueHolder instanceof SpringValueHolder && DomUtil.hasXml(bean = (ref = ((SpringValueHolder)valueHolder).getRef()).getBean())) {
            RefQuickFix fix2 = new RefQuickFix(InjectionValueStyleInspection.geValueHolderType((SpringValueHolder)valueHolder));
            holder.createProblem((DomElement)ref, HighlightSeverity.ERROR, SpringBundle.message("model.inspection.injection.value.style.ref.message", new Object[0]), new LocalQuickFix[]{fix2}).highlightWholeElement();
        }
    }

    @NotNull
    private static String geValueHolderType(SpringValueHolder valueHolder) {
        if (valueHolder instanceof SpringKey) {
            return KEY_REF;
        }
        if (valueHolder instanceof SpringEntry) {
            return VALUE_REF;
        }
        return REF;
    }

    public static DomElement getDomElement(PsiElement element) {
        if (element instanceof XmlAttribute) {
            return DomManager.getDomManager((Project)element.getProject()).getDomElement((XmlAttribute)element);
        }
        if (element instanceof XmlTag) {
            return DomManager.getDomManager((Project)element.getProject()).getDomElement((XmlTag)element);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueHolder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/highlighting/xml/InjectionValueStyleInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkValueHolder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ValueQuickFix
    implements LocalQuickFix {
        private final boolean myKeyDefinition;

        ValueQuickFix(boolean key) {
            this.myKeyDefinition = key;
        }

        @NotNull
        public String getName() {
            String string = SpringBundle.message("model.inspection.injection.value.style.value.fix", this.myKeyDefinition ? InjectionValueStyleInspection.KEY : InjectionValueStyleInspection.VALUE);
            if (string == null) {
                ValueQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("model.inspection.injection.value.style.value.fix.family.name", new Object[0]);
            if (string == null) {
                ValueQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            XmlElement xmlElement;
            if (project == null) {
                ValueQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                ValueQuickFix.$$$reportNull$$$0(3);
            }
            SpringValueHolderDefinition valueHolderDefinition = null;
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement instanceof XmlElement) {
                DomElement parent;
                xmlElement = (XmlElement)psiElement;
                DomElement element = InjectionValueStyleInspection.getDomElement((PsiElement)xmlElement);
                if (element instanceof SpringValueHolderDefinition) {
                    valueHolderDefinition = (SpringValueHolderDefinition)element;
                }
                if (element != null && (parent = element.getParent()) instanceof SpringValueHolderDefinition) {
                    valueHolderDefinition = (SpringValueHolderDefinition)parent;
                }
            }
            if (valueHolderDefinition == null) {
                return;
            }
            xmlElement = valueHolderDefinition.getXmlElement();
            if (xmlElement == null) {
                return;
            }
            GenericDomValue<?> valueElement = valueHolderDefinition.getValueElement();
            assert (valueElement != null);
            String val = valueElement.getRawText();
            if (valueHolderDefinition instanceof SpringKey) {
                SpringEntry entry = (SpringEntry)valueHolderDefinition.getParent();
                assert (entry != null);
                entry.getKeyAttr().setStringValue(val);
                valueHolderDefinition.undefine();
                XmlTag tag = entry.getXmlTag();
                assert (tag != null);
                tag.collapseIfEmpty();
            } else {
                if (valueHolderDefinition instanceof SpringValueHolder) {
                    SpringValueHolder holder = (SpringValueHolder)valueHolderDefinition;
                    holder.getValueAttr().undefine();
                    holder.getValue().undefine();
                }
                GenericDomValue<?> element = valueHolderDefinition.getValueElement();
                assert (element != null);
                element.setStringValue(val);
                XmlTag tag = valueHolderDefinition.getXmlTag();
                assert (tag != null);
                tag.collapseIfEmpty();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/highlighting/xml/InjectionValueStyleInspection$ValueQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/highlighting/xml/InjectionValueStyleInspection$ValueQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class RefQuickFix
    implements LocalQuickFix {
        private final String myValueHolderType;

        RefQuickFix(@NotNull String valueHolderType) {
            if (valueHolderType == null) {
                RefQuickFix.$$$reportNull$$$0(0);
            }
            this.myValueHolderType = valueHolderType;
        }

        @NotNull
        public String getName() {
            String string = SpringBundle.message("model.inspection.injection.value.style.ref.fix", this.myValueHolderType);
            if (string == null) {
                RefQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("model.inspection.injection.value.style.ref.fix.family.name", new Object[0]);
            if (string == null) {
                RefQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            DomElement element;
            XmlElement xmlElement;
            if (project == null) {
                RefQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                RefQuickFix.$$$reportNull$$$0(4);
            }
            SpringValueHolder springValueHolder = null;
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement instanceof XmlElement) {
                DomElement parent;
                xmlElement = (XmlElement)psiElement;
                element = InjectionValueStyleInspection.getDomElement((PsiElement)xmlElement);
                if (element instanceof SpringValueHolder) {
                    springValueHolder = (SpringValueHolder)element;
                }
                if (element != null && (parent = element.getParent()) instanceof SpringValueHolder) {
                    springValueHolder = (SpringValueHolder)parent;
                }
            }
            if (springValueHolder == null) {
                return;
            }
            xmlElement = springValueHolder.getXmlElement();
            if (xmlElement == null) {
                return;
            }
            element = springValueHolder.getXmlElement();
            if (element == null) {
                return;
            }
            String val = springValueHolder.getRef().getBean().getRawText();
            if (springValueHolder instanceof SpringKey) {
                SpringEntry entry = (SpringEntry)springValueHolder.getParent();
                assert (entry != null);
                entry.getKeyRef().setStringValue(val);
                springValueHolder.undefine();
                XmlTag tag = entry.getXmlTag();
                assert (tag != null);
                tag.collapseIfEmpty();
            } else {
                springValueHolder.getRefAttr().setStringValue(val);
                springValueHolder.getRef().undefine();
                XmlTag tag = springValueHolder.getXmlTag();
                assert (tag != null);
                tag.collapseIfEmpty();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueHolderType";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/highlighting/xml/InjectionValueStyleInspection$RefQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/highlighting/xml/InjectionValueStyleInspection$RefQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

