/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.highlighting.xml.quickfixes.AddSpringDomElementQuickFix;
import com.intellij.spring.model.jam.javaConfig.SpringJavaConfiguration;
import com.intellij.spring.model.jam.javaConfig.SpringOldJavaConfigurationUtil;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringBeanInstantiationInspection
extends SpringBeanInspectionBase {
    @Override
    protected void checkBean(@NotNull SpringBean springBean, @NotNull Beans beans, @NotNull DomElementAnnotationHolder holder, @Nullable CommonSpringModel springModel) {
        PsiClass psiClass;
        if (springBean == null) {
            SpringBeanInstantiationInspection.$$$reportNull$$$0(0);
        }
        if (beans == null) {
            SpringBeanInstantiationInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            SpringBeanInstantiationInspection.$$$reportNull$$$0(2);
        }
        if ((psiClass = (PsiClass)springBean.getClazz().getValue()) != null && !springBean.isAbstract() && psiClass.hasModifierProperty("abstract")) {
            boolean lookup;
            boolean factory = DomUtil.hasXml(springBean.getFactoryMethod());
            boolean bl = lookup = SpringBeanInstantiationInspection.hasLookupMethods(springBean) || SpringBeanInstantiationInspection.hasAnnotatedLookupMethods(psiClass);
            if (!(factory || lookup || SpringBeanInstantiationInspection.isJavaConfigBean(springBean))) {
                holder.createProblem(springBean.getClazz(), HighlightSeverity.WARNING, psiClass.isInterface() ? SpringBundle.message("interface.not.allowed", new Object[0]) : SpringBundle.message("abstract.class.not.allowed", new Object[0]), new LocalQuickFix[]{new MarkAbstractFix()});
            }
        }
    }

    private static boolean hasLookupMethods(@NotNull SpringBean springBean) {
        if (springBean == null) {
            SpringBeanInstantiationInspection.$$$reportNull$$$0(3);
        }
        return SpringBeanInstantiationInspection.hasLookupMethods(springBean, new HashSet<SpringBean>());
    }

    private static boolean hasLookupMethods(@NotNull SpringBean springBean, @NotNull Set<SpringBean> visited) {
        Object bean;
        SpringBeanPointer parent;
        if (springBean == null) {
            SpringBeanInstantiationInspection.$$$reportNull$$$0(4);
        }
        if (visited == null) {
            SpringBeanInstantiationInspection.$$$reportNull$$$0(5);
        }
        if (visited.contains(springBean)) {
            return false;
        }
        if (springBean.getLookupMethods().size() > 0) {
            return true;
        }
        visited.add(springBean);
        GenericAttributeValue<SpringBeanPointer<?>> parentBeanValue = springBean.getParentBean();
        if (DomUtil.hasXml(parentBeanValue) && (parent = (SpringBeanPointer)parentBeanValue.getValue()) != null && (bean = parent.getSpringBean()) instanceof SpringBean) {
            return SpringBeanInstantiationInspection.hasLookupMethods((SpringBean)bean, visited);
        }
        return false;
    }

    private static boolean hasAnnotatedLookupMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringBeanInstantiationInspection.$$$reportNull$$$0(6);
        }
        for (PsiMethod method : psiClass.getAllMethods()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.springframework.beans.factory.annotation.Lookup", (int)0)) continue;
            return true;
        }
        return false;
    }

    private static boolean isJavaConfigBean(SpringBean springBean) {
        Module module;
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (DomUtil.hasXml((DomElement)springBean) && beanClass != null && (module = springBean.getModule()) != null) {
            for (SpringJavaConfiguration springJavaConfiguration : SpringOldJavaConfigurationUtil.getJavaConfigurations(module)) {
                if (!beanClass.equals(springJavaConfiguration.getPsiClass())) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/highlighting/xml/SpringBeanInstantiationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkBean";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasLookupMethods";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hasAnnotatedLookupMethods";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MarkAbstractFix
    extends AddSpringDomElementQuickFix<SpringBean, GenericAttributeValue<Boolean>> {
        MarkAbstractFix() {
            super(SpringBean.class, bean -> {
                GenericAttributeValue<Boolean> attributeValue = bean.getAbstract();
                attributeValue.setValue((Object)true);
                return attributeValue;
            }, SpringBundle.message("mark.bean.as.abstract", new Object[0]));
        }
    }
}

