/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.actions.generate.SpringPropertiesGenerateProvider;
import com.intellij.spring.model.actions.generate.SpringTemplateBuilder;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringRequiredPropertyInspection
extends SpringBeanInspectionBase {
    @Override
    protected void checkBean(@NotNull SpringBean springBean, @NotNull Beans beans, @NotNull DomElementAnnotationHolder holder, @Nullable CommonSpringModel springModel) {
        if (springBean == null) {
            SpringRequiredPropertyInspection.$$$reportNull$$$0(0);
        }
        if (beans == null) {
            SpringRequiredPropertyInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            SpringRequiredPropertyInspection.$$$reportNull$$$0(2);
        }
        if (springBean.isAbstract()) {
            return;
        }
        if (springModel == null) {
            return;
        }
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (psiClass == null) {
            return;
        }
        Map properties = PropertyUtilBase.getAllProperties((PsiClass)psiClass, (boolean)true, (boolean)false);
        List<SpringPropertyDefinition> definedProperties = springBean.getAllProperties();
        SmartList missing = new SmartList();
        SmartList missingMethods = new SmartList();
        for (Map.Entry entry : properties.entrySet()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)entry.getValue()), (String)"org.springframework.beans.factory.annotation.Required", (int)0) || SpringRequiredPropertyInspection.isDefined(definedProperties, (String)entry.getKey()) || SpringAutowireUtil.isAutowired(springBean, springModel, (PsiMethod)entry.getValue())) continue;
            missing.add((String)entry.getKey());
            missingMethods.add((PsiMethod)entry.getValue());
        }
        if (missing.isEmpty()) {
            return;
        }
        GenericAttributeValue<PsiClass> element = DomUtil.hasXml(springBean.getClazz()) ? springBean.getClazz() : springBean;
        holder.createProblem(element, HighlightSeverity.ERROR, SpringBundle.message("required.properties.missed", StringUtil.join((Collection)missing, (String)",")), new LocalQuickFix[]{new LocalQuickFix(){
            final /* synthetic */ SpringBean val$springBean;
            final /* synthetic */ List val$missingMethods;
            {
                this.val$springBean = springBean;
                this.val$missingMethods = list;
            }

            @NotNull
            public String getFamilyName() {
                String string = SpringBundle.message("create.missing.properties", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    1.$$$reportNull$$$0(2);
                }
                Editor editor = SpringTemplateBuilder.getEditor(descriptor);
                SpringPropertiesGenerateProvider.doGenerate(editor, this.val$springBean, project, this.val$missingMethods.toArray(PsiMethod.EMPTY_ARRAY));
            }

            @NotNull
            public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
                if (project == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (previewDescriptor == null) {
                    1.$$$reportNull$$$0(4);
                }
                StringBuilder sb = new StringBuilder();
                for (PsiMethod method : this.val$missingMethods) {
                    @NonNls String propertyName = PropertyUtilBase.getPropertyName((PsiMethod)method);
                    sb.append("<property name=\"");
                    sb.append(propertyName);
                    sb.append("\"");
                    sb.append(" value=\"..\"");
                    sb.append(" />");
                }
                return new IntentionPreviewInfo.CustomDiff((FileType)XmlFileType.INSTANCE, "", sb.toString());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3, 4 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/model/highlighting/xml/SpringRequiredPropertyInspection$1";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "previewDescriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/model/highlighting/xml/SpringRequiredPropertyInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "generatePreview";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3, 4 -> new IllegalArgumentException(string);
                };
            }
        }});
    }

    private static boolean isDefined(List<SpringPropertyDefinition> list, String property) {
        for (SpringPropertyDefinition definition : list) {
            String name = definition.getPropertyName();
            if (name == null || !name.equals(property)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "springBean";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "beans";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/model/highlighting/xml/SpringRequiredPropertyInspection";
        objectArray[2] = "checkBean";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

