/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.javaConfig;

import com.intellij.jam.JamService;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.javaConfig.JavaConfigConfiguration;
import com.intellij.spring.model.jam.javaConfig.SpringJavaExternalBean;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringOldJavaConfigurationUtil {
    public static List<JavaConfigConfiguration> getJavaConfigurations(@NotNull Module module) {
        if (module == null) {
            SpringOldJavaConfigurationUtil.$$$reportNull$$$0(0);
        }
        if (!JavaLibraryUtil.hasLibraryClass((Module)module, (String)"org.springframework.config.java.annotation.Configuration")) {
            return Collections.emptyList();
        }
        JamService jamService = JamService.getJamService((Project)module.getProject());
        return jamService.getJamClassElements(JavaConfigConfiguration.META, "org.springframework.config.java.annotation.Configuration", SpringGlobalSearchScopes.runtime(module));
    }

    @NotNull
    public static List<SpringBeanPointer<?>> findExternalBeans(PsiMethod psiMethod) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiMethod);
        PsiClass psiClass = psiMethod.getContainingClass();
        if (module == null || psiClass == null) {
            List<SpringBeanPointer<?>> list = Collections.emptyList();
            if (list == null) {
                SpringOldJavaConfigurationUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (SpringOldJavaConfigurationUtil.getExternalBean(psiMethod) == null) {
            List<SpringBeanPointer<?>> list = Collections.emptyList();
            if (list == null) {
                SpringOldJavaConfigurationUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        SmartList extBeans = new SmartList();
        for (SpringModel model : SpringManager.getInstance(psiMethod.getProject()).getAllModels(module)) {
            boolean hasJavaConfigBean = SpringModelSearchers.doesBeanExist((CommonSpringModel)model, SpringModelSearchParameters.byClass(psiClass));
            if (!hasJavaConfigBean) continue;
            String externalBeanName = psiMethod.getName();
            for (SpringBeanPointer<?> springBean : SpringModelVisitorUtils.getAllDomBeans(model)) {
                String beanName = springBean.getName();
                if (!externalBeanName.equals(beanName) && !Arrays.asList(springBean.getAliases()).contains(externalBeanName)) continue;
                extBeans.add(springBean);
            }
        }
        if (extBeans.isEmpty()) {
            List<SpringBeanPointer<?>> list = Collections.emptyList();
            if (list == null) {
                SpringOldJavaConfigurationUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        SmartList smartList = extBeans;
        if (smartList == null) {
            SpringOldJavaConfigurationUtil.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    @NotNull
    public static List<SpringJavaExternalBean> findExternalBeanReferences(CommonSpringBean springBean) {
        XmlTag element = springBean.getXmlTag();
        if (element == null) {
            List<SpringJavaExternalBean> list = Collections.emptyList();
            if (list == null) {
                SpringOldJavaConfigurationUtil.$$$reportNull$$$0(5);
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            List<SpringJavaExternalBean> list = Collections.emptyList();
            if (list == null) {
                SpringOldJavaConfigurationUtil.$$$reportNull$$$0(6);
            }
            return list;
        }
        Set<String> beanNames = SpringBeanUtils.getInstance().findBeanNames(springBean);
        if (beanNames.isEmpty()) {
            List<SpringJavaExternalBean> list = Collections.emptyList();
            if (list == null) {
                SpringOldJavaConfigurationUtil.$$$reportNull$$$0(7);
            }
            return list;
        }
        ArrayList<SpringJavaExternalBean> extBeans = new ArrayList<SpringJavaExternalBean>();
        for (JavaConfigConfiguration javaConfiguration : SpringOldJavaConfigurationUtil.getJavaConfigurations(module)) {
            for (SpringJavaExternalBean springJavaExternalBean : javaConfiguration.getExternalBeans()) {
                PsiMethod psiMethod = springJavaExternalBean.getPsiElement();
                if (!beanNames.contains(psiMethod.getName())) continue;
                extBeans.add(springJavaExternalBean);
            }
        }
        ArrayList<SpringJavaExternalBean> arrayList = extBeans;
        if (arrayList == null) {
            SpringOldJavaConfigurationUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Nullable
    public static SpringJavaExternalBean getExternalBean(PsiMethod psiMethod) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiMethod);
        if (module != null) {
            for (JavaConfigConfiguration javaConfiguration : SpringOldJavaConfigurationUtil.getJavaConfigurations(module)) {
                if (!psiMethod.getContainingFile().equals(javaConfiguration.getPsiClass().getContainingFile())) continue;
                for (SpringJavaExternalBean springJavaExternalBean : javaConfiguration.getExternalBeans()) {
                    if (!psiMethod.equals(springJavaExternalBean.getPsiElement())) continue;
                    return springJavaExternalBean;
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/javaConfig/SpringOldJavaConfigurationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/javaConfig/SpringOldJavaConfigurationUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findExternalBeans";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findExternalBeanReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getJavaConfigurations";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

