/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.logical;

import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiVariable;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.stereotype.SpringController;
import com.intellij.spring.model.jam.stereotype.SpringRepository;
import com.intellij.spring.model.logical.SpringBeansParentLogicalModel;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/spring/model/logical/SpringBeansParentLogicalModelPresentationProvider;", "Lcom/intellij/ide/presentation/PresentationProvider;", "Lcom/intellij/spring/model/logical/SpringBeansParentLogicalModel;", "<init>", "()V", "getName", "", "t", "getIcon", "Ljavax/swing/Icon;", "getTypeName", "intellij.spring"})
public final class SpringBeansParentLogicalModelPresentationProvider
extends PresentationProvider<SpringBeansParentLogicalModel> {
    @NotNull
    public String getName(@NotNull SpringBeansParentLogicalModel t) {
        String string;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (!t.isValid()) {
            return "";
        }
        PsiElement psiElement = t.getNavigationElement();
        if (psiElement instanceof PsiMember) {
            string = ((PsiMember)psiElement).getName();
            if (string == null) {
                string = "???";
            }
        } else if (psiElement instanceof PsiVariable) {
            String string2 = ((PsiVariable)psiElement).getType().getPresentableText();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPresentableText(...)");
        } else {
            string = "???";
        }
        return string;
    }

    @NotNull
    public Icon getIcon(@NotNull SpringBeansParentLogicalModel t) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        CommonSpringBean commonSpringBean = (CommonSpringBean)CollectionsKt.first(t.getSpringBeans());
        if (commonSpringBean instanceof SpringRepository) {
            Icon icon2 = SpringApiIcons.SpringData;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"SpringData");
        } else if (commonSpringBean instanceof SpringController) {
            Icon icon3 = SpringApiIcons.SpringWeb;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"SpringWeb");
        } else if (commonSpringBean instanceof SpringConfiguration) {
            Icon icon4 = SpringApiIcons.SpringConfig;
            icon = icon4;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"SpringConfig");
        } else {
            Icon icon5 = SpringApiIcons.Spring;
            icon = icon5;
            Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Spring");
        }
        return icon;
    }

    @NotNull
    public String getTypeName(@NotNull SpringBeansParentLogicalModel t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return "";
    }
}

