/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.structure.logical;

import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.structureView.logical.ContainerElementsProvider;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.logical.SpringBeanLogicalModel;
import com.intellij.spring.model.logical.SpringProducedBeanLogicalModel;
import com.intellij.spring.model.structure.logical.SpringFactoryBeansPresentationProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Presentation(provider=SpringFactoryBeansPresentationProvider.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u000b\u001a\u00020\u0002H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/spring/model/structure/logical/SpringFactoryBeansProvider;", "Lcom/intellij/ide/structureView/logical/ContainerElementsProvider;", "Lcom/intellij/spring/model/logical/SpringBeanLogicalModel;", "<init>", "()V", "containerName", "", "getContainerName", "()Ljava/lang/String;", "isApplicable", "", "parent", "getElements", "", "getBeanMethods", "Lkotlin/sequences/Sequence;", "Lcom/intellij/psi/PsiMethod;", "intellij.spring.core"})
public final class SpringFactoryBeansProvider
implements ContainerElementsProvider<SpringBeanLogicalModel, SpringBeanLogicalModel> {
    @NotNull
    private final String containerName;

    public SpringFactoryBeansProvider() {
        this.containerName = "Beans";
    }

    @NotNull
    public String getContainerName() {
        return this.containerName;
    }

    public boolean isApplicable(@NotNull SpringBeanLogicalModel parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return SequencesKt.any(this.getBeanMethods(parent));
    }

    @NotNull
    public List<SpringBeanLogicalModel> getElements(@NotNull SpringBeanLogicalModel parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull(this.getBeanMethods(parent), SpringFactoryBeansProvider::getElements$lambda$0));
    }

    private final Sequence<PsiMethod> getBeanMethods(SpringBeanLogicalModel parent) {
        PsiType psiType = parent.getSpringBean().getBeanType();
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        if (psiClassType == null || (psiClassType = psiClassType.resolve()) == null) {
            return SequencesKt.emptySequence();
        }
        PsiClassType psiClass = psiClassType;
        PsiMethod[] psiMethodArray = psiClass.getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getMethods(...)");
        return SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])psiMethodArray), SpringFactoryBeansProvider::getBeanMethods$lambda$1);
    }

    private static final SpringProducedBeanLogicalModel getElements$lambda$0(PsiMethod it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ContextJavaBean contextJavaBean = (ContextJavaBean)ContextJavaBean.METHOD_META.getJamElement((PsiModifierListOwner)it);
        if (contextJavaBean == null) {
            return null;
        }
        ContextJavaBean springBean = contextJavaBean;
        return new SpringProducedBeanLogicalModel((PsiElement)it, springBean);
    }

    private static final boolean getBeanMethods$lambda$1(PsiMethod it) {
        return it.hasAnnotation("org.springframework.context.annotation.Bean");
    }
}

