/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.structure.logical.services;

import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.structureView.logical.ContainerElementsProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.jam.stereotype.SpringService;
import com.intellij.spring.model.logical.SpringBeanLogicalModel;
import com.intellij.spring.model.structure.logical.services.SpringServiceMethodLogicalModel;
import com.intellij.spring.model.structure.logical.services.SpringServiceMethodsPresentationProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Presentation(provider=SpringServiceMethodsPresentationProvider.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/intellij/spring/model/structure/logical/services/SpringServiceMethodsProvider;", "Lcom/intellij/ide/structureView/logical/ContainerElementsProvider;", "Lcom/intellij/spring/model/logical/SpringBeanLogicalModel;", "Lcom/intellij/spring/model/structure/logical/services/SpringServiceMethodLogicalModel;", "<init>", "()V", "containerName", "", "getContainerName", "()Ljava/lang/String;", "isApplicable", "", "parent", "getElements", "", "intellij.spring.core"})
@SourceDebugExtension(value={"SMAP\nSpringServiceMethodsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringServiceMethodsProvider.kt\ncom/intellij/spring/model/structure/logical/services/SpringServiceMethodsProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n11483#2,9:40\n13409#2:49\n13410#2:51\n11492#2:52\n1#3:50\n*S KotlinDebug\n*F\n+ 1 SpringServiceMethodsProvider.kt\ncom/intellij/spring/model/structure/logical/services/SpringServiceMethodsProvider\n*L\n24#1:40,9\n24#1:49\n24#1:51\n24#1:52\n24#1:50\n*E\n"})
public final class SpringServiceMethodsProvider
implements ContainerElementsProvider<SpringBeanLogicalModel, SpringServiceMethodLogicalModel> {
    @NotNull
    private final String containerName;

    public SpringServiceMethodsProvider() {
        this.containerName = "Service Methods";
    }

    @NotNull
    public String getContainerName() {
        return this.containerName;
    }

    public boolean isApplicable(@NotNull SpringBeanLogicalModel parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return parent.getSpringBean() instanceof SpringService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<SpringServiceMethodLogicalModel> getElements(@NotNull SpringBeanLogicalModel parent) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        CommonSpringBean commonSpringBean = parent.getSpringBean();
        SpringService springService = commonSpringBean instanceof SpringService ? (SpringService)commonSpringBean : null;
        if (springService == null) {
            return CollectionsKt.emptyList();
        }
        SpringService springService2 = springService;
        PsiMethod[] psiMethodArray = springService2.getPsiElement().getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getMethods(...)");
        Object[] $this$mapNotNull$iv = psiMethodArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            SpringServiceMethodLogicalModel springServiceMethodLogicalModel;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            PsiMethod it = (PsiMethod)element$iv$iv;
            boolean bl2 = false;
            if (it.isConstructor() || it.hasModifierProperty("private")) {
                springServiceMethodLogicalModel = null;
            } else {
                PsiClass psiClass = springService2.getPsiElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"getPsiElement(...)");
                Intrinsics.checkNotNull((Object)it);
                springServiceMethodLogicalModel = new SpringServiceMethodLogicalModel(psiClass, it);
            }
            if (springServiceMethodLogicalModel == null) continue;
            SpringServiceMethodLogicalModel it$iv$iv = springServiceMethodLogicalModel;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

