/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.model.utils.PsiTypeUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypeUtilImpl
extends PsiTypeUtil {
    private final Map<Class, Class[]> listOrSetConverters = new HashMap<Class, Class[]>();
    private final Project myProject;

    public PsiTypeUtilImpl(Project project) {
        this.myProject = project;
        Class[] classes = new Class[]{Object[].class, boolean[].class, byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class};
        this.listOrSetConverters.put(Set.class, classes);
        this.listOrSetConverters.put(List.class, classes);
    }

    @Override
    @Nullable
    public PsiType findType(@NotNull Class<?> aClass) {
        if (aClass == null) {
            PsiTypeUtilImpl.$$$reportNull$$$0(0);
        }
        if (aClass.isArray()) {
            Class<?> componentType = aClass.getComponentType();
            PsiType componentClassType = this.findType(componentType);
            return componentClassType != null ? componentClassType.createArrayType() : null;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        if (aClass.isPrimitive()) {
            return javaPsiFacade.getElementFactory().createPrimitiveType(aClass.getName());
        }
        PsiClass psiClass = javaPsiFacade.findClass(aClass.getName(), GlobalSearchScope.allScope((Project)this.myProject));
        if (psiClass == null) {
            return null;
        }
        return javaPsiFacade.getElementFactory().createType(psiClass);
    }

    @Override
    public boolean isCollectionType(@NotNull PsiType psiType) {
        PsiType collectionType;
        if (psiType == null) {
            PsiTypeUtilImpl.$$$reportNull$$$0(1);
        }
        return (collectionType = this.findType(Collection.class)) != null && collectionType.isAssignableFrom(psiType);
    }

    @Override
    public boolean isConvertable(@NotNull PsiType from, @NotNull List<? extends PsiType> types) {
        if (from == null) {
            PsiTypeUtilImpl.$$$reportNull$$$0(2);
        }
        if (types == null) {
            PsiTypeUtilImpl.$$$reportNull$$$0(3);
        }
        for (PsiType psiType : types) {
            if (psiType == null || !this.isConvertable(from, psiType)) continue;
            return true;
        }
        return false;
    }

    private boolean isConvertable(@NotNull PsiType from, @NotNull PsiType to) {
        if (from == null) {
            PsiTypeUtilImpl.$$$reportNull$$$0(4);
        }
        if (to == null) {
            PsiTypeUtilImpl.$$$reportNull$$$0(5);
        }
        if (to instanceof PsiClassType) {
            to = ((PsiClassType)to).rawType();
        }
        if (to.isAssignableFrom(from)) {
            return true;
        }
        if (from.equalsToText("java.lang.String") && PsiTypeUtilImpl.isStringConvertable(to)) {
            return true;
        }
        if (from.equalsToText("java.util.Set") && to.equalsToText("java.util.List") || to.equalsToText("java.util.Set") && from.equalsToText("java.util.List")) {
            return true;
        }
        if (to instanceof PsiArrayType) {
            PsiClass resolved;
            PsiType type = ((PsiArrayType)to).getComponentType();
            if (type.isAssignableFrom(from)) {
                return true;
            }
            if (from instanceof PsiClassType && InheritanceUtil.isInheritor((PsiClass)(resolved = ((PsiClassType)from).resolve()), (String)"java.util.Collection")) {
                return true;
            }
        }
        if (to instanceof PsiClassType && InheritanceUtil.isInheritor((PsiClass)((PsiClassType)to).resolve(), (String)"java.util.Properties")) {
            return from instanceof PsiClassType && InheritanceUtil.isInheritor((PsiClass)((PsiClassType)from).resolve(), (String)"java.util.Map");
        }
        for (Class registeredClass : this.listOrSetConverters.keySet()) {
            Class[] classes;
            PsiType registeredFromType = this.findType(registeredClass);
            if (registeredFromType == null || !from.isAssignableFrom(registeredFromType)) continue;
            for (Class aClass : classes = this.listOrSetConverters.get(registeredClass)) {
                PsiType registeredTooType = this.findType(aClass);
                if (registeredTooType == null || !registeredTooType.equals(to) && !registeredTooType.isAssignableFrom(to)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isStringConvertable(PsiType requiredType) {
        block4: {
            block3: {
                if (!(requiredType instanceof PsiClassType)) break block3;
                PsiClass psiClass = ((PsiClassType)requiredType).resolve();
                if (psiClass == null) break block4;
                for (PsiMethod constructor : psiClass.getConstructors()) {
                    PsiParameterList parameterList = constructor.getParameterList();
                    if (parameterList.getParametersCount() != 1) continue;
                    PsiParameter parameter = parameterList.getParameters()[0];
                    if (!String.class.getCanonicalName().equals(parameter.getType().getCanonicalText())) continue;
                    return true;
                }
                break block4;
            }
            if (requiredType instanceof PsiPrimitiveType) {
                for (PsiType psiType : PsiTypes.primitiveTypes()) {
                    if (!requiredType.equals(psiType)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/utils/PsiTypeUtilImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isCollectionType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isConvertable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

