/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.uast.UCallExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;

public final class SpringBeanFactoryUtils {
    public static final String GET_BEAN_METHOD = "getBean";
    private static final UCallExpressionPattern GET_BEAN_METHOD_WITH_BEAN_TYPE_PATTERN = UastPatterns.callExpression().withResolvedMethod((ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("getBean")).withParameters(new String[]{"java.lang.Class", "java.lang.Object..."}).definedInClass("org.springframework.beans.factory.BeanFactory"), false);
    private static final UCallExpressionPattern GET_BEAN_METHOD_WITH_BEAN_NAME_PATTERN = UastPatterns.callExpression().withResolvedMethod((ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("getBean")).withParameters(new String[]{"java.lang.String", "java.lang.Object..."}).definedInClass("org.springframework.beans.factory.BeanFactory"), false);

    public static boolean couldBeInitializedByBeanFactory(@Nullable Module module, @NotNull PsiType beanType, @NotNull String beanName, PsiType ... psiTypes) {
        if (beanType == null) {
            SpringBeanFactoryUtils.$$$reportNull$$$0(0);
        }
        if (beanName == null) {
            SpringBeanFactoryUtils.$$$reportNull$$$0(1);
        }
        if (module == null) {
            return false;
        }
        GlobalSearchScope scope = SpringGlobalSearchScopes.moduleWithDependencies(module);
        for (UCallExpression uCallExpression : SpringBeanFactoryUtils.findGetBeanMethodCalls(module, scope)) {
            if (!SpringBeanFactoryUtils.isBeanFactoryCallsForBean(beanType, beanName, uCallExpression, psiTypes)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBeanFactoryCallsForBean(@NotNull PsiType beanType, @NotNull String beanName, UCallExpression uCallExpression, PsiType ... types) {
        List arguments;
        if (beanType == null) {
            SpringBeanFactoryUtils.$$$reportNull$$$0(2);
        }
        if (beanName == null) {
            SpringBeanFactoryUtils.$$$reportNull$$$0(3);
        }
        if ((arguments = uCallExpression.getValueArguments()).size() > 0) {
            UExpression expression = (UExpression)arguments.get(0);
            if (beanName.equals(UastUtils.evaluateString((UExpression)expression)) && SpringBeanFactoryUtils.paramsTypesAreEqual(arguments, types)) {
                return true;
            }
            Object evaluate = expression.evaluate();
            if (evaluate instanceof PsiType && ((PsiType)evaluate).isAssignableFrom(beanType) && SpringBeanFactoryUtils.paramsTypesAreEqual(arguments, types)) {
                return true;
            }
        }
        return false;
    }

    public static Set<PsiElement> findBeanFactoryCallsForBean(@Nullable Module module, @NotNull PsiType beanType, @NotNull String beanName, PsiType ... paramTypes) {
        if (beanType == null) {
            SpringBeanFactoryUtils.$$$reportNull$$$0(4);
        }
        if (beanName == null) {
            SpringBeanFactoryUtils.$$$reportNull$$$0(5);
        }
        if (module == null) {
            return Collections.emptySet();
        }
        HashSet<UCallExpression> calls = new HashSet<UCallExpression>();
        for (UCallExpression uCallExpression : SpringBeanFactoryUtils.findGetBeanMethodCalls(module)) {
            if (!SpringBeanFactoryUtils.isBeanFactoryCallsForBean(beanType, beanName, uCallExpression, paramTypes)) continue;
            calls.add(uCallExpression);
        }
        return calls.stream().map(expression -> expression.getSourcePsi()).collect(Collectors.toSet());
    }

    private static boolean paramsTypesAreEqual(List<UExpression> arguments, PsiType ... types) {
        if (arguments.size() - 1 != types.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            PsiType expressionType = arguments.get(i + 1).getExpressionType();
            if (expressionType != null && expressionType.isAssignableFrom(types[i])) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Collection<? extends UCallExpression> findGetBeanMethodCalls(@NotNull Module module) {
        if (module == null) {
            SpringBeanFactoryUtils.$$$reportNull$$$0(6);
        }
        Collection collection = (Collection)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create(SpringBeanFactoryUtils.findGetBeanMethodCalls(module, SpringGlobalSearchScopes.moduleWithDependencies(module)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (collection == null) {
            SpringBeanFactoryUtils.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    private static Collection<? extends UCallExpression> findGetBeanMethodCalls(@NotNull Module module, GlobalSearchScope scope) {
        if (module == null) {
            SpringBeanFactoryUtils.$$$reportNull$$$0(8);
        }
        Collection<? extends UCallExpression> collection = SpringCommonUtils.findMethodCallsByPattern(module.getProject(), GET_BEAN_METHOD, (SearchScope)scope, GET_BEAN_METHOD_WITH_BEAN_NAME_PATTERN, GET_BEAN_METHOD_WITH_BEAN_TYPE_PATTERN);
        if (collection == null) {
            SpringBeanFactoryUtils.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NotNull
    public static PsiType[] getParamTypes(@NotNull PsiMethod method) {
        if (method == null) {
            SpringBeanFactoryUtils.$$$reportNull$$$0(10);
        }
        PsiType[] psiTypeArray = (PsiType[])Arrays.stream(method.getParameterList().getParameters()).map(parameter -> parameter.getType()).toArray(PsiType[]::new);
        if (psiTypeArray == null) {
            SpringBeanFactoryUtils.$$$reportNull$$$0(11);
        }
        return psiTypeArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanType";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanName";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/utils/SpringBeanFactoryUtils";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/utils/SpringBeanFactoryUtils";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findGetBeanMethodCalls";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "couldBeInitializedByBeanFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isBeanFactoryCallsForBean";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findBeanFactoryCallsForBean";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findGetBeanMethodCalls";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParamTypes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 11 -> new IllegalStateException(string);
        };
    }
}

