/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.DelimitedListProcessor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.jam.converters.SpringAntPatternPackageReferenceSet;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringReferenceUtils {
    public static PsiReference @NotNull [] getPsiPackagesReferences(@NotNull PsiElement element, @Nullable String text, int startInElement) {
        if (element == null) {
            SpringReferenceUtils.$$$reportNull$$$0(0);
        }
        PsiReference[] psiReferenceArray = SpringReferenceUtils.getPsiPackagesReferences(element, text, startInElement, ",; \n\t");
        if (psiReferenceArray == null) {
            SpringReferenceUtils.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    public static PsiReference[] getPsiPackagesReferences(@NotNull PsiElement element, @Nullable String text, int startInElement, String delimiters) {
        if (element == null) {
            SpringReferenceUtils.$$$reportNull$$$0(2);
        }
        return SpringReferenceUtils.getPsiPackagesReferences(element, text, startInElement, delimiters, SpringReferenceUtils.getResolveScope(element));
    }

    public static PsiReference[] getPsiPackagesReferences(final @NotNull PsiElement element, final @Nullable String text, final int startInElement, String delimiters, final @NotNull GlobalSearchScope scope) {
        if (element == null) {
            SpringReferenceUtils.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            SpringReferenceUtils.$$$reportNull$$$0(4);
        }
        if (text == null || PlaceholderUtils.getInstance().isDefaultPlaceholder(text)) {
            return PsiReference.EMPTY_ARRAY;
        }
        SmartList list = new SmartList();
        new DelimitedListProcessor(delimiters, (List)list){
            final /* synthetic */ List val$list;
            {
                this.val$list = list;
                super(arg0);
            }

            protected void processToken(int start, int end, boolean delimitersOnly) {
                String packageName = text.substring(start, end);
                if (PlaceholderUtils.getInstance().isDefaultPlaceholder(packageName)) {
                    return;
                }
                String trimmedPackageName = packageName.trim();
                int offset = start + packageName.indexOf(trimmedPackageName) + startInElement;
                SpringAntPatternPackageReferenceSet referenceSet = trimmedPackageName.equals("IntellijIdeaRulezzz") ? new SpringAntPatternPackageReferenceSet("IntellijIdeaRulezzz ", element, offset, scope) : new SpringAntPatternPackageReferenceSet(trimmedPackageName, element, offset, scope);
                this.val$list.addAll(referenceSet.getReferences());
            }
        }.processText(text);
        return list.isEmpty() ? PsiReference.EMPTY_ARRAY : list.toArray(PsiReference.EMPTY_ARRAY);
    }

    public static GlobalSearchScope getResolveScope(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            SpringReferenceUtils.$$$reportNull$$$0(5);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            return GlobalSearchScope.allScope((Project)element.getProject());
        }
        boolean inTestSource = ProjectRootsUtil.isInTestSource((PsiFile)element.getContainingFile());
        return module.getModuleRuntimeScope(inTestSource);
    }

    public static boolean processSeparatedString(String str, String delimiter, PairProcessor<? super String, ? super Integer> processor2) {
        String s;
        int index;
        if (str == null) {
            return true;
        }
        if (StringUtil.isEmptyOrSpaces((String)str)) {
            return processor2.process((Object)str, (Object)0);
        }
        int pos = 0;
        while ((index = str.indexOf(delimiter, pos)) != -1) {
            int nextPos = index + delimiter.length();
            String token = str.substring(pos, index);
            if (token.length() != 0 && !processor2.process((Object)token.trim(), (Object)(pos + token.indexOf(token.trim())))) {
                return false;
            }
            pos = nextPos;
        }
        return pos >= str.length() || processor2.process((Object)(s = str.substring(pos)).trim(), (Object)(pos + s.indexOf(s.trim())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/utils/SpringReferenceUtils";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/utils/SpringReferenceUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiPackagesReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPsiPackagesReferences";
                break;
            }
            case 1: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

