/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values.converters;

import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.ResourceBundleReference;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.spring.model.converters.PatternFileReferenceSet;
import com.intellij.spring.model.values.converters.SpringValueConditionFactory;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BundleNameConverter
extends Converter<PropertiesFile>
implements CustomReferenceConverter {
    private static final String[] prefixes = new String[]{"classpath:", "classpath*:"};
    @NonNls
    public static final String RESOURCE_BUNDLE_MESSAGE_SOURCE = "org.springframework.context.support.ResourceBundleMessageSource";
    @NonNls
    public static final String RELOADABLE_RESOURCE_BUNDLE_MESSAGE_SOURCE = "org.springframework.context.support.ReloadableResourceBundleMessageSource";

    @Nullable
    public PropertiesFile fromString(@Nullable @NonNls String s, @NotNull ConvertContext context) {
        if (context == null) {
            BundleNameConverter.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Nullable
    public String toString(@Nullable PropertiesFile file, @NotNull ConvertContext context) {
        if (context == null) {
            BundleNameConverter.$$$reportNull$$$0(1);
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PsiReference @NotNull [] createReferences(GenericDomValue value, PsiElement element, ConvertContext context) {
        block10: {
            block11: {
                block9: {
                    text = element.getText();
                    if (!StringUtil.isNotEmpty((String)text)) break block10;
                    try {
                        range = ElementManipulators.getValueTextRange((PsiElement)element);
                        textValue = range.substring(text);
                        var7_8 = BundleNameConverter.prefixes;
                        var8_9 = var7_8.length;
                        var9_10 = 0;
lbl9:
                        // 2 sources

                        while (var9_10 < var8_9) {
                            prefix = var7_8[var9_10];
                            lastIndexOf = textValue.lastIndexOf(prefix);
                            if (lastIndexOf < 0 || (offset = range.getStartOffset() + lastIndexOf + prefix.length()) >= (endOffset = range.getEndOffset())) ** GOTO lbl-1000
                            textRange = TextRange.create((int)offset, (int)endOffset);
                            if (textValue.contains("/")) {
                                v0 = this.getPathReferences(element, textRange, textRange.substring(text));
                                break block9;
                            }
                            ** GOTO lbl-1000
                        }
                        ** GOTO lbl33
                    }
                    catch (Exception var5_6) {
                        // empty catch block
                        break block10;
                    }
                }
                if (v0 == null) {
                    BundleNameConverter.$$$reportNull$$$0(2);
                }
                return v0;
lbl-1000:
                // 1 sources

                {
                    v1 = new PsiReference[]{new ResourceBundleReference(element, textRange, true)};
                    if (v1 != null) break block11;
                }
                BundleNameConverter.$$$reportNull$$$0(3);
            }
            return v1;
lbl-1000:
            // 1 sources

            {
                ++var9_10;
                ** GOTO lbl9
lbl33:
                // 1 sources

                if (!textValue.contains("/")) break block10;
                v2 = this.getPathReferences(element, range, textValue);
            }
            if (v2 == null) {
                BundleNameConverter.$$$reportNull$$$0(4);
            }
            return v2;
        }
        v3 = new PsiReference[]{new ResourceBundleReference(element, true)};
        if (v3 == null) {
            BundleNameConverter.$$$reportNull$$$0(5);
        }
        return v3;
    }

    public PsiReference @NotNull [] getPathReferences(PsiElement element, TextRange range, String textValue) {
        PatternFileReferenceSet set = new PatternFileReferenceSet(textValue, element, range.getStartOffset(), true){

            @Override
            public FileReference createFileReference(TextRange range, int index, String text) {
                return new PatternFileReferenceSet.PatternFileReference(this, range, index, text, this.getReferenceCompletionFilter()){

                    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
                        ResolveResult[] results = super.multiResolve(incompleteCode);
                        if (results.length == 0) {
                            String s = this.getText();
                            for (PsiFileSystemItem context : this.getContexts()) {
                                if (!(context instanceof PsiDirectory)) continue;
                                for (PsiFile file : ((PsiDirectory)context).getFiles()) {
                                    if (!(file instanceof PropertiesFile) || !s.equals(ResourceBundleManager.getInstance((Project)this.getElement().getProject()).getBaseName(file))) continue;
                                    ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)file)};
                                    if (resolveResultArray == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    return resolveResultArray;
                                }
                            }
                        }
                        if (results == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return results;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/converters/BundleNameConverter$1$1", "multiResolve"));
                    }
                };
            }
        };
        if (textValue.startsWith("/")) {
            set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, FileReferenceSet.ABSOLUTE_TOP_LEVEL);
        }
        FileReference[] fileReferenceArray = set.getAllReferences();
        if (fileReferenceArray == null) {
            BundleNameConverter.$$$reportNull$$$0(6);
        }
        return fileReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/values/converters/BundleNameConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/values/converters/BundleNameConverter";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    public static class BundleNameConverterCondition
    implements Condition<Pair<PsiType, GenericDomValue<?>>> {
        private static final Condition<GenericDomValue<?>> CONDITION = SpringValueConditionFactory.createBeanPropertyCondition("org.springframework.context.support.ResourceBundleMessageSource", "basename", "basenames");
        private static final Condition<GenericDomValue<?>> RELOADABLE_MESSAGE_SOURCE_CONDITION = SpringValueConditionFactory.createBeanPropertyCondition("org.springframework.context.support.ReloadableResourceBundleMessageSource", "basename", "basenames");

        public boolean value(Pair<PsiType, GenericDomValue<?>> pair) {
            PsiType psiType = (PsiType)pair.getFirst();
            if (psiType instanceof PsiArrayType) {
                psiType = ((PsiArrayType)psiType).getComponentType();
            }
            if (!(psiType instanceof PsiClassType)) {
                return false;
            }
            String psiTypeText = psiType.getCanonicalText();
            return "java.lang.String".equals(psiTypeText) && (CONDITION.value((Object)((GenericDomValue)pair.second)) || RELOADABLE_MESSAGE_SOURCE_CONDITION.value((Object)((GenericDomValue)pair.second)));
        }
    }
}

