/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.wrappers;

import com.intellij.openapi.util.Pair;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.model.wrappers.WModel;
import org.jetbrains.annotations.NotNull;

public class WSpringDependency {
    @NotNull
    public final String modelName;
    @NotNull
    final LocalModelDependencyType dependencyType;

    public WSpringDependency(@NotNull String name, @NotNull LocalModelDependencyType type) {
        if (name == null) {
            WSpringDependency.$$$reportNull$$$0(0);
        }
        if (type == null) {
            WSpringDependency.$$$reportNull$$$0(1);
        }
        this.modelName = name;
        this.dependencyType = type;
    }

    public WSpringDependency(@NotNull Pair<LocalModel<?>, LocalModelDependency> model) {
        if (model == null) {
            WSpringDependency.$$$reportNull$$$0(2);
        }
        this.dependencyType = ((LocalModelDependency)model.second).getType();
        if (model.first instanceof LocalXmlModel) {
            this.modelName = WModel.getLocalXmlModelName((LocalXmlModel)model.first);
        } else if (model.first instanceof LocalAnnotationModel) {
            this.modelName = ((LocalAnnotationModel)model.first).getConfig().getQualifiedName();
        } else {
            throw new IllegalArgumentException(String.format("Model with class:'%s' is not xml nor annotation model", model.getClass()));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WSpringDependency that = (WSpringDependency)o;
        if (!this.modelName.equals(that.modelName)) {
            return false;
        }
        return this.dependencyType == that.dependencyType;
    }

    public int hashCode() {
        int result = this.modelName.hashCode();
        result = 31 * result + this.dependencyType.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "type";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "model";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/model/wrappers/WSpringDependency";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

