/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.custom;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.jsp.JspSpiUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.xml.custom.CustomBeanInfo;
import com.intellij.spring.model.xml.custom.CustomBeanParser;
import com.intellij.spring.model.xml.impl.CustomBeanWrapperImpl;
import com.intellij.spring.schemas.SpringSchemaProvider;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="CustomBeanRegistry", storages={@Storage(value="customSpringBeans.xml")})
public final class CustomBeanRegistry
implements PersistentStateComponent<MyBean> {
    private static final int CURRENT_VERSION = 1;
    private static final Logger LOG = Logger.getInstance(CustomBeanRegistry.class);
    @NonNls
    private static final String CUSTOM_BEAN_PARSER = "com.intellij.spring.model.xml.custom.CustomBeanParser";
    private Map<String, List<CustomBeanInfo>> myText2Infos = new HashMap<String, List<CustomBeanInfo>>();
    private Map<MyQName, CustomBeanInfo> myPolicies = new HashMap<MyQName, CustomBeanInfo>();
    @NonNls
    private static final String FAKE_ID = "IntelliJIDEARulezzz";
    @NonNls
    public static final String CUSTOM_SPRING_BEANS_PARSING_TIMEOUT = "custom.spring.beans.parsing.timeout";

    private static boolean isDebug() {
        return false;
    }

    private static int getTimeout() {
        try {
            return Integer.parseInt(System.getProperty(CUSTOM_SPRING_BEANS_PARSING_TIMEOUT));
        }
        catch (NumberFormatException e) {
            return CustomBeanRegistry.isDebug() ? 10000000 : 10000;
        }
    }

    public MyBean getState() {
        MyBean bean = new MyBean();
        bean.map = new HashMap<String, List<CustomBeanInfo>>();
        for (String s : this.myText2Infos.keySet()) {
            List<CustomBeanInfo> infos = this.myText2Infos.get(s);
            if (infos == null || infos.isEmpty()) continue;
            bean.map.put(s, infos);
        }
        bean.policies = this.myPolicies;
        return bean;
    }

    public void loadState(@NotNull MyBean state) {
        if (state == null) {
            CustomBeanRegistry.$$$reportNull$$$0(0);
        }
        if (state.version == 1) {
            this.myText2Infos = state.map;
            this.myPolicies = state.policies;
        }
    }

    public ParseResult parseBeans(Collection<XmlTag> tags) {
        ParseResult result = ParseResult.EMPTY_PARSE_RESULT;
        for (XmlTag tag : tags) {
            if (!tag.isValid()) continue;
            result = result.merge(this.parseBean(tag));
        }
        return result;
    }

    public ParseResult parseBean(XmlTag tag) {
        String text = CustomBeanRegistry.getIdealBeanText(tag);
        try {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)tag);
            if (module == null) {
                return ParseResult.EMPTY_PARSE_RESULT;
            }
            ParseResult result = CustomBeanRegistry.getCustomBeans(CustomBeanRegistry.createTag(text, tag.getProject()), module);
            List<Object> infos = result.beans == null ? Collections.emptyList() : result.beans;
            this.myText2Infos.put(text, infos);
            return result;
        }
        catch (IncorrectOperationException e) {
            return new ParseResult(e);
        }
    }

    public static CustomBeanRegistry getInstance(Project project) {
        return (CustomBeanRegistry)project.getService(CustomBeanRegistry.class);
    }

    @Nullable
    public List<CustomBeanInfo> getParseResult(@NotNull XmlTag tag) {
        CustomBeanInfo policy;
        if (tag == null) {
            CustomBeanRegistry.$$$reportNull$$$0(1);
        }
        if ((policy = this.myPolicies.get(new MyQName(tag.getNamespace(), tag.getLocalName()))) != null) {
            CustomBeanInfo info = new CustomBeanInfo(policy);
            info.beanName = tag.getAttributeValue(policy.idAttribute);
            return Collections.singletonList(info);
        }
        return this.myText2Infos.get(CustomBeanRegistry.getIdealBeanText(tag));
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private static String getIdealBeanText(XmlTag tag) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Map<XmlTag, XmlTag> calcMapping(final XmlTag tag, final XmlTag copy) {
        final HashMap<XmlTag, XmlTag> original2Copy = new HashMap<XmlTag, XmlTag>();
        tag.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                if (element instanceof XmlTag) {
                    TextRange range = element.getTextRange().shiftRight(-tag.getTextRange().getStartOffset());
                    original2Copy.put((XmlTag)element, (XmlTag)PsiTreeUtil.findElementOfClassAtRange((PsiFile)copy.getContainingFile(), (int)range.getStartOffset(), (int)range.getEndOffset(), XmlTag.class));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/xml/custom/CustomBeanRegistry$1", "visitElement"));
            }
        });
        return original2Copy;
    }

    private static void computeDefaultValues(XmlTag root, final Map<XmlTag, XmlTag> original2Copy) {
        root.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                XmlElementDescriptor descriptor;
                XmlTag each;
                XmlTag copy;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                if (element instanceof XmlTag && (copy = (XmlTag)original2Copy.get(each = (XmlTag)element)) != null && (descriptor = each.getDescriptor()) != null) {
                    for (XmlAttributeDescriptor attributeDescriptor : descriptor.getAttributesDescriptors(each)) {
                        String defValue = attributeDescriptor.getDefaultValue();
                        String attrName = attributeDescriptor.getName((PsiElement)each);
                        if (!StringUtil.isNotEmpty((String)defValue) || each.getAttribute(attrName) != null) continue;
                        copy.setAttribute(attrName, defValue);
                    }
                    String defValue = descriptor.getDefaultValue();
                    if (StringUtil.isNotEmpty((String)defValue) && StringUtil.isEmpty((String)each.getValue().getTrimmedText())) {
                        copy.getValue().setText(defValue);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/xml/custom/CustomBeanRegistry$2", "visitElement"));
            }
        });
    }

    private static Set<String> collectReferencedNamespaces(XmlTag tag) {
        final HashSet<String> usedNamespaces = new HashSet<String>();
        tag.accept((PsiElementVisitor)new XmlElementVisitor(){

            public void visitXmlTag(@NotNull XmlTag tag) {
                if (tag == null) {
                    3.$$$reportNull$$$0(0);
                }
                usedNamespaces.add(tag.getNamespace());
                for (XmlAttribute xmlAttribute : tag.getAttributes()) {
                    this.visitXmlAttribute(xmlAttribute);
                }
                for (XmlAttribute xmlAttribute : tag.getSubTags()) {
                    this.visitXmlTag((XmlTag)xmlAttribute);
                }
            }

            public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
                if (attribute == null) {
                    3.$$$reportNull$$$0(1);
                }
                usedNamespaces.add(attribute.getNamespace());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tag";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attribute";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/spring/model/xml/custom/CustomBeanRegistry$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlTag";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlAttribute";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return usedNamespaces;
    }

    private static XmlTag createTag(@NotNull String text, Project project) throws IncorrectOperationException {
        if (text == null) {
            CustomBeanRegistry.$$$reportNull$$$0(6);
        }
        return XmlElementFactory.getInstance((Project)project).createTagFromText((CharSequence)text);
    }

    @NotNull
    public static XmlTag getActualSourceTag(CustomBeanInfo info, XmlTag tag) {
        List<Integer> path = info.path;
        for (Integer index : path) {
            int i;
            XmlTag parent = tag;
            Object[] subTags = parent.getSubTags();
            if ((tag = subTags[i = index.intValue()]) != null) continue;
            LOG.error("parent: " + parent.getText() + "\nindex: " + i + "\nsubTags: " + Arrays.toString(subTags));
        }
        XmlTag xmlTag = tag;
        if (xmlTag == null) {
            CustomBeanRegistry.$$$reportNull$$$0(7);
        }
        return xmlTag;
    }

    public void addBeanPolicy(@NotNull String namespace, @NotNull String localName, CustomBeanInfo info) {
        if (namespace == null) {
            CustomBeanRegistry.$$$reportNull$$$0(8);
        }
        if (localName == null) {
            CustomBeanRegistry.$$$reportNull$$$0(9);
        }
        assert (info.beanName == null);
        assert (info.idAttribute != null);
        this.myPolicies.put(new MyQName(namespace, localName), info);
    }

    private static void computeUrls(Module module, PathsList list) {
        File springPluginClassesLocation = new File(PathUtil.getJarPathForClass(CustomBeanWrapperImpl.class));
        if (springPluginClassesLocation.isFile()) {
            File customNsLocation = new File(springPluginClassesLocation.getParent(), "customNs");
            list.add(new File(customNsLocation, "customNs.jar").getAbsolutePath());
        } else {
            list.add(new File(springPluginClassesLocation.getParent(), "intellij.spring.customNs").getAbsolutePath());
        }
        JspSpiUtil.processClassPathItems(null, (Module)module, arg_0 -> ((PathsList)list).add(arg_0));
        list.addVirtualFiles(OrderEnumerator.orderEntries((Module)module).recursively().sources().usingCache().getRoots());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private static ParseResult getCustomBeans(@NotNull XmlTag tag, @NotNull Module module) {
        List<CustomBeanInfo> infos;
        OSProcessHandler handler;
        String namespace;
        Map<String, String> handlersToRun;
        if (tag == null) {
            CustomBeanRegistry.$$$reportNull$$$0(10);
        }
        if (module == null) {
            CustomBeanRegistry.$$$reportNull$$$0(11);
        }
        if (!(handlersToRun = CustomBeanRegistry.findHandlersToRun(module, tag)).containsKey(namespace = tag.getNamespace())) {
            return new ParseResult(SpringBundle.message("parse.no.namespace.handler", namespace));
        }
        JavaParameters javaParameters = new JavaParameters();
        javaParameters.setJdk(ModuleRootManager.getInstance((Module)module).getSdk());
        javaParameters.setMainClass(CUSTOM_BEAN_PARSER);
        javaParameters.setUseClasspathJar(true);
        if (CustomBeanRegistry.isDebug()) {
            javaParameters.getVMParametersList().addParametersString("-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5239");
        }
        CustomBeanRegistry.computeUrls(module, javaParameters.getClassPath());
        javaParameters.setUseDynamicClasspath(true);
        try {
            handler = new OSProcessHandler(javaParameters.toCommandLine());
        }
        catch (ExecutionException e) {
            return new ParseResult(e);
        }
        PrintWriter writer = new PrintWriter(handler.getProcessInput());
        handler.startNotify();
        int timeout = Math.max(CustomBeanRegistry.getTimeout(), tag.getTextLength() * 150);
        writer.println(timeout);
        ParseResult result = CustomBeanRegistry.invokeParser(writer, handler, tag, timeout);
        if (result.getStackTrace() != null && tag.getAttributeValue("id") == null) {
            try {
                tag.setAttribute("id", FAKE_ID);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            ParseResult result1 = CustomBeanRegistry.invokeParser(writer, handler, tag, timeout);
            List<CustomBeanInfo> list = result1.getBeans();
            if (list != null) {
                for (CustomBeanInfo info : list) {
                    if (!FAKE_ID.equals(info.beanName) || !info.path.isEmpty()) continue;
                    info.beanName = null;
                    info.idAttribute = "id";
                }
                result = result1;
            }
        }
        if ((infos = result.getBeans()) != null) {
            CustomBeanRegistry.guessIdAttributeNames(writer, handler, tag, infos, timeout);
        }
        ParseResult parseResult = result;
        writer.close();
        handler.getProcess().destroy();
        handler.waitFor();
        ParseResult parseResult2 = parseResult;
        if (parseResult2 == null) {
            CustomBeanRegistry.$$$reportNull$$$0(12);
        }
        return parseResult2;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        ParseResult parseResult3 = new ParseResult(e);
                        ParseResult parseResult4 = parseResult3;
                        if (parseResult4 == null) {
                            CustomBeanRegistry.$$$reportNull$$$0(13);
                        }
                        return parseResult4;
                    }
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    handler.getProcess().destroy();
                    handler.waitFor();
                }
            }
        }
    }

    @NotNull
    private static ParseResult invokeParser(@NonNls PrintWriter writer, final OSProcessHandler handler, XmlTag tag, int timeout) {
        final Ref result = Ref.create(null);
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final StringBuilder other = new StringBuilder();
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){
            StringBuilder sb = new StringBuilder();

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    4.$$$reportNull$$$0(1);
                }
                try {
                    int k;
                    if (outputType != ProcessOutputTypes.STDOUT) {
                        other.append(event.getText());
                        return;
                    }
                    this.sb.append(event.getText().replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n"));
                    int i = this.sb.indexOf("\n\n##$%^$&%@^#%$#%^&$^&%*&^(*(^&*(&^*&%*&%&*^\n");
                    if (i < 0) {
                        return;
                    }
                    @NonNls String input = this.sb.substring(0, i);
                    this.sb.delete(0, i + "\n\n##$%^$&%@^#%$#%^&$^&%*&^(*(^&*(&^*&%*&%&*^\n".length());
                    String[] lines = input.split("\n");
                    for (k = 0; !(k >= lines.length || "exception".equals(lines[k]) || "timeout".equals(lines[k]) || "result".equals(lines[k])); ++k) {
                    }
                    if (k >= lines.length) {
                        this.setResult(new ParseResult(SpringBundle.message("internal.error.parsing.bean", input)));
                        return;
                    }
                    String first = lines[k];
                    if ("exception".equals(first)) {
                        assert (lines.length == k + 2);
                        this.setResult(new ParseResult(new ParseResult.StackTrace(CustomBeanParser.decode(lines[k + 1]))));
                        return;
                    }
                    if ("timeout".equals(first)) {
                        assert (lines.length == k + 1);
                        this.setResult(new ParseResult(SpringBundle.message("timeout.parsing.bean", new Object[0])));
                        return;
                    }
                    if ("result".equals(first)) {
                        SmartList list = new SmartList();
                        String nextLine = lines[k + 1];
                        boolean hasInfras = "has_infrastructures".equals(nextLine);
                        if (!hasInfras) assert ("no_infrastructures".equals(nextLine));
                        for (int j = k + 2; j < lines.length; ++j) {
                            nextLine = lines[j++];
                            assert ("info".equals(nextLine));
                            CustomBeanInfo info = new CustomBeanInfo();
                            while (!"info_end".equals(lines[j])) {
                                String prop = lines[j++];
                                @NonNls String propValue = CustomBeanParser.decode(lines[j++]);
                                if ("beanName".equals(prop)) {
                                    info.beanName = propValue;
                                    continue;
                                }
                                if ("beanClassName".equals(prop)) {
                                    info.beanClassName = propValue;
                                    continue;
                                }
                                if ("constructorArgumentCount".equals(prop)) {
                                    info.constructorArgumentCount = Integer.parseInt(propValue);
                                    continue;
                                }
                                if ("factoryMethodName".equals(prop)) {
                                    info.factoryMethodName = propValue;
                                    continue;
                                }
                                if ("factoryBeanName".equals(prop)) {
                                    info.factoryBeanName = propValue;
                                    continue;
                                }
                                assert ("path".equals(prop)) : prop;
                                assert (propValue.startsWith("x"));
                                String separated = propValue.substring(1);
                                info.path = StringUtil.isEmpty((String)separated) ? Collections.emptyList() : ContainerUtil.map((Object[])separated.split(";"), Integer::parseInt);
                            }
                            list.add(info);
                        }
                        this.setResult(new ParseResult((List<CustomBeanInfo>)list, hasInfras));
                    }
                }
                catch (Throwable e) {
                    this.setResult(new ParseResult(e));
                }
            }

            private void setResult(ParseResult value) {
                result.set((Object)value);
                handler.removeProcessListener((ProcessListener)this);
                semaphore.up();
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (other.length() == 0 || this.sb.length() == 0) {
                    this.setResult(new ParseResult(SpringBundle.message("process.unexpectedly.terminated", "")));
                    return;
                }
                @NonNls String output = ":\n\nSTDOUT:\n" + this.sb + "\n\nOTHER:\n" + other;
                this.setResult(new ParseResult(SpringBundle.message("process.unexpectedly.terminated", output)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/spring/model/xml/custom/CustomBeanRegistry$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        writer.println("input");
        writer.println(CustomBeanParser.encode(tag.getText()));
        writer.flush();
        boolean inTime = semaphore.waitFor((long)timeout);
        ParseResult parseResult = (ParseResult)result.get();
        if (parseResult == null) {
            if (inTime) {
                return new ParseResult(new ParseResult.StackTrace(other.toString()));
            }
            return new ParseResult(SpringBundle.message("timeout.parsing.bean", new Object[0]));
        }
        ParseResult parseResult2 = parseResult;
        if (parseResult2 == null) {
            CustomBeanRegistry.$$$reportNull$$$0(14);
        }
        return parseResult2;
    }

    private static void guessIdAttributeNames(@NonNls PrintWriter writer, OSProcessHandler reader, XmlTag tag, List<CustomBeanInfo> list, int timeout) throws IncorrectOperationException {
        List<CustomBeanInfo> withFakes;
        String[] fakeNames = new String[list.size()];
        String[] idAttrs = new String[list.size()];
        boolean hasFakeIds = false;
        for (int i = 0; i < list.size(); ++i) {
            XmlAttribute idAttr;
            CustomBeanInfo info = list.get(i);
            if (info.idAttribute != null) continue;
            XmlTag sourceTag = CustomBeanRegistry.getActualSourceTag(info, tag);
            String id = info.beanName;
            XmlAttribute xmlAttribute2 = idAttr = id == null ? null : (XmlAttribute)ContainerUtil.find((Object[])sourceTag.getAttributes(), xmlAttribute -> !xmlAttribute.isNamespaceDeclaration() && id.equals(xmlAttribute.getDisplayValue()));
            if (idAttr == null) continue;
            String fakeName = FAKE_ID + i;
            fakeNames[i] = fakeName;
            idAttr.setValue(fakeName);
            idAttrs[i] = idAttr.getLocalName();
            hasFakeIds = true;
        }
        if (hasFakeIds && (withFakes = CustomBeanRegistry.invokeParser(writer, reader, tag, timeout).getBeans()) != null && withFakes.size() == list.size()) {
            for (int i = 0; i < fakeNames.length; ++i) {
                String name = fakeNames[i];
                if (name == null || !name.equals(withFakes.get((int)i).beanName)) continue;
                list.get((int)i).idAttribute = idAttrs[i];
            }
        }
    }

    private static Map<String, String> findHandlersToRun(@NotNull Module module, @NotNull XmlTag tag) {
        Map<String, String> handlers;
        if (module == null) {
            CustomBeanRegistry.$$$reportNull$$$0(15);
        }
        if (tag == null) {
            CustomBeanRegistry.$$$reportNull$$$0(16);
        }
        if ((handlers = SpringSchemaProvider.getHandlers(module)).isEmpty()) {
            return Collections.emptyMap();
        }
        Set<String> referencedNamespaces = CustomBeanRegistry.collectReferencedNamespaces(tag);
        HashMap<String, String> handlersToRun = new HashMap<String, String>(referencedNamespaces.size());
        for (String namespace : handlers.keySet()) {
            if (!referencedNamespaces.contains(namespace)) continue;
            handlersToRun.put(namespace, handlers.get(namespace));
        }
        return handlersToRun;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 7, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/xml/custom/CustomBeanRegistry";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localName";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/xml/custom/CustomBeanRegistry";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdealBeanText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualSourceTag";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomBeans";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getParseResult";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTag";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addBeanPolicy";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCustomBeans";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findHandlersToRun";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 7, 12, 13, 14 -> new IllegalStateException(string);
        };
    }

    public static class MyBean {
        public int version = 1;
        public Map<String, List<CustomBeanInfo>> map = new HashMap<String, List<CustomBeanInfo>>();
        public Map<MyQName, CustomBeanInfo> policies = new HashMap<MyQName, CustomBeanInfo>();
    }

    public static final class ParseResult {
        static final ParseResult EMPTY_PARSE_RESULT = new ParseResult(Collections.emptyList(), false);
        @Nullable
        List<CustomBeanInfo> beans;
        boolean hasInfrastructures;
        @Nullable
        @NlsContexts.NotificationContent String errorMessage;
        @Nullable
        String stackTrace;

        private ParseResult(List<CustomBeanInfo> beans, boolean hasInfrastructures) {
            this.beans = beans;
            this.hasInfrastructures = hasInfrastructures;
        }

        private static String getStackTrace(Throwable e) {
            return StringUtil.getThrowableText((Throwable)e);
        }

        private ParseResult(Throwable t) {
            this(new StackTrace(ParseResult.getStackTrace(t)));
        }

        private ParseResult(@Nullable @NlsContexts.NotificationContent String errorMessage) {
            this.errorMessage = errorMessage;
        }

        private ParseResult(StackTrace resultStackTrace) {
            this.stackTrace = StringUtil.convertLineSeparators((String)resultStackTrace.stackTraceText);
            int i = this.stackTrace.indexOf(CustomBeanRegistry.CUSTOM_BEAN_PARSER);
            if (i >= 0 && (i = this.stackTrace.lastIndexOf(10, i)) >= 0) {
                this.stackTrace = this.stackTrace.substring(0, i);
            }
        }

        @Nullable
        @NlsContexts.NotificationContent
        public String getErrorMessage() {
            return this.errorMessage;
        }

        @Nullable
        public String getStackTrace() {
            return this.stackTrace;
        }

        @Nullable
        public List<CustomBeanInfo> getBeans() {
            return this.beans;
        }

        public boolean hasInfrastructureBeans() {
            return this.hasInfrastructures;
        }

        public boolean hasErrors() {
            return this.stackTrace != null || this.errorMessage != null;
        }

        public ParseResult merge(ParseResult with) {
            ParseResult result = new ParseResult(null, this.hasInfrastructures || with.hasInfrastructures);
            result.stackTrace = this.stackTrace == null ? with.stackTrace : this.stackTrace;
            String string = result.errorMessage = this.errorMessage == null ? with.errorMessage : this.errorMessage;
            result.beans = this.beans == null ? with.beans : (with.beans == null ? this.beans : ContainerUtil.concat(this.beans, with.beans));
            return result;
        }

        private static class StackTrace {
            final String stackTraceText;

            StackTrace(String stackTraceText) {
                this.stackTraceText = stackTraceText;
            }
        }
    }

    public static class MyQName {
        public String namespace;
        public String localName;

        public MyQName() {
        }

        public MyQName(String namespace, String localName) {
            this.namespace = namespace;
            this.localName = localName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MyQName)) {
                return false;
            }
            MyQName myQName = (MyQName)o;
            if (!this.localName.equals(myQName.localName)) {
                return false;
            }
            return this.namespace.equals(myQName.namespace);
        }

        public int hashCode() {
            int result = this.namespace.hashCode();
            result = 31 * result + this.localName.hashCode();
            return result;
        }
    }
}

