/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.editor.SpringEditorNotificationPanel;
import com.intellij.spring.model.SpringProfile;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.profiles.SpringChangeActiveProfilesAction;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.util.xml.DomChangeAdapter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringProfilesEditorNotificationsProvider
implements EditorNotificationProvider {
    SpringProfilesEditorNotificationsProvider(final @NotNull Project project) {
        if (project == null) {
            SpringProfilesEditorNotificationsProvider.$$$reportNull$$$0(0);
        }
        final MergingUpdateQueue queue = new MergingUpdateQueue("SpringProfilesEditorNotificationsProvider", 1000, true, null, (Disposable)SpringGeneralSettings.getInstance(project), null, false);
        DomManager.getDomManager((Project)project).addDomEventListener((DomEventListener)new DomChangeAdapter(){

            protected void elementChanged(DomElement element) {
                DomFileElement domFileElement = (DomFileElement)DomUtil.getParentOfType((DomElement)element, DomFileElement.class, (boolean)false);
                if (domFileElement != null && domFileElement.isValid() && domFileElement.getRootElement() instanceof Beans) {
                    queue.cancelAllUpdates();
                    queue.queue(new Update(queue){

                        public void run() {
                            EditorNotifications.getInstance((Project)project).updateAllNotifications();
                        }
                    });
                }
            }
        }, (Disposable)SpringGeneralSettings.getInstance(project));
    }

    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            SpringProfilesEditorNotificationsProvider.$$$reportNull$$$0(1);
        }
        if (file == null) {
            SpringProfilesEditorNotificationsProvider.$$$reportNull$$$0(2);
        }
        if (!SpringGeneralSettings.getInstance(project).isShowProfilesPanel()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        if (module == null) {
            return null;
        }
        if (!SpringCommonUtils.isSpringConfigured(module)) {
            return null;
        }
        SpringModel springModel = SpringChangeActiveProfilesAction.getSpringModel(psiFile);
        if (springModel == null) {
            return null;
        }
        Set<String> allProfiles = SpringModelVisitorUtils.getProfiles(springModel);
        Set<String> activeProfiles = springModel.getActiveProfiles();
        if ((activeProfiles == null || activeProfiles.isEmpty()) && !allProfiles.isEmpty() && allProfiles.size() <= SpringProfile.DEFAULT_PROFILE_NAMES.size() && SpringProfile.DEFAULT_PROFILE_NAMES.containsAll(allProfiles)) {
            return null;
        }
        if (allProfiles.isEmpty()) {
            return null;
        }
        String profilesText = SpringProfileUtils.profilesAsString(activeProfiles);
        boolean inActive = psiFile instanceof XmlFile || SpringModelVisitorUtils.hasConfigFile(springModel, psiFile);
        return fileEditor -> new SpringProfilesPanel(project, (FileEditor)fileEditor, profilesText, inActive);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/profiles/SpringProfilesEditorNotificationsProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNotificationData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class SpringProfilesPanel
    extends SpringEditorNotificationPanel {
        SpringProfilesPanel(@NotNull Project project, @NotNull FileEditor fileEditor, @NlsSafe String profilesText, boolean isActive) {
            if (project == null) {
                SpringProfilesPanel.$$$reportNull$$$0(0);
            }
            if (fileEditor == null) {
                SpringProfilesPanel.$$$reportNull$$$0(1);
            }
            super(fileEditor, isActive ? LightColors.SLIGHTLY_GREEN : JBColor.lightGray, EditorNotificationPanel.Status.Info);
            this.text(profilesText);
            this.icon(SpringApiIcons.SpringProfile);
            this.myLabel.setToolTipText(SpringBundle.message("editor.panel.profiles.tooltip", new Object[0]));
            this.createActionLabel(SpringBundle.message("editor.panel.profiles.tooltip.action.name", new Object[0]), "SpringChangeActiveProfiles");
            this.installOpenSettingsButton(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileEditor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/profiles/SpringProfilesEditorNotificationsProvider$SpringProfilesPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

