/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.run;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.execution.filters.Filter;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbModeBlockedFunctionality;
import com.intellij.openapi.project.DumbModeBlockedFunctionalityCollector;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.spring.SpringBundle;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SpringMultipleOccurrencesFilter
implements Filter {
    SpringMultipleOccurrencesFilter() {
    }

    @Nullable
    public final Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Filter.Result occurrence;
        if (line == null) {
            SpringMultipleOccurrencesFilter.$$$reportNull$$$0(0);
        }
        int startOffset = 0;
        SmartList items = new SmartList();
        while ((occurrence = this.findNextOccurrence(startOffset, line, entireLength)) != null) {
            items.add(occurrence);
            startOffset = -(entireLength - ((Filter.ResultItem)occurrence.getResultItems().get(0)).getHighlightEndOffset() + 1 - line.length());
            if (startOffset >= 0) continue;
            break;
        }
        if (items.isEmpty()) {
            return null;
        }
        return new Filter.Result((List)items);
    }

    protected abstract Filter.Result findNextOccurrence(int var1, String var2, int var3);

    protected static void showResult(BiConsumer<DataContext, Editor> consumer) {
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
            if (editor == null) {
                return;
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(context);
            if (project == null) {
                return;
            }
            if (DumbService.isDumb((Project)project)) {
                DumbModeBlockedFunctionalityCollector.INSTANCE.logFunctionalityBlocked(project, DumbModeBlockedFunctionality.Spring);
                HintManager.getInstance().showErrorHint(editor, SpringBundle.message("message.navigation.available.during.indexing", new Object[0]));
                return;
            }
            consumer.accept((DataContext)context, editor);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/spring/run/SpringMultipleOccurrencesFilter", "applyFilter"));
    }
}

