/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.schemas;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.index.XmlNamespaceIndex;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringSchemaProvider
extends XmlSchemaProvider {
    private static final Logger LOG = Logger.getInstance(SpringSchemaProvider.class);
    private static final Key<CachedValue<Map<String, VirtualFile>>> SCHEMAS_BUNDLE_KEY = Key.create((String)"spring schemas");
    private static final CachedValueProvider.Result<Map<String, VirtualFile>> EMPTY_MAP_RESULT = new CachedValueProvider.Result(Collections.emptyMap(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    private static final Set<String> SKIP_NAMESPACE_URLS = Set.of("http://www.w3.org/2001/XMLSchema-instance", "http://www.w3.org/XML/1998/namespace", "http://www.w3.org/2001/XMLSchema", "http://www.w3.org/1999/XMLSchema", "http://www.w3.org/2000/10/XMLSchema");

    public XmlFile getSchema(@NotNull @NonNls String url, @Nullable Module module, @NotNull PsiFile baseFile) {
        PsiDirectory directory;
        if (url == null) {
            SpringSchemaProvider.$$$reportNull$$$0(0);
        }
        if (baseFile == null) {
            SpringSchemaProvider.$$$reportNull$$$0(1);
        }
        if (SKIP_NAMESPACE_URLS.contains(url)) {
            return null;
        }
        if (module == null && (directory = baseFile.getParent()) != null) {
            module = ModuleUtilCore.findModuleForPsiElement((PsiElement)directory);
        }
        if (module == null) {
            return null;
        }
        Map<String, VirtualFile> schemas = SpringSchemaProvider.getSchemas(module);
        Project project = module.getProject();
        VirtualFile file = schemas.get(url);
        if (file == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        return (XmlFile)psiFile;
    }

    public boolean isAvailable(@NotNull XmlFile file) {
        boolean isSpring;
        if (file == null) {
            SpringSchemaProvider.$$$reportNull$$$0(2);
        }
        if (isSpring = SpringDomUtils.isSpringXml(file)) {
            return true;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        String extension = virtualFile.getExtension();
        return extension != null && extension.equals("xsd");
    }

    @NotNull
    public Set<String> getAvailableNamespaces(@NotNull XmlFile file, String tagName) {
        Module module;
        if (file == null) {
            SpringSchemaProvider.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                SpringSchemaProvider.$$$reportNull$$$0(4);
            }
            return set;
        }
        Map<String, VirtualFile> map = SpringSchemaProvider.getSchemas(module);
        HashSet strings = new HashSet(map.size());
        for (VirtualFile virtualFile : map.values()) {
            String namespace = SpringSchemaProvider.getNamespace(virtualFile, file.getProject());
            ContainerUtil.addIfNotNull(strings, (Object)namespace);
        }
        Set filtered = DefaultXmlExtension.filterNamespaces(strings, (String)tagName, (XmlFile)file);
        if (SpringDomUtils.isSpringXml(file)) {
            filtered.add("http://www.springframework.org/schema/c");
            filtered.add("http://www.springframework.org/schema/p");
        }
        Set set = filtered;
        if (set == null) {
            SpringSchemaProvider.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Nullable
    private static String getNamespace(VirtualFile virtualFile, Project project) {
        PsiMetaData metaData;
        XmlDocument document;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (psiFile instanceof XmlFile && (document = ((XmlFile)psiFile).getDocument()) != null && (metaData = document.getMetaData()) instanceof XmlNSDescriptorImpl) {
            return ((XmlNSDescriptorImpl)metaData).getDefaultNamespace();
        }
        return null;
    }

    public String getDefaultPrefix(@NotNull @NonNls String namespace, @NotNull XmlFile context) {
        if (namespace == null) {
            SpringSchemaProvider.$$$reportNull$$$0(6);
        }
        if (context == null) {
            SpringSchemaProvider.$$$reportNull$$$0(7);
        }
        if (!SpringDomUtils.isSpringXml(context)) {
            return null;
        }
        String[] strings = namespace.split("/");
        return strings[strings.length - 1];
    }

    public Set<String> getLocations(@NotNull @NonNls String namespace, @NotNull XmlFile context) {
        Module module;
        if (namespace == null) {
            SpringSchemaProvider.$$$reportNull$$$0(8);
        }
        if (context == null) {
            SpringSchemaProvider.$$$reportNull$$$0(9);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context)) == null) {
            return null;
        }
        Map<String, VirtualFile> schemas = SpringSchemaProvider.getSchemas(module);
        String best = null;
        for (Map.Entry<String, VirtualFile> entry : schemas.entrySet()) {
            String s;
            String location = entry.getKey();
            if (!location.endsWith(".xsd") || (s = SpringSchemaProvider.getNamespace(entry.getValue(), context.getProject())) == null || !s.equals(namespace)) continue;
            if (!Character.isDigit(location.charAt(location.length() - ".xsd".length() - 1))) {
                return Collections.singleton(location);
            }
            if (best != null && location.compareTo(best) <= 0) continue;
            best = location;
        }
        return best == null ? Collections.emptySet() : Collections.singleton(best);
    }

    @NotNull
    private static Map<String, VirtualFile> getSchemas(@NotNull Module module) {
        Project project;
        Map bundle;
        if (module == null) {
            SpringSchemaProvider.$$$reportNull$$$0(10);
        }
        Map map = (bundle = (Map)CachedValuesManager.getManager((Project)(project = module.getProject())).getCachedValue((UserDataHolder)module, SCHEMAS_BUNDLE_KEY, () -> SpringSchemaProvider.computeSchemas(module), false)) == null ? Collections.emptyMap() : bundle;
        if (map == null) {
            SpringSchemaProvider.$$$reportNull$$$0(11);
        }
        return map;
    }

    @NotNull
    public static Map<String, String> getHandlers(@NotNull Module module) {
        if (module == null) {
            SpringSchemaProvider.$$$reportNull$$$0(12);
        }
        return SpringSchemaProvider.computeHandlers(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static CachedValueProvider.Result<Map<String, VirtualFile>> computeSchemas(@NotNull Module module) {
        List<PsiFile> springSchemaFiles;
        if (module == null) {
            SpringSchemaProvider.$$$reportNull$$$0(13);
        }
        if ((springSchemaFiles = SpringCommonUtils.findConfigFilesInMetaInf(module, true, "spring.schemas", PsiFile.class)).isEmpty()) {
            CachedValueProvider.Result<Map<String, VirtualFile>> result = EMPTY_MAP_RESULT;
            if (result == null) {
                SpringSchemaProvider.$$$reportNull$$$0(14);
            }
            return result;
        }
        HashMap<String, VirtualFile> map = new HashMap<String, VirtualFile>();
        ArrayList<Object> dependencies = new ArrayList<Object>();
        dependencies.add(JavaLibraryModificationTracker.getInstance((Project)module.getProject()));
        for (PsiFile springSchemaPsiFile : springSchemaFiles) {
            dependencies.add(springSchemaPsiFile);
            PsiDirectory parent = springSchemaPsiFile.getContainingDirectory().getParent();
            assert (parent != null);
            Object root = parent.getVirtualFile().getUrl();
            if (!((String)root).endsWith("/")) {
                root = (String)root + "/";
            }
            InputStream inputStream = null;
            try {
                VirtualFile schemasFile = springSchemaPsiFile.getVirtualFile();
                inputStream = schemasFile.getInputStream();
                PropertyResourceBundle bundle = new PropertyResourceBundle(inputStream);
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    String namespace;
                    int lastCharPos;
                    char lastChar;
                    String key = keys.nextElement();
                    String location = (String)bundle.handleGetObject(key);
                    String schemaUrl = (String)root + location;
                    VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(schemaUrl);
                    if (file == null) continue;
                    map.put(key, file);
                    if (!key.endsWith(".xsd") || Character.isDigit(lastChar = key.charAt(lastCharPos = key.length() - ".xsd".length() - 1)) || (namespace = XmlNamespaceIndex.getNamespace((VirtualFile)file, (Project)module.getProject())) == null) continue;
                    map.put(namespace, file);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                CachedValueProvider.Result<Map<String, VirtualFile>> result = EMPTY_MAP_RESULT;
                CachedValueProvider.Result<Map<String, VirtualFile>> result2 = result;
                if (result2 == null) {
                    SpringSchemaProvider.$$$reportNull$$$0(15);
                }
                return result2;
            }
            finally {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        return new CachedValueProvider.Result(map, dependencies.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Map<String, String> computeHandlers(@NotNull Module module) {
        List<PsiFile> springHandlerFiles;
        if (module == null) {
            SpringSchemaProvider.$$$reportNull$$$0(16);
        }
        if ((springHandlerFiles = SpringCommonUtils.findConfigFilesInMetaInf(module, true, "spring.handlers", PsiFile.class)).isEmpty()) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                SpringSchemaProvider.$$$reportNull$$$0(17);
            }
            return map;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (PsiFile springHandlerFile : springHandlerFiles) {
            VirtualFile handlersFile = springHandlerFile.getVirtualFile();
            assert (handlersFile != null);
            InputStream inputStream = null;
            try {
                inputStream = handlersFile.getInputStream();
                PropertyResourceBundle bundle = new PropertyResourceBundle(inputStream);
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    map.put(key, (String)bundle.handleGetObject(key));
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                Map<String, String> map2 = Collections.emptyMap();
                Map<String, String> map3 = map2;
                if (map3 == null) {
                    SpringSchemaProvider.$$$reportNull$$$0(18);
                }
                return map3;
            }
            finally {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        HashMap<String, String> hashMap = map;
        if (hashMap == null) {
            SpringSchemaProvider.$$$reportNull$$$0(19);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 11, 14, 15, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/schemas/SpringSchemaProvider";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/schemas/SpringSchemaProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableNamespaces";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemas";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSchemas";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "computeHandlers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSchema";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableNamespaces";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPrefix";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLocations";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSchemas";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getHandlers";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computeSchemas";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "computeHandlers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 11, 14, 15, 17, 18, 19 -> new IllegalStateException(string);
        };
    }
}

