/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.settings;

import com.intellij.DynamicBundle;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.spring.settings.SpringSettingsProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class SpringGeneralSettingsUi
implements ConfigurableUi<SpringGeneralSettings> {
    private static final ExtensionPointName<SpringSettingsProvider<?>> EP_NAME = ExtensionPointName.create((String)"com.intellij.spring.settingsProvider");
    private final Project myProject;
    private final List<CustomConfigurable<?>> myConfigurables;
    private JPanel myRootPanel;
    private JBCheckBox myShowProfilesPanel;
    private JBCheckBox myShowMultiContextsPanel;
    private JBCheckBox mySmartCompletionAvailability;
    private JPanel myExtensionPanel;
    private ComboBox myComboBox1;

    SpringGeneralSettingsUi(@NotNull Project project) {
        if (project == null) {
            SpringGeneralSettingsUi.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myConfigurables = ContainerUtil.map((Collection)EP_NAME.getExtensionList(), this::getConfigurable);
        for (CustomConfigurable<?> configurable : this.myConfigurables) {
            this.myExtensionPanel.add(configurable.ui.getComponent());
        }
    }

    private void createUIComponents() {
        this.myExtensionPanel = new JPanel();
        BoxLayout layout = new BoxLayout(this.myExtensionPanel, 1);
        this.myExtensionPanel.setLayout(layout);
    }

    public void reset(@NotNull SpringGeneralSettings settings) {
        if (settings == null) {
            SpringGeneralSettingsUi.$$$reportNull$$$0(1);
        }
        this.myShowProfilesPanel.setSelected(settings.isShowProfilesPanel());
        this.myShowMultiContextsPanel.setSelected(settings.isShowMultipleContextsPanel());
        this.mySmartCompletionAvailability.setSelected(settings.isSmartCompletionAvailability());
        for (CustomConfigurable<?> configurable : this.myConfigurables) {
            configurable.reset();
        }
    }

    public boolean isModified(@NotNull SpringGeneralSettings settings) {
        if (settings == null) {
            SpringGeneralSettingsUi.$$$reportNull$$$0(2);
        }
        return this.hasModifiedEditorPanelSettings(settings) || ContainerUtil.or(this.myConfigurables, CustomConfigurable::isModified);
    }

    private boolean hasModifiedEditorPanelSettings(@NotNull SpringGeneralSettings settings) {
        if (settings == null) {
            SpringGeneralSettingsUi.$$$reportNull$$$0(3);
        }
        return settings.isShowProfilesPanel() != this.myShowProfilesPanel.isSelected() || settings.isShowMultipleContextsPanel() != this.myShowMultiContextsPanel.isSelected() || settings.isSmartCompletionAvailability() != this.mySmartCompletionAvailability.isSelected();
    }

    public void apply(@NotNull SpringGeneralSettings settings) throws ConfigurationException {
        if (settings == null) {
            SpringGeneralSettingsUi.$$$reportNull$$$0(4);
        }
        if (this.hasModifiedEditorPanelSettings(settings)) {
            settings.setShowProfilesPanel(this.myShowProfilesPanel.isSelected());
            settings.setShowMultipleContextsPanel(this.myShowMultiContextsPanel.isSelected());
            settings.setSmartCompletionAvailability(this.mySmartCompletionAvailability.isSelected());
            EditorNotifications.updateAll();
        }
        for (CustomConfigurable<?> configurable : this.myConfigurables) {
            configurable.apply();
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            SpringGeneralSettingsUi.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    private <T> CustomConfigurable<T> getConfigurable(SpringSettingsProvider<T> provider) {
        return new CustomConfigurable<T>(provider.getConfigurableUi(this.myProject), provider.getSettings(this.myProject));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 2, 2, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/SpringBundle", SpringGeneralSettingsUi.class).getString("spring.settings.configuration.file.editor"), (int)1, (int)0, null, null));
        this.myShowProfilesPanel = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/SpringBundle", SpringGeneralSettingsUi.class).getString("spring.settings.profiles.panel"));
        jBCheckBox3.setToolTipText(DynamicBundle.getBundle((String)"messages/SpringBundle", SpringGeneralSettingsUi.class).getString("spring.settings.profiles.panel.tooltip"));
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShowMultiContextsPanel = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/SpringBundle", SpringGeneralSettingsUi.class).getString("spring.settings.multiple.context.panel"));
        jBCheckBox2.setToolTipText(DynamicBundle.getBundle((String)"messages/SpringBundle", SpringGeneralSettingsUi.class).getString("spring.settings.multiple.context.panel.tooltip"));
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/SpringBundle", SpringGeneralSettingsUi.class).getString("spring.settings.configuration.completion"), (int)1, (int)0, null, null));
        this.mySmartCompletionAvailability = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/SpringBundle", SpringGeneralSettingsUi.class).getString("spring.settings.smartCompletionAvailability"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = this.myExtensionPanel;
        jPanel.add((Component)jPanel4, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/settings/SpringGeneralSettingsUi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/settings/SpringGeneralSettingsUi";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasModifiedEditorPanelSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private record CustomConfigurable<T>(ConfigurableUi<T> ui, T settings) {
        void reset() {
            this.ui.reset(this.settings);
        }

        void apply() throws ConfigurationException {
            this.ui.apply(this.settings);
        }

        boolean isModified() {
            return this.ui.isModified(this.settings);
        }
    }
}

