/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.spi;

import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.spi.SpringSpiIconService;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SpringFactoriesFileType
extends LanguageFileType
implements FileTypeIdentifiableByVirtualFile {
    public static final SpringFactoriesFileType FILE_TYPE = new SpringFactoriesFileType();
    static final String SPRING_FACTORIES_FILE_NAME = "spring.factories";
    static final String AOT_FACTORIES_FILE_NAME = "aot.factories";

    private SpringFactoriesFileType() {
        super((Language)PropertiesLanguage.INSTANCE, true);
    }

    public boolean isMyFileType(@NotNull VirtualFile file) {
        if (file == null) {
            SpringFactoriesFileType.$$$reportNull$$$0(0);
        }
        if (Comparing.equal((CharSequence)SPRING_FACTORIES_FILE_NAME, (CharSequence)file.getNameSequence())) {
            VirtualFile parent = file.getParent();
            return parent != null && Comparing.equal((CharSequence)"META-INF", (CharSequence)parent.getNameSequence());
        }
        if (Comparing.equal((CharSequence)AOT_FACTORIES_FILE_NAME, (CharSequence)file.getNameSequence())) {
            VirtualFile parent = file.getParent();
            if (parent == null || !Comparing.equal((CharSequence)"spring", (CharSequence)parent.getNameSequence())) {
                return false;
            }
            return (parent = parent.getParent()) != null && Comparing.equal((CharSequence)"META-INF", (CharSequence)parent.getNameSequence());
        }
        return false;
    }

    @NotNull
    public String getName() {
        return SPRING_FACTORIES_FILE_NAME;
    }

    @NotNull
    public String getDescription() {
        return SPRING_FACTORIES_FILE_NAME;
    }

    @NotNull
    public String getDisplayName() {
        String string = SpringBundle.message("spring.factories.file.type", new Object[0]);
        if (string == null) {
            SpringFactoriesFileType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        return "";
    }

    public Icon getIcon() {
        return SpringSpiIconService.getInstance().getFileIcon();
    }

    public String getCharset(@NotNull VirtualFile file, byte @NotNull [] content) {
        if (file == null) {
            SpringFactoriesFileType.$$$reportNull$$$0(2);
        }
        if (content == null) {
            SpringFactoriesFileType.$$$reportNull$$$0(3);
        }
        return PropertiesFileType.INSTANCE.getCharset(file, content);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/spi/SpringFactoriesFileType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/spi/SpringFactoriesFileType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMyFileType";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCharset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

