/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.spi;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.gutter.SpringBeanAnnotator;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.spi.SpringSpiIconService;
import com.intellij.spring.spi.SpringSpiRegistrationLineMarker;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J4\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\u0012\u0010\u000f\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010H\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/spring/spi/SpringSpiRegistrationAnnotator;", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerProvider;", "<init>", "()V", "getId", "", "Lorg/jetbrains/annotations/NonNls;", "getName", "getIcon", "Ljavax/swing/Icon;", "collectNavigationMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "forNavigation", "", "element", "intellij.spring.core"})
public final class SpringSpiRegistrationAnnotator
extends RelatedItemLineMarkerProvider {
    @NotNull
    public String getId() {
        return "SpringSpiRegistrationAnnotator";
    }

    @NotNull
    public String getName() {
        String string = SpringBundle.message("SpringSpiRegistrationAnnotator.spring.factories.registration", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = SpringSpiIconService.getInstance().getFileIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getFileIcon(...)");
        return icon;
    }

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
        if (psiElement == null || !SpringLibraryUtil.hasSpringLibrary(psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        if (!SpringLibraryUtil.hasSpringLibrary(element.getProject())) {
            return;
        }
        UElement uElement = UastUtils.getUParentForIdentifier((PsiElement)element);
        UClass uClass = uElement instanceof UClass ? (UClass)uElement : null;
        if (uClass == null) {
            return;
        }
        UClass uClass2 = uClass;
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uClass2.getUastAnchor());
        if (psiElement == null) {
            return;
        }
        PsiElement nameIdentifier = psiElement;
        PsiClass psiClass = uClass2.getJavaPsi();
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass) || SpringBeanAnnotator.looksLikeStereotypeBean(psiClass) || SpringBeanAnnotator.isXmlMappedBean(psiClass)) {
            return;
        }
        SpringSpiRegistrationLineMarker.annotateRelated(psiClass, nameIdentifier, result);
    }
}

