/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config;

import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.quarkus.config.QsConfigFileContributor;
import com.intellij.quarkus.config.QsConfigKeyData;
import com.intellij.quarkus.config.QsConfigValueProcessor;
import com.intellij.quarkus.config.QsMetaConfigKey;
import com.intellij.quarkus.config.QsMetaConfigKeyManager;
import com.intellij.util.Processor;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0018\u0019BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0010\u001a\u0004\u0018\u00010\tJ\u0016\u0010\u0011\u001a\u00020\u00052\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00140\u0013J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/quarkus/config/QsConfigValueSearcher;", "", "module", "Lcom/intellij/openapi/module/Module;", "includeTests", "", "configKeyData", "Lcom/intellij/quarkus/config/QsConfigKeyData;", "activeProfile", "", "strictProfile", "documentId", "", "<init>", "(Lcom/intellij/openapi/module/Module;ZLcom/intellij/quarkus/config/QsConfigKeyData;Ljava/lang/String;ZLjava/lang/Integer;)V", "Ljava/lang/Integer;", "findValueText", "process", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueResult;", "createFakeConfigKey", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "configKey", "QsConfigValueSearchParams", "QsConfigValueResult", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQsConfigValueSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsConfigValueSearcher.kt\ncom/intellij/quarkus/config/QsConfigValueSearcher\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,108:1\n19#2:109\n*S KotlinDebug\n*F\n+ 1 QsConfigValueSearcher.kt\ncom/intellij/quarkus/config/QsConfigValueSearcher\n*L\n50#1:109\n*E\n"})
public final class QsConfigValueSearcher {
    @NotNull
    private final Module module;
    private final boolean includeTests;
    @NotNull
    private final QsConfigKeyData configKeyData;
    @Nullable
    private final String activeProfile;
    private final boolean strictProfile;
    @Nullable
    private final Integer documentId;

    public QsConfigValueSearcher(@NotNull Module module, boolean includeTests, @NotNull QsConfigKeyData configKeyData, @Nullable String activeProfile, boolean strictProfile, @Nullable Integer documentId) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)configKeyData, (String)"configKeyData");
        this.module = module;
        this.includeTests = includeTests;
        this.configKeyData = configKeyData;
        this.activeProfile = activeProfile;
        this.strictProfile = strictProfile;
        this.documentId = documentId;
    }

    public /* synthetic */ QsConfigValueSearcher(Module module, boolean bl, QsConfigKeyData qsConfigKeyData, String string, boolean bl2, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            string = null;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x20) != 0) {
            n = null;
        }
        this(module, bl, qsConfigKeyData, string, bl2, n);
    }

    @Nullable
    public final String findValueText() {
        QsConfigValueProcessor processor2 = new QsConfigValueProcessor();
        this.process((Processor<? super QsConfigValueResult>)((Processor)processor2));
        return processor2.getValue();
    }

    public final boolean process(@NotNull Processor<? super QsConfigValueResult> processor2) {
        MetaConfigKey metaConfigKey;
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        if (this.configKeyData.isWithFakeKey()) {
            metaConfigKey = this.createFakeConfigKey(this.module, this.configKeyData);
        } else {
            metaConfigKey = QsMetaConfigKeyManager.Companion.getInstance().findApplicationMetaConfigKey(this.module, this.configKeyData.getConfigKey());
            if (metaConfigKey == null) {
                return false;
            }
        }
        MetaConfigKey metaConfigKey2 = metaConfigKey;
        List<Pair<VirtualFile, QsConfigFileContributor>> configs = QsConfigFileContributor.Companion.findConfigFiles(this.module, this.includeTests);
        PsiManager psiManager = PsiManager.getInstance((Project)this.module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        for (Pair<VirtualFile, QsConfigFileContributor> config : configs) {
            PsiFile configPsiFile;
            if (psiManager2.findFile((VirtualFile)config.getFirst()) == null) continue;
            QsConfigValueSearchParams params = new QsConfigValueSearchParams(this.module, configPsiFile, this.activeProfile, this.strictProfile, metaConfigKey2, this.documentId);
            if (((QsConfigFileContributor)config.getSecond()).processConfigValues(params, processor2)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final MetaConfigKey createFakeConfigKey(Module module, QsConfigKeyData configKey) {
        QsMetaConfigKey qsMetaConfigKey;
        MetaConfigKey metaConfigKey = QsMetaConfigKeyManager.Companion.getInstance().findApplicationMetaConfigKey(module, this.configKeyData.getConfigurationConfigKeyName());
        if (metaConfigKey != null) {
            void $this$asSafely$iv;
            MetaConfigKey metaConfigKey2 = metaConfigKey;
            boolean $i$f$asSafely = false;
            Object v0 = $this$asSafely$iv;
            if (!(v0 instanceof QsMetaConfigKey)) {
                v0 = null;
            }
            qsMetaConfigKey = v0;
        } else {
            qsMetaConfigKey = null;
        }
        QsMetaConfigKey originalDeclaration = qsMetaConfigKey;
        PsiClass psiClass = PsiElementFactory.getInstance((Project)module.getProject()).createClass("dummy");
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"createClass(...)");
        PsiClass fakeDeclaration = psiClass;
        QsMetaConfigKey qsMetaConfigKey2 = originalDeclaration;
        if (qsMetaConfigKey2 == null || (qsMetaConfigKey2 = qsMetaConfigKey2.getMapKeyType()) == null) {
            qsMetaConfigKey2 = fakeDeclaration;
        }
        PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)qsMetaConfigKey2;
        String string = configKey.getConfigKey();
        QsMetaConfigKey qsMetaConfigKey3 = originalDeclaration;
        if (qsMetaConfigKey3 == null || (qsMetaConfigKey3 = qsMetaConfigKey3.getType()) == null) {
            PsiClassType psiClassType = PsiTypesUtil.getClassType((PsiClass)fakeDeclaration);
            Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"getClassType(...)");
            qsMetaConfigKey3 = (PsiType)psiClassType;
        }
        return (MetaConfigKey)new QsMetaConfigKey(psiModifierListOwner, string, null, (PsiType)qsMetaConfigKey3, null, null, 48, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J5\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueResult;", "", "keyElement", "Lcom/intellij/psi/PsiElement;", "valueElement", "valueText", "", "params", "Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueSearchParams;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueSearchParams;)V", "getKeyElement", "()Lcom/intellij/psi/PsiElement;", "getValueElement", "getValueText", "()Ljava/lang/String;", "getParams", "()Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueSearchParams;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.quarkus"})
    public static final class QsConfigValueResult {
        @NotNull
        private final PsiElement keyElement;
        @Nullable
        private final PsiElement valueElement;
        @Nullable
        private final String valueText;
        @NotNull
        private final QsConfigValueSearchParams params;

        public QsConfigValueResult(@NotNull PsiElement keyElement, @Nullable PsiElement valueElement, @Nullable String valueText, @NotNull QsConfigValueSearchParams params) {
            Intrinsics.checkNotNullParameter((Object)keyElement, (String)"keyElement");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            this.keyElement = keyElement;
            this.valueElement = valueElement;
            this.valueText = valueText;
            this.params = params;
        }

        @NotNull
        public final PsiElement getKeyElement() {
            return this.keyElement;
        }

        @Nullable
        public final PsiElement getValueElement() {
            return this.valueElement;
        }

        @Nullable
        public final String getValueText() {
            return this.valueText;
        }

        @NotNull
        public final QsConfigValueSearchParams getParams() {
            return this.params;
        }

        @NotNull
        public final PsiElement component1() {
            return this.keyElement;
        }

        @Nullable
        public final PsiElement component2() {
            return this.valueElement;
        }

        @Nullable
        public final String component3() {
            return this.valueText;
        }

        @NotNull
        public final QsConfigValueSearchParams component4() {
            return this.params;
        }

        @NotNull
        public final QsConfigValueResult copy(@NotNull PsiElement keyElement, @Nullable PsiElement valueElement, @Nullable String valueText, @NotNull QsConfigValueSearchParams params) {
            Intrinsics.checkNotNullParameter((Object)keyElement, (String)"keyElement");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            return new QsConfigValueResult(keyElement, valueElement, valueText, params);
        }

        public static /* synthetic */ QsConfigValueResult copy$default(QsConfigValueResult qsConfigValueResult, PsiElement psiElement, PsiElement psiElement2, String string, QsConfigValueSearchParams qsConfigValueSearchParams, int n, Object object) {
            if ((n & 1) != 0) {
                psiElement = qsConfigValueResult.keyElement;
            }
            if ((n & 2) != 0) {
                psiElement2 = qsConfigValueResult.valueElement;
            }
            if ((n & 4) != 0) {
                string = qsConfigValueResult.valueText;
            }
            if ((n & 8) != 0) {
                qsConfigValueSearchParams = qsConfigValueResult.params;
            }
            return qsConfigValueResult.copy(psiElement, psiElement2, string, qsConfigValueSearchParams);
        }

        @NotNull
        public String toString() {
            return "QsConfigValueResult(keyElement=" + this.keyElement + ", valueElement=" + this.valueElement + ", valueText=" + this.valueText + ", params=" + this.params + ")";
        }

        public int hashCode() {
            int result = this.keyElement.hashCode();
            result = result * 31 + (this.valueElement == null ? 0 : this.valueElement.hashCode());
            result = result * 31 + (this.valueText == null ? 0 : this.valueText.hashCode());
            result = result * 31 + this.params.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof QsConfigValueResult)) {
                return false;
            }
            QsConfigValueResult qsConfigValueResult = (QsConfigValueResult)other;
            if (!Intrinsics.areEqual((Object)this.keyElement, (Object)qsConfigValueResult.keyElement)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.valueElement, (Object)qsConfigValueResult.valueElement)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.valueText, (Object)qsConfigValueResult.valueText)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.params, (Object)qsConfigValueResult.params);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u001c\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J\t\u0010!\u001a\u00020\u000bH\u00c6\u0003J\u0010\u0010\"\u001a\u0004\u0018\u00010\rH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001bJN\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u00c6\u0001\u00a2\u0006\u0002\u0010$J\u0013\u0010%\u001a\u00020\t2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020\rH\u00d6\u0001J\t\u0010(\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0015\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006)"}, d2={"Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueSearchParams;", "", "module", "Lcom/intellij/openapi/module/Module;", "configFile", "Lcom/intellij/psi/PsiFile;", "activeProfile", "", "strictProfile", "", "configKey", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "documentId", "", "<init>", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/PsiFile;Ljava/lang/String;ZLcom/intellij/microservices/jvm/config/MetaConfigKey;Ljava/lang/Integer;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getConfigFile", "()Lcom/intellij/psi/PsiFile;", "getActiveProfile", "()Ljava/lang/String;", "getStrictProfile", "()Z", "getConfigKey", "()Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "getDocumentId", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/PsiFile;Ljava/lang/String;ZLcom/intellij/microservices/jvm/config/MetaConfigKey;Ljava/lang/Integer;)Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueSearchParams;", "equals", "other", "hashCode", "toString", "intellij.quarkus"})
    public static final class QsConfigValueSearchParams {
        @NotNull
        private final Module module;
        @NotNull
        private final PsiFile configFile;
        @Nullable
        private final String activeProfile;
        private final boolean strictProfile;
        @NotNull
        private final MetaConfigKey configKey;
        @Nullable
        private final Integer documentId;

        public QsConfigValueSearchParams(@NotNull Module module, @NotNull PsiFile configFile, @Nullable String activeProfile, boolean strictProfile, @NotNull MetaConfigKey configKey, @Nullable Integer documentId) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
            Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
            this.module = module;
            this.configFile = configFile;
            this.activeProfile = activeProfile;
            this.strictProfile = strictProfile;
            this.configKey = configKey;
            this.documentId = documentId;
        }

        public /* synthetic */ QsConfigValueSearchParams(Module module, PsiFile psiFile, String string, boolean bl, MetaConfigKey metaConfigKey, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                bl = false;
            }
            if ((n2 & 0x20) != 0) {
                n = null;
            }
            this(module, psiFile, string, bl, metaConfigKey, n);
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final PsiFile getConfigFile() {
            return this.configFile;
        }

        @Nullable
        public final String getActiveProfile() {
            return this.activeProfile;
        }

        public final boolean getStrictProfile() {
            return this.strictProfile;
        }

        @NotNull
        public final MetaConfigKey getConfigKey() {
            return this.configKey;
        }

        @Nullable
        public final Integer getDocumentId() {
            return this.documentId;
        }

        @NotNull
        public final Module component1() {
            return this.module;
        }

        @NotNull
        public final PsiFile component2() {
            return this.configFile;
        }

        @Nullable
        public final String component3() {
            return this.activeProfile;
        }

        public final boolean component4() {
            return this.strictProfile;
        }

        @NotNull
        public final MetaConfigKey component5() {
            return this.configKey;
        }

        @Nullable
        public final Integer component6() {
            return this.documentId;
        }

        @NotNull
        public final QsConfigValueSearchParams copy(@NotNull Module module, @NotNull PsiFile configFile, @Nullable String activeProfile, boolean strictProfile, @NotNull MetaConfigKey configKey, @Nullable Integer documentId) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
            Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
            return new QsConfigValueSearchParams(module, configFile, activeProfile, strictProfile, configKey, documentId);
        }

        public static /* synthetic */ QsConfigValueSearchParams copy$default(QsConfigValueSearchParams qsConfigValueSearchParams, Module module, PsiFile psiFile, String string, boolean bl, MetaConfigKey metaConfigKey, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                module = qsConfigValueSearchParams.module;
            }
            if ((n2 & 2) != 0) {
                psiFile = qsConfigValueSearchParams.configFile;
            }
            if ((n2 & 4) != 0) {
                string = qsConfigValueSearchParams.activeProfile;
            }
            if ((n2 & 8) != 0) {
                bl = qsConfigValueSearchParams.strictProfile;
            }
            if ((n2 & 0x10) != 0) {
                metaConfigKey = qsConfigValueSearchParams.configKey;
            }
            if ((n2 & 0x20) != 0) {
                n = qsConfigValueSearchParams.documentId;
            }
            return qsConfigValueSearchParams.copy(module, psiFile, string, bl, metaConfigKey, n);
        }

        @NotNull
        public String toString() {
            return "QsConfigValueSearchParams(module=" + this.module + ", configFile=" + this.configFile + ", activeProfile=" + this.activeProfile + ", strictProfile=" + this.strictProfile + ", configKey=" + this.configKey + ", documentId=" + this.documentId + ")";
        }

        public int hashCode() {
            int result = this.module.hashCode();
            result = result * 31 + this.configFile.hashCode();
            result = result * 31 + (this.activeProfile == null ? 0 : this.activeProfile.hashCode());
            result = result * 31 + Boolean.hashCode(this.strictProfile);
            result = result * 31 + this.configKey.hashCode();
            result = result * 31 + (this.documentId == null ? 0 : ((Object)this.documentId).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof QsConfigValueSearchParams)) {
                return false;
            }
            QsConfigValueSearchParams qsConfigValueSearchParams = (QsConfigValueSearchParams)other;
            if (!Intrinsics.areEqual((Object)this.module, (Object)qsConfigValueSearchParams.module)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.configFile, (Object)qsConfigValueSearchParams.configFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.activeProfile, (Object)qsConfigValueSearchParams.activeProfile)) {
                return false;
            }
            if (this.strictProfile != qsConfigValueSearchParams.strictProfile) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.configKey, (Object)qsConfigValueSearchParams.configKey)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.documentId, (Object)qsConfigValueSearchParams.documentId);
        }
    }
}

