/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.properties;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.microservices.jvm.config.ConfigKeyParts;
import com.intellij.microservices.jvm.config.ConfigKeyPathReference;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.microservices.jvm.config.MicroservicesConfigUtils;
import com.intellij.microservices.jvm.config.properties.IndexAccessTextProcessor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.properties.QsPropertiesUtils;
import com.intellij.quarkus.config.properties.QsPropertySubKeyMetaConfigKeyReference;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/quarkus/config/properties/QsPropertiesInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "highlightIndexAccessExpressions", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "propertyKey", "Lcom/intellij/lang/properties/psi/impl/PropertyKeyImpl;", "configKey", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "intellij.quarkus"})
public final class QsPropertiesInspection
extends LocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PropertiesFile propertiesFile;
        block14: {
            block13: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                if (!(file instanceof PropertiesFile)) {
                    return null;
                }
                propertiesFile = (PropertiesFile)file;
                if (!QuarkusUtils.INSTANCE.hasQuarkusLibrary(propertiesFile.getProject())) break block13;
                PsiFile psiFile = propertiesFile.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                if (QsConfigUtils.INSTANCE.isConfigFile(psiFile)) break block14;
            }
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        for (IProperty property : propertiesFile.getProperties()) {
            PropertyValueImpl valueElement;
            Object[] objectArray;
            PropertyKeyImpl propertyKey;
            MetaConfigKey configKey;
            ProgressManager.checkCanceled();
            if (!(property instanceof PropertyImpl) || QsPropertiesUtils.INSTANCE.getPropertyKey$intellij_quarkus((PropertyImpl)property) == null || (configKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)((PsiElement)propertyKey))) == null) continue;
            if (!Intrinsics.areEqual((Object)configKey.getDeprecation(), (Object)MetaConfigKey.Deprecation.NOT_DEPRECATED)) {
                objectArray = new Object[]{configKey.getName()};
                holder.registerProblem((PsiElement)propertyKey, QuarkusBundle.message("quarkus.config.deprecated.key", objectArray), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
            }
            if (configKey.isAccessType(Arrays.copyOf(objectArray = MetaConfigKey.AccessType.MAP_GROUP, objectArray.length))) {
                String string = propertyKey.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                PsiReference[] keyParts = ConfigKeyParts.splitToParts((MetaConfigKey)configKey, (String)QsConfigUtils.INSTANCE.trimProfile(string), (boolean)false);
                if (keyParts == null || keyParts.getKeyIndex() == null) {
                    holder.registerProblem((PsiElement)propertyKey, QuarkusBundle.message("quarkus.inspections.config.properties.missing.map.key", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
                    continue;
                }
            }
            this.highlightIndexAccessExpressions(holder, propertyKey, configKey);
            if (MetaConfigKey.MAP_OR_INDEXED_WITHOUT_KEY_HINTS_CONDITION.value((Object)configKey)) {
                for (PsiReference reference : propertyKey.getReferences()) {
                    String string;
                    Object[] objectArray2;
                    if (reference instanceof ConfigKeyPathReference) {
                        if (((ConfigKeyPathReference)reference).isSoft() || ((ConfigKeyPathReference)reference).resolve() != null) continue;
                        holder.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), ProblemHighlightType.ERROR);
                        continue;
                    }
                    if (!(reference instanceof QsPropertySubKeyMetaConfigKeyReference)) continue;
                    MetaConfigKey resolvedKey = ((QsPropertySubKeyMetaConfigKeyReference)reference).getResolvedKey();
                    if (resolvedKey == null) {
                        if (((QsPropertySubKeyMetaConfigKeyReference)reference).getRangeInElement().isEmpty()) continue;
                        objectArray2 = new Object[]{((QsPropertySubKeyMetaConfigKeyReference)reference).getRangeInElement().substring(propertyKey.getText())};
                        holder.registerProblem(reference, QuarkusBundle.message("quarkus.config.unresolved.sub.key", objectArray2), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)resolvedKey.getDeprecation(), (Object)MetaConfigKey.Deprecation.NOT_DEPRECATED)) {
                        objectArray2 = new Object[]{resolvedKey.getName()};
                        holder.registerProblem(reference, QuarkusBundle.message("quarkus.config.deprecated.key", objectArray2), ProblemHighlightType.LIKE_DEPRECATED);
                    }
                    if (!resolvedKey.isAccessType(Arrays.copyOf(objectArray2 = MetaConfigKey.AccessType.MAP_GROUP, objectArray2.length))) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)propertyKey.getText(), (String)"getText(...)");
                    int n = ((QsPropertySubKeyMetaConfigKeyReference)reference).getRangeInElement().getStartOffset();
                    String string2 = string.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    ConfigKeyParts keyParts = ConfigKeyParts.splitToParts((MetaConfigKey)resolvedKey, (String)string2, (boolean)false);
                    if (keyParts != null && keyParts.getKeyIndex() != null) continue;
                    holder.registerProblem(reference, QuarkusBundle.message("quarkus.inspections.config.properties.missing.map.key", new Object[0]), ProblemHighlightType.ERROR);
                }
            }
            if (QsPropertiesUtils.INSTANCE.getPropertyValue$intellij_quarkus((PropertyImpl)property) == null) continue;
            MicroservicesConfigUtils.highlightValueReferences((PsiElement)((PsiElement)valueElement), (ProblemsHolder)holder);
        }
        return holder.getResultsArray();
    }

    private final void highlightIndexAccessExpressions(ProblemsHolder holder, PropertyKeyImpl propertyKey, MetaConfigKey configKey) {
        String string = propertyKey.getText();
        new IndexAccessTextProcessor(configKey, holder, propertyKey, string){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ PropertyKeyImpl $propertyKey;
            {
                this.$holder = $holder;
                this.$propertyKey = $propertyKey;
                super($super_call_param$1, $configKey);
            }

            protected void onMissingClosingBracket(int startIdx) {
                this.$holder.registerProblem((PsiElement)this.$propertyKey, QuarkusBundle.message("quarkus.inspections.config.properties.missing.closing.bracket", new Object[0]), ProblemHighlightType.ERROR, TextRange.from((int)startIdx, (int)1), new LocalQuickFix[0]);
            }

            protected void onMissingIndexValue(int startIdx) {
                this.$holder.registerProblem((PsiElement)this.$propertyKey, QuarkusBundle.message("quarkus.inspections.config.properties.missing.index.value", new Object[0]), ProblemHighlightType.ERROR, TextRange.from((int)startIdx, (int)2), new LocalQuickFix[0]);
            }

            protected void onBracket(int startIdx) {
            }

            protected void onIndexValue(TextRange indexValueRange) {
                Intrinsics.checkNotNullParameter((Object)indexValueRange, (String)"indexValueRange");
            }

            protected void onIndexValueNotInteger(TextRange indexValueRange) {
                Intrinsics.checkNotNullParameter((Object)indexValueRange, (String)"indexValueRange");
                this.$holder.registerProblem((PsiElement)this.$propertyKey, QuarkusBundle.message("quarkus.inspections.config.properties.non.integer.index", new Object[0]), ProblemHighlightType.ERROR, indexValueRange, new LocalQuickFix[0]);
            }
        }.process();
    }
}

