/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.cron;

import com.cronutils.model.definition.CronDefinition;
import com.intellij.cron.CronExpressionProvider;
import com.intellij.microservices.jvm.cron.JvmCronExpressionProvider;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.psi.PsiElement;
import com.intellij.quarkus.cron.QsCronDocumentationTarget;
import com.intellij.quarkus.cron.QsCronExpressionProviderKt;
import com.intellij.quarkus.cron.QsCronUtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/quarkus/cron/QsCronExpressionProvider;", "Lcom/intellij/microservices/jvm/cron/JvmCronExpressionProvider;", "<init>", "()V", "isCronLanguageInjection", "", "element", "Lcom/intellij/psi/PsiElement;", "isSuitableElement", "getCronDefinition", "Lcom/cronutils/model/definition/CronDefinition;", "cronExpr", "", "cronCompletionExamples", "", "getCronExpression", "createDocumentationTarget", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "intellij.quarkus"})
public final class QsCronExpressionProvider
implements JvmCronExpressionProvider {
    public boolean isCronLanguageInjection(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return QsCronUtilsKt.isSimpleValue(super.getCronExpression(element));
    }

    public boolean isSuitableElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return QsCronUtilsKt.isQsScheduledCronValue(element);
    }

    @NotNull
    public CronDefinition getCronDefinition(@NotNull String cronExpr, @Nullable PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)cronExpr, (String)"cronExpr");
        return QsCronExpressionProviderKt.getQS_CRON_DEFINITION();
    }

    @NotNull
    public List<String> cronCompletionExamples(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return QsCronExpressionProviderKt.getQS_CRON_EXAMPLES();
    }

    @Nullable
    public String getCronExpression(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = super.getCronExpression(element);
        if (string == null) {
            return null;
        }
        String value = string;
        if (QsCronUtilsKt.isSimpleValue(value)) {
            return value;
        }
        return QsCronUtilsKt.qsPropertyReferenceValue(element);
    }

    @NotNull
    public DocumentationTarget createDocumentationTarget(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return (DocumentationTarget)new QsCronDocumentationTarget(element, (CronExpressionProvider)this);
    }
}

