/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.jam.cache;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.JamNavigationUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.quarkus.CustomNavigationGutterIconBuilder;
import com.intellij.quarkus.QsLineMarkerBuilderKt;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.jam.cache.QsCacheModelKt;
import com.intellij.quarkus.jam.cache.model.QsCacheBaseElement;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaUltimateIcons;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J2\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0012\u0010\u000e\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J$\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fH\u0014J,\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J$\u0010\u001a\u001a\u00020\u00122\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/quarkus/jam/cache/QsCacheLineMarker;", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerProvider;", "<init>", "()V", "getId", "", "getName", "getIcon", "Ljavax/swing/Icon;", "collectNavigationMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "forNavigation", "", "element", "doAnnotateCacheable", "elementToAnnotate", "cacheableElement", "Lcom/intellij/quarkus/jam/cache/model/QsCacheBaseElement;", "findCacheableWithTheSameName", "", "hasSameNames", "names1", "names2", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQsCacheLineMarker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsCacheLineMarker.kt\ncom/intellij/quarkus/jam/cache/QsCacheLineMarker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1755#2,3:88\n*S KotlinDebug\n*F\n+ 1 QsCacheLineMarker.kt\ncom/intellij/quarkus/jam/cache/QsCacheLineMarker\n*L\n86#1:88,3\n*E\n"})
public final class QsCacheLineMarker
extends RelatedItemLineMarkerProvider {
    @NotNull
    public String getId() {
        return "QsCacheLineMarker";
    }

    @NotNull
    public String getName() {
        return QuarkusBundle.message("quarkus.cache.line.marker.name", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = JavaUltimateIcons.Cdi.Gutter.ShowCacheable;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ShowCacheable");
        return icon;
    }

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
        if (psiElement == null) {
            return;
        }
        PsiElement first = psiElement;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)first);
        if (module == null) {
            return;
        }
        Module module2 = module;
        if (!QuarkusUtils.INSTANCE.hasQuarkusLibrary(module2)) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        UDeclaration elementToProcess = UAnnotationUtils.getIdentifierAnnotationOwner((PsiElement)element);
        if (!(elementToProcess instanceof UMethod) && !(elementToProcess instanceof UClass)) {
            return;
        }
        PsiElement psiElement = ((UElement)elementToProcess).getJavaPsi();
        if (psiElement == null) {
            return;
        }
        PsiElement javaPsiElement = psiElement;
        for (QsCacheBaseElement cacheableElement : QsCacheModelKt.findAllCacheable(javaPsiElement)) {
            this.doAnnotateCacheable(element, result, cacheableElement);
        }
    }

    private final void doAnnotateCacheable(PsiElement elementToAnnotate, Collection<? super RelatedItemLineMarkerInfo<?>> result, QsCacheBaseElement cacheableElement) {
        PsiElement psiAnnotationIdentifier = UAnnotationUtils.getNameElement((UElement)UastContextKt.toUElement((PsiElement)((PsiElement)cacheableElement.getAnnotation())));
        if (Intrinsics.areEqual((Object)psiAnnotationIdentifier, (Object)elementToAnnotate)) {
            CustomNavigationGutterIconBuilder customNavigationGutterIconBuilder;
            NotNullFunction converter = QsCacheLineMarker::doAnnotateCacheable$lambda$0;
            Icon icon = JavaUltimateIcons.Cdi.Gutter.ShowCacheable;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ShowCacheable");
            CustomNavigationGutterIconBuilder $this$doAnnotateCacheable_u24lambda_u242 = customNavigationGutterIconBuilder = QsLineMarkerBuilderKt.createCustomNavigationBuilder(icon, converter, null);
            boolean bl = false;
            $this$doAnnotateCacheable_u24lambda_u242.setTargets(NotNullLazyValue.lazy(() -> QsCacheLineMarker.doAnnotateCacheable$lambda$2$lambda$1(this, cacheableElement)));
            $this$doAnnotateCacheable_u24lambda_u242.setTargetRenderer(JamNavigationUtilsKt::getCacheableTargetRenderer);
            $this$doAnnotateCacheable_u24lambda_u242.setPopupTitle(QuarkusBundle.message("quarkus.cache.element.choose.title", new Object[0]));
            $this$doAnnotateCacheable_u24lambda_u242.setTooltipText(QuarkusBundle.message("quarkus.cache.element.tooltip.text", new Object[0]));
            $this$doAnnotateCacheable_u24lambda_u242.setEmptyPopupText(QuarkusBundle.message("quarkus.cache.element.no.operations", new Object[0]));
            CustomNavigationGutterIconBuilder builder = customNavigationGutterIconBuilder;
            result.add(builder.createMergeableLineMarkerInfo(psiAnnotationIdentifier));
        }
    }

    private final Set<QsCacheBaseElement> findCacheableWithTheSameName(QsCacheBaseElement cacheableElement) {
        if (!cacheableElement.isValid()) {
            return SetsKt.emptySet();
        }
        PsiAnnotation psiElement = cacheableElement.getAnnotation();
        LinkedHashSet<QsCacheBaseElement> cacheableElements = new LinkedHashSet<QsCacheBaseElement>();
        Set<String> set = cacheableElement.getCacheNames();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getCacheNames(...)");
        Set<String> cacheNames = set;
        if (!((Collection)cacheNames).isEmpty()) {
            for (QsCacheBaseElement element : QsCacheModelKt.findAllCacheable((PsiElement)psiElement)) {
                Set<String> names;
                if (Intrinsics.areEqual((Object)element, (Object)cacheableElement)) continue;
                Intrinsics.checkNotNullExpressionValue(element.getCacheNames(), (String)"getCacheNames(...)");
                if (!this.hasSameNames(names, cacheNames)) continue;
                cacheableElements.add(element);
            }
        }
        return cacheableElements;
    }

    private final boolean hasSameNames(Set<String> names1, Set<String> names2) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = names2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!names1.contains(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final Collection doAnnotateCacheable$lambda$0(QsCacheBaseElement it) {
        return ContainerUtil.createMaybeSingletonList((Object)it.getAnnotation());
    }

    private static final Collection doAnnotateCacheable$lambda$2$lambda$1(QsCacheLineMarker this$0, QsCacheBaseElement $cacheableElement) {
        return this$0.findCacheableWithTheSameName($cacheableElement);
    }
}

