/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.qute.lang.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.quarkus.qute.lang.QuteFileViewProvider;
import com.intellij.quarkus.qute.lang.QuteLanguage;
import com.intellij.quarkus.qute.lang.psi.tree.QuteElementTypesGenerated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/quarkus/qute/lang/completion/QuteTypedHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "<init>", "()V", "beforeCharTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "handleTagOpenerChar", "intellij.quarkus"})
public final class QuteTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        FileViewProvider fileViewProvider = file.getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"getViewProvider(...)");
        FileViewProvider viewProvider = fileViewProvider;
        return viewProvider instanceof QuteFileViewProvider && c == '#' ? this.handleTagOpenerChar(c, editor, project) : TypedHandlerDelegate.Result.CONTINUE;
    }

    private final TypedHandlerDelegate.Result handleTagOpenerChar(char c, Editor editor, Project project) {
        int offset = editor.getCaretModel().getOffset();
        if (offset < 1) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        IElementType previousElementType = editor.getHighlighter().createIterator(offset - 1).getTokenType();
        if (previousElementType.getLanguage().isKindOf((Language)QuteLanguage.INSTANCE) && previousElementType != QuteElementTypesGenerated.EXPR_START) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (c == '#') {
            AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor);
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }
}

