/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.run;

import com.intellij.application.options.ModuleDescriptionsComboBox;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ConfigurationSettingsEditor;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.run.QsExternalSystemBridge;
import com.intellij.quarkus.run.QsRunConfiguration;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanelWithEmptyText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0014J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J2\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00192\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/quarkus/run/QsRunConfigurationSettingEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/quarkus/run/QsRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "mainPanel", "Ljavax/swing/JPanel;", "moduleComponent", "Lcom/intellij/openapi/ui/LabeledComponent;", "Lcom/intellij/application/options/ModuleDescriptionsComboBox;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "moduleSelector", "Lcom/intellij/execution/ui/ConfigurationModuleSelector;", "environmentSettingsPanel", "emptyEnvironmentPanel", "delegateEditor", "Lcom/intellij/quarkus/run/QsRunConfigurationSettingEditor$DelegateEditor;", "resetEditorFrom", "", "s", "applyEditorTo", "createEditor", "Ljavax/swing/JComponent;", "installHideableDecorator", "panel", "content", "title", "", "expandPropertyKey", "defaultState", "", "DelegateEditor", "intellij.quarkus"})
public final class QsRunConfigurationSettingEditor
extends SettingsEditor<QsRunConfiguration> {
    @NotNull
    private final Project project;
    @NotNull
    private final JPanel mainPanel;
    @NotNull
    private final LabeledComponent<ModuleDescriptionsComboBox> moduleComponent;
    @NotNull
    private final ConfigurationModuleSelector moduleSelector;
    @NotNull
    private final JPanel environmentSettingsPanel;
    @NotNull
    private final JPanel emptyEnvironmentPanel;
    @Nullable
    private DelegateEditor delegateEditor;

    public QsRunConfigurationSettingEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.mainPanel = new JPanel(new BorderLayout());
        LabeledComponent labeledComponent = LabeledComponent.create((JComponent)((JComponent)new ModuleDescriptionsComboBox()), (String)QuarkusBundle.message("run.configuration.application.module", new Object[0]), (String)"West");
        Intrinsics.checkNotNullExpressionValue((Object)labeledComponent, (String)"create(...)");
        this.moduleComponent = labeledComponent;
        this.environmentSettingsPanel = new JPanel(new BorderLayout());
        this.emptyEnvironmentPanel = new JPanel(new BorderLayout());
        Project project2 = this.project;
        ModuleDescriptionsComboBox moduleDescriptionsComboBox = (ModuleDescriptionsComboBox)this.moduleComponent.getComponent();
        this.moduleSelector = new ConfigurationModuleSelector(project2, moduleDescriptionsComboBox){

            public boolean isModuleAccepted(Module module) {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                return QuarkusUtils.INSTANCE.hasQuarkusLibrary(module);
            }
        };
        this.moduleSelector.reset();
        ((ModuleDescriptionsComboBox)this.moduleComponent.getComponent()).addActionListener(arg_0 -> QsRunConfigurationSettingEditor._init_$lambda$0(this, arg_0));
        this.mainPanel.add((Component)this.moduleComponent, "North");
        JPanel hideableEnvironmentSettingsPanel = new JPanel(new BorderLayout());
        this.installHideableDecorator(hideableEnvironmentSettingsPanel, this.environmentSettingsPanel, QuarkusBundle.message("run.configuration.environment", new Object[0]), "ExpandQuarkusEnvironmentOptionsPanel", false);
        this.mainPanel.add((Component)hideableEnvironmentSettingsPanel, "Center");
        this.emptyEnvironmentPanel.add((Component)new JBLabel(" "), "West");
        this.emptyEnvironmentPanel.add((Component)new JBLabel(" "), "East");
        this.emptyEnvironmentPanel.add((Component)new JBPanelWithEmptyText().withEmptyText(QuarkusBundle.message("run.configuration.no.module.selected", new Object[0])), "Center");
        this.environmentSettingsPanel.add((Component)this.emptyEnvironmentPanel, "Center");
    }

    protected void resetEditorFrom(@NotNull QsRunConfiguration s) {
        RunConfiguration delegateConfig;
        Intrinsics.checkNotNullParameter((Object)((Object)s), (String)"s");
        this.moduleSelector.reset((ModuleBasedConfiguration)s);
        DelegateEditor editor = this.delegateEditor;
        if (editor != null && (delegateConfig = s.getDelegateConfiguration$intellij_quarkus()) != null) {
            RunManager runManager = RunManager.Companion.getInstance(this.project);
            ConfigurationFactory configurationFactory = delegateConfig.getFactory();
            Intrinsics.checkNotNull((Object)configurationFactory);
            RunnerAndConfigurationSettings settings = runManager.createConfiguration(delegateConfig, configurationFactory);
            editor.getEditor().resetEditorFrom((Object)settings);
        }
    }

    protected void applyEditorTo(@NotNull QsRunConfiguration s) {
        Intrinsics.checkNotNullParameter((Object)((Object)s), (String)"s");
        s.setModule(this.moduleSelector.getModule());
        DelegateEditor editor = this.delegateEditor;
        if (editor != null) {
            editor.getEditor().applyEditorTo((Object)editor.getSettings());
            s.setDelegateConfiguration$intellij_quarkus(editor.getSettings().getConfiguration());
        }
    }

    @NotNull
    protected JComponent createEditor() {
        return this.mainPanel;
    }

    private final void installHideableDecorator(JPanel panel, JComponent content, @NlsContexts.Separator String title, String expandPropertyKey, boolean defaultState) {
        HideableDecorator hideableDecorator2 = new HideableDecorator(panel, title, this, expandPropertyKey, defaultState){
            final /* synthetic */ QsRunConfigurationSettingEditor this$0;
            final /* synthetic */ String $expandPropertyKey;
            final /* synthetic */ boolean $defaultState;
            {
                this.this$0 = $receiver;
                this.$expandPropertyKey = $expandPropertyKey;
                this.$defaultState = $defaultState;
                super($panel, $title, false);
            }

            protected void on() {
                super.on();
                this.storeState();
            }

            protected void off() {
                super.off();
                this.storeState();
            }

            private final void storeState() {
                PropertiesComponent.getInstance((Project)QsRunConfigurationSettingEditor.access$getProject$p(this.this$0)).setValue(this.$expandPropertyKey, this.isExpanded(), this.$defaultState);
            }
        };
        hideableDecorator2.setOn(PropertiesComponent.getInstance((Project)this.project).getBoolean(expandPropertyKey, defaultState));
        hideableDecorator2.setContentComponent(content);
    }

    private static final void _init_$lambda$0(QsRunConfigurationSettingEditor this$0, ActionEvent it) {
        DelegateEditor delegateEditor;
        RunConfiguration delegate;
        Module module;
        Component[] components = this$0.environmentSettingsPanel.getComponents();
        DelegateEditor oldEditor = this$0.delegateEditor;
        Module module2 = module = (this$0.moduleSelector).getModule();
        RunConfiguration runConfiguration = delegate = module2 == null ? null : QsExternalSystemBridge.Companion.findDelegate(module2);
        if (delegate != null && Intrinsics.areEqual((Object)((delegateEditor = oldEditor) != null && (delegateEditor = delegateEditor.getSettings()) != null ? delegateEditor.getType() : null), (Object)delegate.getType())) {
            Project project = delegate.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RunManager runManager = RunManager.Companion.getInstance(project);
            ConfigurationFactory configurationFactory = delegate.getFactory();
            Intrinsics.checkNotNull((Object)configurationFactory);
            oldEditor.setSettings(runManager.createConfiguration(delegate, configurationFactory));
            return;
        }
        Intrinsics.checkNotNull((Object)components);
        if (!(components.length == 0)) {
            this$0.environmentSettingsPanel.remove(0);
        }
        if (delegate == null) {
            this$0.environmentSettingsPanel.add((Component)this$0.emptyEnvironmentPanel, "Center");
            this$0.delegateEditor = null;
        } else {
            DelegateEditor newEditor = new DelegateEditor(delegate);
            Disposer.register((Disposable)((Disposable)this$0), (Disposable)((Disposable)newEditor.getEditor()));
            this$0.environmentSettingsPanel.add((Component)newEditor.getEditor().getComponent(), "Center");
            newEditor.getEditor().resetEditorFrom((Object)newEditor.getSettings());
            this$0.delegateEditor = newEditor;
        }
        if (oldEditor != null) {
            Disposer.dispose((Disposable)((Disposable)oldEditor.getEditor()));
        }
    }

    public static final /* synthetic */ Project access$getProject$p(QsRunConfigurationSettingEditor $this) {
        return $this.project;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/quarkus/run/QsRunConfigurationSettingEditor$DelegateEditor;", "", "delegate", "Lcom/intellij/execution/configurations/RunConfiguration;", "<init>", "(Lcom/intellij/execution/configurations/RunConfiguration;)V", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "getSettings", "()Lcom/intellij/execution/RunnerAndConfigurationSettings;", "setSettings", "(Lcom/intellij/execution/RunnerAndConfigurationSettings;)V", "editor", "Lcom/intellij/execution/impl/ConfigurationSettingsEditor;", "getEditor", "()Lcom/intellij/execution/impl/ConfigurationSettingsEditor;", "intellij.quarkus"})
    private static final class DelegateEditor {
        @NotNull
        private RunnerAndConfigurationSettings settings;
        @NotNull
        private final ConfigurationSettingsEditor editor;

        public DelegateEditor(@NotNull RunConfiguration delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            SettingsEditor settingsEditor = delegate.getConfigurationEditor();
            Intrinsics.checkNotNull((Object)settingsEditor, (String)"null cannot be cast to non-null type com.intellij.openapi.options.SettingsEditor<com.intellij.execution.configurations.RunConfiguration>");
            SettingsEditor delegateEditor = settingsEditor;
            Project project = delegate.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RunManager runManager = RunManager.Companion.getInstance(project);
            ConfigurationFactory configurationFactory = delegate.getFactory();
            Intrinsics.checkNotNull((Object)configurationFactory);
            this.settings = runManager.createConfiguration(delegate, configurationFactory);
            this.editor = new ConfigurationSettingsEditor(this.settings, delegateEditor);
        }

        @NotNull
        public final RunnerAndConfigurationSettings getSettings() {
            return this.settings;
        }

        public final void setSettings(@NotNull RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
            Intrinsics.checkNotNullParameter((Object)runnerAndConfigurationSettings, (String)"<set-?>");
            this.settings = runnerAndConfigurationSettings;
        }

        @NotNull
        public final ConfigurationSettingsEditor getEditor() {
            return this.editor;
        }
    }
}

