/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.run.extensions;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.buildsystem.model.DeclaredDependency;
import com.intellij.externalSystem.DependencyModifierService;
import com.intellij.ide.starters.shared.LibraryLink;
import com.intellij.ide.starters.shared.LibraryLinkType;
import com.intellij.ide.starters.shared.StarterWizardSettings;
import com.intellij.microservices.jvm.dependencies.FrameworkDependency;
import com.intellij.microservices.jvm.dependencies.FrameworkDependencyCoordinates;
import com.intellij.microservices.jvm.dependencies.FrameworkModuleBuilder;
import com.intellij.microservices.jvm.dependencies.FrameworkVersion;
import com.intellij.microservices.jvm.dependencies.Version;
import com.intellij.microservices.jvm.starters.WebStarterContext;
import com.intellij.microservices.jvm.starters.WebStarterDependency;
import com.intellij.microservices.jvm.starters.WebStarterDependencyCategory;
import com.intellij.microservices.jvm.starters.WebStarterFrameworkVersion;
import com.intellij.microservices.jvm.starters.WebStarterServerOptions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.quarkus.starter.QuarkusModuleBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/quarkus/run/extensions/QsExtensionsModuleBuilder;", "Lcom/intellij/quarkus/starter/QuarkusModuleBuilder;", "Lcom/intellij/microservices/jvm/dependencies/FrameworkModuleBuilder;", "module", "Lcom/intellij/openapi/module/Module;", "qsVersion", "", "<init>", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "isVersionAvailable", "", "frameworkVersion", "Lcom/intellij/microservices/jvm/starters/WebStarterFrameworkVersion;", "loadServerOptions", "Lcom/intellij/microservices/jvm/starters/WebStarterServerOptions;", "serverUrl", "getSettings", "Lcom/intellij/ide/starters/shared/StarterWizardSettings;", "getContext", "Lcom/intellij/microservices/jvm/starters/WebStarterContext;", "loadMetadata", "Lcom/fasterxml/jackson/databind/JsonNode;", "parseDependencies", "", "Lcom/intellij/microservices/jvm/starters/WebStarterDependencyCategory;", "metadata", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQsExtensionsModuleBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsExtensionsModuleBuilder.kt\ncom/intellij/quarkus/run/extensions/QsExtensionsModuleBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,90:1\n1755#2,3:91\n1#3:94\n381#4,7:95\n*S KotlinDebug\n*F\n+ 1 QsExtensionsModuleBuilder.kt\ncom/intellij/quarkus/run/extensions/QsExtensionsModuleBuilder\n*L\n64#1:91,3\n75#1:95,7\n*E\n"})
public final class QsExtensionsModuleBuilder
extends QuarkusModuleBuilder
implements FrameworkModuleBuilder {
    @NotNull
    private final Module module;
    @NotNull
    private final String qsVersion;

    public QsExtensionsModuleBuilder(@NotNull Module module, @NotNull String qsVersion) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)qsVersion, (String)"qsVersion");
        this.module = module;
        this.qsVersion = qsVersion;
        this.getObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    protected boolean isVersionAvailable(@NotNull WebStarterFrameworkVersion frameworkVersion) {
        Intrinsics.checkNotNullParameter((Object)frameworkVersion, (String)"frameworkVersion");
        return Intrinsics.areEqual((Object)frameworkVersion.getTitle(), (Object)this.qsVersion);
    }

    @Override
    @NotNull
    protected WebStarterServerOptions loadServerOptions(@NotNull String serverUrl) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        JsonNode metadata = this.loadMetadata(serverUrl);
        Version qsVersion = Version.parse((String)this.qsVersion);
        List<WebStarterDependencyCategory> dependencyCategories = this.parseDependencies(metadata);
        Intrinsics.checkNotNull((Object)qsVersion);
        FrameworkVersion version = new FrameworkVersion(this.qsVersion, this.qsVersion, qsVersion, true);
        return new WebStarterServerOptions(CollectionsKt.listOf((Object)version), dependencyCategories);
    }

    @NotNull
    public StarterWizardSettings getSettings() {
        return this.getStarterSettings();
    }

    @NotNull
    public WebStarterContext getContext() {
        return this.getStarterContext();
    }

    private final JsonNode loadMetadata(String serverUrl) {
        String mimeType = "application/json";
        String path = "/api/extensions";
        return this.loadJsonData(StringsKt.removeSuffix((String)serverUrl, (CharSequence)"/") + path, mimeType);
    }

    /*
     * WARNING - void declaration
     */
    private final List<WebStarterDependencyCategory> parseDependencies(JsonNode metadata) {
        Map categories = new LinkedHashMap();
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List declaredDependencies = DependencyModifierService.Companion.getInstance(project).declaredDependencies(this.module);
        Iterator iterator = metadata.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object object;
            String categoryName;
            Object links;
            boolean exists;
            String artifact;
            String group;
            String description;
            String name;
            String id;
            JsonNode dependencyObject;
            block12: {
                Object object2;
                block11: {
                    boolean bl;
                    block10: {
                        void $this$any$iv;
                        dependencyObject = (JsonNode)iterator2.next();
                        id = dependencyObject.get("id").asText();
                        name = dependencyObject.get("name").asText();
                        if (StringsKt.equals((String)name, (String)"Kotlin", (boolean)true) || StringsKt.equals((String)name, (String)"Scala", (boolean)true)) continue;
                        Intrinsics.checkNotNull((Object)dependencyObject);
                        JsonNode jsonNode = this.getNullable(dependencyObject, "description");
                        description = jsonNode != null ? jsonNode.asText() : null;
                        Intrinsics.checkNotNull((Object)id);
                        String[] stringArray = new String[]{":"};
                        List list = StringsKt.split$default((CharSequence)id, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                        group = (String)list.get(0);
                        artifact = (String)list.get(1);
                        Iterable iterable = declaredDependencies;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                DeclaredDependency declaredDependency = (DeclaredDependency)element$iv;
                                boolean bl2 = false;
                                if (!(Intrinsics.areEqual((Object)declaredDependency.getCoordinates().getGroupId(), (Object)group) && Intrinsics.areEqual((Object)declaredDependency.getCoordinates().getArtifactId(), (Object)artifact))) continue;
                                bl = true;
                                break block10;
                            }
                            bl = false;
                        }
                    }
                    exists = bl;
                    JsonNode jsonNode = this.getNullable(dependencyObject, "guide");
                    String guideLink = jsonNode != null ? jsonNode.asText() : null;
                    object2 = guideLink;
                    if (object2 == null) break block11;
                    String it = object2;
                    boolean bl3 = false;
                    List list = CollectionsKt.listOf((Object)new LibraryLink(LibraryLinkType.GUIDE, guideLink, null, 4, null));
                    object2 = list;
                    if (list != null) break block12;
                }
                object2 = links = CollectionsKt.emptyList();
            }
            if (StringsKt.equals((String)(categoryName = dependencyObject.get("category").asText()), (String)"Alternative languages", (boolean)true)) continue;
            Map $this$getOrPut$iv = categories;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(categoryName);
            if (value$iv == null) {
                boolean bl = false;
                Intrinsics.checkNotNull((Object)categoryName);
                QuarkusModuleBuilder.QuarkusDependencyCategory answer$iv = new QuarkusModuleBuilder.QuarkusDependencyCategory(categoryName, null, 2, null);
                $this$getOrPut$iv.put(categoryName, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            QuarkusModuleBuilder.QuarkusDependencyCategory category = (QuarkusModuleBuilder.QuarkusDependencyCategory)((Object)object);
            List<WebStarterDependency> list = category.getExtensions();
            Intrinsics.checkNotNull((Object)name);
            list.add((WebStarterDependency)new FrameworkDependency(id, name, description, (List)links, exists, new FrameworkDependencyCoordinates(group, artifact, null, null)));
        }
        return CollectionsKt.toList((Iterable)categories.values());
    }
}

