/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.run.gradle;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfileState;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.run.QsDebugState;
import com.intellij.quarkus.run.gradle.QsGradleRunConfigurationBase;
import com.intellij.quarkus.run.gradle.QsGradleRunConfigurationSettingsEditor;
import com.intellij.quarkus.run.gradle.QsGradleState;
import com.intellij.util.SmartList;
import com.intellij.util.net.NetUtils;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/quarkus/run/gradle/QsGradleRunConfiguration;", "Lcom/intellij/quarkus/run/gradle/QsGradleRunConfigurationBase;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration;", "copySettings", "Lcom/intellij/openapi/externalSystem/model/execution/ExternalSystemTaskExecutionSettings;", "settings", "addParameter", "", "parameter", "", "addProfileParameter", "addEnvVarsParameter", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQsGradleRunConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsGradleRunConfiguration.kt\ncom/intellij/quarkus/run/gradle/QsGradleRunConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1#2:92\n1863#3,2:93\n*S KotlinDebug\n*F\n+ 1 QsGradleRunConfiguration.kt\ncom/intellij/quarkus/run/gradle/QsGradleRunConfiguration\n*L\n86#1:93,2\n*E\n"})
public final class QsGradleRunConfiguration
extends QsGradleRunConfigurationBase {
    @NotNull
    private final Module module;

    public QsGradleRunConfiguration(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        super(project);
        this.module = module;
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.getSettings().setTaskNames((List)new SmartList((Object)"quarkusDev"));
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = this.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskExecutionSettings, (String)"getSettings(...)");
        ExternalSystemTaskExecutionSettings settingsCopy = this.copySettings(externalSystemTaskExecutionSettings);
        if (executor instanceof DefaultDebugExecutor) {
            int port = NetUtils.findAvailableSocketPort();
            String debugParameter = "-Ddebug=" + port;
            this.addParameter(settingsCopy, debugParameter);
            this.addProfileParameter(settingsCopy);
            this.addEnvVarsParameter(settingsCopy);
            QsGradleState state = new QsGradleState(settingsCopy, this.module, (ExternalSystemRunConfiguration)this, environment);
            this.copyUserDataTo((UserDataHolderBase)state);
            RemoteConnection remoteConnection = new RemoteConnection(true, "127.0.0.1", String.valueOf(port), false);
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            TargetEnvironmentAwareRunProfileState targetEnvironmentAwareRunProfileState = state;
            String string = this.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return (RunProfileState)new QsDebugState(project, remoteConnection, targetEnvironmentAwareRunProfileState, string, null, 16, null);
        }
        this.addProfileParameter(settingsCopy);
        this.addEnvVarsParameter(settingsCopy);
        QsGradleState state = new QsGradleState(settingsCopy, this.module, (ExternalSystemRunConfiguration)this, environment);
        this.copyUserDataTo((UserDataHolderBase)state);
        return (RunProfileState)state;
    }

    @NotNull
    public SettingsEditor<ExternalSystemRunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(QuarkusBundle.message("run.configuration.configuration.tab", new Object[0]), (SettingsEditor)new QsGradleRunConfigurationSettingsEditor());
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        return (SettingsEditor)group;
    }

    private final ExternalSystemTaskExecutionSettings copySettings(ExternalSystemTaskExecutionSettings settings) {
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings;
        ExternalSystemTaskExecutionSettings $this$copySettings_u24lambda_u240 = externalSystemTaskExecutionSettings = new ExternalSystemTaskExecutionSettings();
        boolean bl = false;
        $this$copySettings_u24lambda_u240.setFrom(settings);
        return externalSystemTaskExecutionSettings;
    }

    private final void addParameter(ExternalSystemTaskExecutionSettings settings, String parameter) {
        String scriptParameters = settings.getScriptParameters();
        CharSequence charSequence = scriptParameters;
        if (charSequence == null || charSequence.length() == 0) {
            settings.setScriptParameters(parameter);
        } else {
            settings.setScriptParameters(parameter + " " + scriptParameters);
        }
    }

    private final void addProfileParameter(ExternalSystemTaskExecutionSettings settings) {
        if (!Intrinsics.areEqual((Object)this.getProfile(), (Object)"dev")) {
            this.addParameter(settings, "-Dquarkus.profile=" + this.getProfile());
        }
    }

    private final void addEnvVarsParameter(ExternalSystemTaskExecutionSettings settings) {
        Iterable $this$forEach$iv = settings.getEnv().entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            Intrinsics.checkNotNull((Object)v);
            Object value = StringsKt.contains$default((CharSequence)v, (char)' ', (boolean)false, (int)2, null) ? "'" + v + "'" : v;
            this.addParameter(settings, "-D" + k + "=" + (String)value);
        }
    }
}

