/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.persistence.database.config.yaml.processor;

import com.intellij.microservices.jvm.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.persistence.database.ConfigDataSourceCandidate;
import com.intellij.persistence.database.ConfigDataSourcePropertyInfo;
import com.intellij.persistence.database.ConfigDataSourceSinglePropertyProcessor;
import com.intellij.persistence.database.DataSourceConfigType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\b\u001a\u0004\u0018\u00018\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u000eJ&\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/javaee/persistence/database/config/yaml/processor/YamlConfigSinglePropertyProcessor;", "T", "Lcom/intellij/persistence/database/DataSourceConfigType;", "I", "Lcom/intellij/persistence/database/ConfigDataSourcePropertyInfo;", "Lcom/intellij/persistence/database/ConfigDataSourceSinglePropertyProcessor;", "<init>", "()V", "convertToInfo", "property", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "documentId", "", "type", "(Lorg/jetbrains/yaml/psi/YAMLKeyValue;ILcom/intellij/persistence/database/DataSourceConfigType;)Lcom/intellij/persistence/database/ConfigDataSourcePropertyInfo;", "getPropertyCandidate", "Lcom/intellij/persistence/database/ConfigDataSourceCandidate;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "getDocumentId", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Integer;", "intellij.javaee.persistence.database.config.yaml"})
public abstract class YamlConfigSinglePropertyProcessor<T extends DataSourceConfigType, I extends ConfigDataSourcePropertyInfo>
extends ConfigDataSourceSinglePropertyProcessor<T, I> {
    @Nullable
    public abstract I convertToInfo(@NotNull YAMLKeyValue var1, int var2, @NotNull T var3);

    @Override
    @Nullable
    protected ConfigDataSourceCandidate<T, I> getPropertyCandidate(@NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IElementType iElementType = element.getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType elementType = iElementType;
        if (YAMLElementTypes.SPACE_ELEMENTS.contains(elementType) || YAMLElementTypes.EOL_ELEMENTS.contains(elementType)) {
            return null;
        }
        YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class);
        if (yAMLKeyValue == null) {
            return null;
        }
        YAMLKeyValue property = yAMLKeyValue;
        String string = ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)property);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedConfigKeyName(...)");
        String key = string;
        Object t = this.findFirstApplicableConfigType(key);
        if (t == null) {
            return null;
        }
        Object configType = t;
        Integer n = this.getDocumentId((PsiElement)property);
        if (n == null) {
            return null;
        }
        int documentId = n;
        I i = this.convertToInfo(property, documentId, configType);
        if (i == null) {
            return null;
        }
        I info = i;
        return new ConfigDataSourceCandidate(info, configType);
    }

    private final Integer getDocumentId(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.yaml.psi.YAMLFile");
        List documents = ((YAMLFile)psiFile).getDocuments();
        YAMLDocument document = (YAMLDocument)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLDocument.class);
        return documents.contains(document) ? Integer.valueOf(documents.indexOf(document)) : null;
    }
}

