/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.database;

import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.persistence.database.ConfigDataSource;
import com.intellij.persistence.database.ConfigDataSourceDetector;
import com.intellij.persistence.database.ConfigDataSourceDetectorKt;
import com.intellij.persistence.database.ConfigDataSourcePropertyValueSearcherKt;
import com.intellij.persistence.database.ConfigNewDataSource;
import com.intellij.persistence.database.RecognizedDatabaseConfig;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\b\u001a\u00020\tH$J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH&J \u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u001e\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\u0006\u0010\b\u001a\u00020\tH$\u00a8\u0006\u0018"}, d2={"Lcom/intellij/persistence/database/ConfigDataSourceDetector;", "F", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/database/autoconfig/DataSourceDetector;", "<init>", "()V", "configFiles", "", "module", "Lcom/intellij/openapi/module/Module;", "isApplicable", "", "collectDataSources", "", "builder", "Lcom/intellij/database/autoconfig/DataSourceDetector$Builder;", "onTheFly", "provideUniqueName", "", "existing", "", "originalName", "getDataSources", "Lcom/intellij/persistence/database/ConfigDataSource;", "intellij.javaee.persistence"})
@SourceDebugExtension(value={"SMAP\nConfigDataSourceDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigDataSourceDetector.kt\ncom/intellij/persistence/database/ConfigDataSourceDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,53:1\n808#2,11:54\n1663#2,8:65\n1863#2,2:73\n1#3:75\n127#4,2:76\n*S KotlinDebug\n*F\n+ 1 ConfigDataSourceDetector.kt\ncom/intellij/persistence/database/ConfigDataSourceDetector\n*L\n17#1:54,11\n18#1:65,8\n19#1:73,2\n41#1:76,2\n*E\n"})
public abstract class ConfigDataSourceDetector<F extends PsiFile>
extends DataSourceDetector {
    @NotNull
    protected abstract List<F> configFiles(@NotNull Module var1);

    public abstract boolean isApplicable(@NotNull Module var1);

    /*
     * WARNING - void declaration
     */
    public void collectDataSources(@NotNull Module module, @NotNull DataSourceDetector.Builder builder, boolean onTheFly) {
        void $this$forEach$iv;
        Iterable $this$distinctBy$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (!this.isApplicable(module)) {
            return;
        }
        Set dbNames = new LinkedHashSet();
        Iterable iterable = this.getDataSources(module);
        boolean $i$f$filterIsInstance = false;
        Iterator iterator = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ConfigNewDataSource)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            ConfigNewDataSource it = (ConfigNewDataSource)e$iv;
            boolean bl = false;
            String key$iv = it.getConfiguration().getUrl();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        $this$distinctBy$iv = list$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConfigNewDataSource markerData = (ConfigNewDataSource)element$iv;
            boolean bl = false;
            Set<TextRange> ranges = ConfigDataSourcePropertyValueSearcherKt.getDbPropertyPlaceholders(markerData.getConfiguration().getUrl());
            if (!((Collection)ranges).isEmpty()) continue;
            RecognizedDatabaseConfig config = markerData.getConfiguration();
            String name = this.provideUniqueName(dbNames, config.getDataSourceItemName());
            DataSourceDetector.Builder builder2 = builder.withDriverClass(config.getDriverClass()).withUser(config.getUsername()).withUrl(config.getUrl()).withOrigin((Object)markerData.getFileInfo().getFile()).withName(name);
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"withName(...)");
            ConfigDataSourceDetectorKt.setPasswordIfValid(builder2, config.getPassword()).commit();
        }
    }

    private final String provideUniqueName(Set<String> existing, String originalName) {
        Object element$iv2;
        block2: {
            if (!existing.contains(originalName)) {
                String string;
                String it = string = originalName;
                boolean bl = false;
                existing.add(it);
                return string;
            }
            Sequence $this$first$iv = SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)2, (Function1)provideUniqueName.2.INSTANCE), arg_0 -> ConfigDataSourceDetector.provideUniqueName$lambda$3(originalName, arg_0));
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                String it = (String)element$iv2;
                boolean bl = false;
                if (!existing.add(it)) continue;
                break block2;
            }
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return (String)element$iv2;
    }

    @NotNull
    protected abstract List<ConfigDataSource> getDataSources(@NotNull Module var1);

    private static final String provideUniqueName$lambda$3(String $originalName, int it) {
        return $originalName + " [" + it + "]";
    }
}

