/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.database.config.impl.urlParser;

import com.intellij.persistence.database.ConfigDataSourcePropertyValueSearcherKt;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseUrl;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseUrlParserKt;
import com.intellij.persistence.database.config.impl.urlParser.HsqlInFileDatabaseUrl;
import com.intellij.persistence.database.config.impl.urlParser.HsqlInMemoryDatabaseUrl;
import com.intellij.persistence.database.config.impl.urlParser.PathAndDatabaseName;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\u001c\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u001c\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0014\u0010\t\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0011"}, d2={"fileType", "", "HSQL_DATABASE_NAME", "hsqlMemUrlPattern", "Lkotlin/text/Regex;", "hsqlFileUrlPattern", "hsqlFile", "getHsqlFile", "()Lkotlin/text/Regex;", "hsqlMem", "getHsqlMem", "parseHsqldbUrl", "Lcom/intellij/persistence/database/config/impl/urlParser/DatabaseUrl;", "url", "databaseNameFromProperties", "parseHsqlFileUrl", "parseHsqlMemUrl", "intellij.javaee.persistence.impl"})
@SourceDebugExtension(value={"SMAP\nHsqldbUrlParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HsqldbUrlParser.kt\ncom/intellij/persistence/database/config/impl/urlParser/HsqldbUrlParserKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1#2:69\n*E\n"})
public final class HsqldbUrlParserKt {
    @NotNull
    private static final String fileType = "?<type>file|res";
    @NotNull
    private static final String HSQL_DATABASE_NAME = "?<databaseName>:[A-Za-z0-9-_]+";
    @NotNull
    private static final Regex hsqlMemUrlPattern = new Regex("jdbc:hsqldb:mem(?<databaseName>:[A-Za-z0-9-_]+)?(?<parameters>[A-Za-z0-9-\\?=:&\\-;?_/\\.\\\\]+)?");
    @NotNull
    private static final Regex hsqlFileUrlPattern = new Regex("jdbc:hsqldb:(?<type>file|res)(:)?(?<pathToDb>[A-Za-z0-9-/:\\-~\\._]+)?(?<parameters>[A-Za-z0-9-\\?=:&\\-;?_/\\.\\\\]+)?");
    @NotNull
    private static final Regex hsqlFile = new Regex("jdbc:hsqldb:(?<type>file|res)");
    @NotNull
    private static final Regex hsqlMem = new Regex("jdbc:hsqldb:mem");

    @NotNull
    public static final Regex getHsqlFile() {
        return hsqlFile;
    }

    @NotNull
    public static final Regex getHsqlMem() {
        return hsqlMem;
    }

    @Nullable
    public static final DatabaseUrl parseHsqldbUrl(@NotNull String url, @Nullable String databaseNameFromProperties) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (ConfigDataSourcePropertyValueSearcherKt.containsPlaceholders(url)) {
            return null;
        }
        CharSequence charSequence = url;
        return hsqlFile.containsMatchIn(charSequence) ? HsqldbUrlParserKt.parseHsqlFileUrl(url, databaseNameFromProperties) : (hsqlMem.containsMatchIn(charSequence = (CharSequence)url) ? HsqldbUrlParserKt.parseHsqlMemUrl(url, databaseNameFromProperties) : null);
    }

    private static final DatabaseUrl parseHsqlFileUrl(String url, String databaseNameFromProperties) {
        String string;
        String string2;
        Object object;
        String parameters;
        String type;
        block8: {
            block7: {
                MatchResult matchResult = Regex.find$default((Regex)hsqlFileUrlPattern, (CharSequence)url, (int)0, (int)2, null);
                if (matchResult == null || (matchResult = matchResult.getGroups()) == null) {
                    return null;
                }
                MatchResult groups = matchResult;
                String string3 = DatabaseUrlParserKt.getValue((MatchGroupCollection)groups, "type");
                if (string3 == null) {
                    return null;
                }
                type = string3;
                String pathToDb = DatabaseUrlParserKt.getValue((MatchGroupCollection)groups, "pathToDb");
                parameters = DatabaseUrlParserKt.getParameters((MatchGroupCollection)groups);
                object = pathToDb;
                if (object == null) break block7;
                String it = object;
                boolean bl = false;
                PathAndDatabaseName pathAndDatabaseName = DatabaseUrlParserKt.splitToPathAndDatabaseName(pathToDb);
                object = pathAndDatabaseName;
                if (pathAndDatabaseName != null) break block8;
            }
            object = new PathAndDatabaseName("", databaseNameFromProperties);
        }
        Object object2 = object;
        String path = ((PathAndDatabaseName)object2).component1();
        String databaseName = ((PathAndDatabaseName)object2).component2();
        String string4 = path;
        if (string4 == null) {
            string4 = string2 = "";
        }
        if ((string = databaseName) == null) {
            string = databaseNameFromProperties;
        }
        String string5 = string;
        return new HsqlInFileDatabaseUrl(string2, string5, parameters, type);
    }

    private static final DatabaseUrl parseHsqlMemUrl(String url, String databaseNameFromProperties) {
        MatchResult matchResult = Regex.find$default((Regex)hsqlMemUrlPattern, (CharSequence)url, (int)0, (int)2, null);
        if (matchResult == null || (matchResult = matchResult.getGroups()) == null) {
            return null;
        }
        MatchResult groups = matchResult;
        String string = DatabaseUrlParserKt.getDatabase((MatchGroupCollection)groups);
        if (string == null || (string = StringsKt.removePrefix((String)string, (CharSequence)":")) == null) {
            string = databaseNameFromProperties;
        }
        String databaseName = string;
        String parameters = DatabaseUrlParserKt.getParameters((MatchGroupCollection)groups);
        return new HsqlInMemoryDatabaseUrl(databaseName, parameters);
    }
}

