/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.database.config.impl.urlParser;

import com.intellij.persistence.database.config.impl.urlParser.DatabaseType;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseUrl;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\t\u0010\u000b\u001a\u00020\u0003H\u00c2\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c2\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c2\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/persistence/database/config/impl/urlParser/RawDatabaseUrl;", "Lcom/intellij/persistence/database/config/impl/urlParser/DatabaseUrl;", "databaseType", "Lcom/intellij/persistence/database/config/impl/urlParser/DatabaseType;", "databaseName", "", "url", "<init>", "(Lcom/intellij/persistence/database/config/impl/urlParser/DatabaseType;Ljava/lang/String;Ljava/lang/String;)V", "toDbDialogUrl", "dataSourceItemName", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.javaee.persistence.impl"})
public final class RawDatabaseUrl
extends DatabaseUrl {
    @NotNull
    private final DatabaseType databaseType;
    @Nullable
    private final String databaseName;
    @NotNull
    private final String url;

    public RawDatabaseUrl(@NotNull DatabaseType databaseType, @Nullable String databaseName, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.databaseType = databaseType;
        this.databaseName = databaseName;
        this.url = url;
    }

    @Override
    @NotNull
    public String toDbDialogUrl() {
        return this.url;
    }

    @Override
    @NotNull
    public String dataSourceItemName() {
        String string = this.databaseType.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string + "@" + this.databaseName;
    }

    private final DatabaseType component1() {
        return this.databaseType;
    }

    private final String component2() {
        return this.databaseName;
    }

    private final String component3() {
        return this.url;
    }

    @NotNull
    public final RawDatabaseUrl copy(@NotNull DatabaseType databaseType, @Nullable String databaseName, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new RawDatabaseUrl(databaseType, databaseName, url);
    }

    public static /* synthetic */ RawDatabaseUrl copy$default(RawDatabaseUrl rawDatabaseUrl, DatabaseType databaseType, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            databaseType = rawDatabaseUrl.databaseType;
        }
        if ((n & 2) != 0) {
            string = rawDatabaseUrl.databaseName;
        }
        if ((n & 4) != 0) {
            string2 = rawDatabaseUrl.url;
        }
        return rawDatabaseUrl.copy(databaseType, string, string2);
    }

    @NotNull
    public String toString() {
        return "RawDatabaseUrl(databaseType=" + this.databaseType + ", databaseName=" + this.databaseName + ", url=" + this.url + ")";
    }

    public int hashCode() {
        int result = this.databaseType.hashCode();
        result = result * 31 + (this.databaseName == null ? 0 : this.databaseName.hashCode());
        result = result * 31 + this.url.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RawDatabaseUrl)) {
            return false;
        }
        RawDatabaseUrl rawDatabaseUrl = (RawDatabaseUrl)other;
        if (this.databaseType != rawDatabaseUrl.databaseType) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.databaseName, (Object)rawDatabaseUrl.databaseName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.url, (Object)rawDatabaseUrl.url);
    }
}

