/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.database.config.impl.urlParser;

import com.intellij.persistence.database.config.impl.urlParser.DatabaseUrl;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseUrlParserKt;
import com.intellij.persistence.database.config.impl.urlParser.PathAndDatabaseName;
import com.intellij.persistence.database.config.impl.urlParser.SqliteUrl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"sqliteUrlPattern", "Lkotlin/text/Regex;", "IN_MEMORY_DATABASE", "", "parseSqliteUrl", "Lcom/intellij/persistence/database/config/impl/urlParser/DatabaseUrl;", "url", "databaseNameFromProperties", "intellij.javaee.persistence.impl"})
@SourceDebugExtension(value={"SMAP\nSqliteUrlParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqliteUrlParser.kt\ncom/intellij/persistence/database/config/impl/urlParser/SqliteUrlParserKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n1#2:46\n*E\n"})
public final class SqliteUrlParserKt {
    @NotNull
    private static final Regex sqliteUrlPattern = new Regex("(jdbc|r2dbc):sqlite(:memory|:file)?:(?<pathToDb>[A-Za-z0-9-/:\\-~\\._]+)?(?<parameters>[A-Za-z0-9-\\?=:&\\-;?_/\\.\\\\]+)?");
    @NotNull
    private static final String IN_MEMORY_DATABASE = "jdbc:sqlite::memory:";

    @Nullable
    public static final DatabaseUrl parseSqliteUrl(@NotNull String url, @Nullable String databaseNameFromProperties) {
        PathAndDatabaseName pathAndDatabaseName;
        PathAndDatabaseName pathAndDatabaseName2;
        String pathToDb;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (Intrinsics.areEqual((Object)url, (Object)IN_MEMORY_DATABASE)) {
            return null;
        }
        MatchResult matchResult = Regex.find$default((Regex)sqliteUrlPattern, (CharSequence)url, (int)0, (int)2, null);
        if (matchResult == null || (matchResult = matchResult.getGroups()) == null) {
            return null;
        }
        MatchResult groups = matchResult;
        String string = pathToDb = DatabaseUrlParserKt.getValue((MatchGroupCollection)groups, "pathToDb");
        if (string != null) {
            String it = string;
            boolean bl = false;
            pathAndDatabaseName2 = DatabaseUrlParserKt.splitToPathAndDatabaseName(it);
        } else {
            pathAndDatabaseName2 = null;
        }
        PathAndDatabaseName pathAndDatabaseName3 = pathAndDatabaseName = pathAndDatabaseName2;
        String string2 = pathAndDatabaseName3 != null ? pathAndDatabaseName3.getPath() : null;
        Object object = pathAndDatabaseName;
        if (object == null || (object = ((PathAndDatabaseName)object).getDatabaseName()) == null) {
            object = databaseNameFromProperties;
        }
        return new SqliteUrl(string2, (String)object, DatabaseUrlParserKt.getParameters((MatchGroupCollection)groups), StringsKt.contains$default((CharSequence)url, (CharSequence)"memory", (boolean)false, (int)2, null));
    }
}

