/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.database.config.properties.processor;

import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.microservices.jvm.config.properties.MicroservicePropertiesDocument;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.persistence.database.ConfigDataSourceCandidate;
import com.intellij.persistence.database.ConfigDataSourcePropertyInfo;
import com.intellij.persistence.database.ConfigDataSourceSinglePropertyProcessor;
import com.intellij.persistence.database.DataSourceConfigType;
import com.intellij.persistence.database.config.properties.processor.ConfigDocumentsProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00052\u00020\u0006B\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\t\u001a\u0004\u0018\u00018\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u000fJ&\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/persistence/database/config/properties/processor/PropertiesConfigDataSourceSinglePropertyProcessor;", "T", "Lcom/intellij/persistence/database/DataSourceConfigType;", "I", "Lcom/intellij/persistence/database/ConfigDataSourcePropertyInfo;", "Lcom/intellij/persistence/database/ConfigDataSourceSinglePropertyProcessor;", "Lcom/intellij/persistence/database/config/properties/processor/ConfigDocumentsProvider;", "<init>", "()V", "convertToInfo", "property", "Lcom/intellij/lang/properties/psi/Property;", "documentId", "", "type", "(Lcom/intellij/lang/properties/psi/Property;ILcom/intellij/persistence/database/DataSourceConfigType;)Lcom/intellij/persistence/database/ConfigDataSourcePropertyInfo;", "getPropertyCandidate", "Lcom/intellij/persistence/database/ConfigDataSourceCandidate;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "getDocumentId", "propertyImpl", "Lcom/intellij/lang/properties/psi/impl/PropertyImpl;", "(Lcom/intellij/lang/properties/psi/impl/PropertyImpl;)Ljava/lang/Integer;", "intellij.javaee.persistence.impl"})
@SourceDebugExtension(value={"SMAP\nPropertiesConfigSinglePropertyProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertiesConfigSinglePropertyProcessor.kt\ncom/intellij/persistence/database/config/properties/processor/PropertiesConfigDataSourceSinglePropertyProcessor\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n19#2:38\n19#2:39\n295#3,2:40\n*S KotlinDebug\n*F\n+ 1 PropertiesConfigSinglePropertyProcessor.kt\ncom/intellij/persistence/database/config/properties/processor/PropertiesConfigDataSourceSinglePropertyProcessor\n*L\n20#1:38\n32#1:39\n35#1:40,2\n*E\n"})
public abstract class PropertiesConfigDataSourceSinglePropertyProcessor<T extends DataSourceConfigType, I extends ConfigDataSourcePropertyInfo>
extends ConfigDataSourceSinglePropertyProcessor<T, I>
implements ConfigDocumentsProvider {
    @Nullable
    public abstract I convertToInfo(@NotNull Property var1, int var2, @NotNull T var3);

    @Override
    @Nullable
    protected ConfigDataSourceCandidate<T, I> getPropertyCandidate(@NotNull Editor editor, @NotNull PsiElement element) {
        PropertyImpl propertyImpl;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof PropertyImpl) {
            propertyImpl = (PropertyImpl)element;
        } else {
            PsiElement $this$asSafely$iv = element.getParent();
            boolean $i$f$asSafely = false;
            PsiElement psiElement = $this$asSafely$iv;
            if (!(psiElement instanceof PropertyImpl)) {
                psiElement = null;
            }
            if ((propertyImpl = (PropertyImpl)psiElement) == null) {
                return null;
            }
        }
        PropertyImpl property = propertyImpl;
        String string = property.getKey();
        if (string == null) {
            return null;
        }
        String keyText = string;
        Object t = this.findFirstApplicableConfigType(keyText);
        if (t == null) {
            return null;
        }
        Object type = t;
        Integer n = this.getDocumentId(property);
        if (n == null) {
            return null;
        }
        int documentId = n;
        I i = this.convertToInfo((Property)property, documentId, type);
        if (i == null) {
            return null;
        }
        I info = i;
        return new ConfigDataSourceCandidate(info, type);
    }

    private final Integer getDocumentId(PropertyImpl propertyImpl) {
        Object v3;
        block4: {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)propertyImpl));
            if (module == null) {
                return null;
            }
            Module module2 = module;
            PsiFile $this$asSafely$iv = propertyImpl.getContainingFile();
            boolean $i$f$asSafely = false;
            PsiFile psiFile = $this$asSafely$iv;
            if (!(psiFile instanceof PropertiesFileImpl)) {
                psiFile = null;
            }
            PropertiesFileImpl propertiesFileImpl = (PropertiesFileImpl)psiFile;
            if (propertiesFileImpl == null) {
                return null;
            }
            PropertiesFileImpl file = propertiesFileImpl;
            List<MicroservicePropertiesDocument> documents = this.getDocuments(module2, file);
            Iterable $this$firstOrNull$iv = documents;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MicroservicePropertiesDocument document = (MicroservicePropertiesDocument)element$iv;
                boolean bl = false;
                if (!document.getProperties().contains(propertyImpl)) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        MicroservicePropertiesDocument microservicePropertiesDocument = v3;
        return microservicePropertiesDocument != null ? Integer.valueOf(microservicePropertiesDocument.getDocumentId()) : null;
    }
}

