/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.mongodb.json.intentions;

import com.intellij.json.JsonBundle;
import com.intellij.json.intentions.JsonSortPropertiesIntention;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.persistence.mongodb.json.intentions.MongoDBJsonSortPropertiesIntentionKt;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonObject;
import com.intellij.persistence.mongodb.json.psi.impl.MongoDBJsonRecursiveElementVisitor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J!\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002J \u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0005H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/persistence/mongodb/json/intentions/MongoDBJsonSortPropertiesIntention;", "Lcom/intellij/json/intentions/JsonSortPropertiesIntention;", "<init>", "()V", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "reformat", "obj", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonObject;", "startInWriteAction", "Session", "intellij.javaee.persistence.impl"})
public final class MongoDBJsonSortPropertiesIntention
extends JsonSortPropertiesIntention {
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return new Session(editor, element).hasUnsortedObjects();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)element)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JsonBundle.message((String)"file.is.readonly", (Object[])new Object[0]), (String)JsonBundle.message((String)"cannot.sort.properties", (Object[])new Object[0]), null);
            return;
        }
        Session session = new Session(editor, element);
        if (session.getRootObj() != null) {
            session.sort();
            this.reformat(project, editor, session.getRootObj());
        }
    }

    private final void reformat(Project project, Editor editor, MongoDBJsonObject obj) {
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)obj);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        SmartPsiElementPointer pointer = smartPsiElementPointer;
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        MongoDBJsonObject mongoDBJsonObject = (MongoDBJsonObject)pointer.getElement();
        if (mongoDBJsonObject == null) {
            return;
        }
        MongoDBJsonObject element = mongoDBJsonObject;
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        codeStyleManager.reformatText(element.getContainingFile(), (Collection)SetsKt.setOf((Object)element.getTextRange()));
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/persistence/mongodb/json/intentions/MongoDBJsonSortPropertiesIntention$Session;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "contextElement", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiElement;)V", "selectionModel", "Lcom/intellij/openapi/editor/SelectionModel;", "rootObj", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonObject;", "getRootObj", "()Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonObject;", "objects", "", "collectObjects", "findRootObject", "hasUnsortedObjects", "", "sort", "", "intellij.javaee.persistence.impl"})
    @SourceDebugExtension(value={"SMAP\nMongoDBJsonSortPropertiesIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoDBJsonSortPropertiesIntention.kt\ncom/intellij/persistence/mongodb/json/intentions/MongoDBJsonSortPropertiesIntention$Session\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n1755#2,3:147\n1863#2,2:150\n*S KotlinDebug\n*F\n+ 1 MongoDBJsonSortPropertiesIntention.kt\ncom/intellij/persistence/mongodb/json/intentions/MongoDBJsonSortPropertiesIntention$Session\n*L\n87#1:147,3\n90#1:150,2\n*E\n"})
    private static final class Session {
        @NotNull
        private final PsiElement contextElement;
        @NotNull
        private final SelectionModel selectionModel;
        @Nullable
        private final MongoDBJsonObject rootObj;
        @NotNull
        private final Set<MongoDBJsonObject> objects;

        public Session(@NotNull Editor editor, @NotNull PsiElement contextElement) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)contextElement, (String)"contextElement");
            this.contextElement = contextElement;
            SelectionModel selectionModel = editor.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
            this.selectionModel = selectionModel;
            this.rootObj = this.findRootObject();
            this.objects = this.rootObj != null ? this.collectObjects(this.rootObj) : SetsKt.emptySet();
        }

        @Nullable
        public final MongoDBJsonObject getRootObj() {
            return this.rootObj;
        }

        private final Set<MongoDBJsonObject> collectObjects(MongoDBJsonObject rootObj) {
            Set result = new LinkedHashSet();
            if (this.selectionModel.hasSelection()) {
                new MongoDBJsonRecursiveElementVisitor(this, result){
                    final /* synthetic */ Session this$0;
                    final /* synthetic */ Set<MongoDBJsonObject> $result;
                    {
                        this.this$0 = $receiver;
                        this.$result = $result;
                    }

                    public void visitObject(MongoDBJsonObject o) {
                        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                        super.visitObject(o);
                        TextRange textRange = o.getTextRange();
                        boolean bl = textRange != null ? textRange.intersects(Session.access$getSelectionModel$p(this.this$0).getSelectionStart(), Session.access$getSelectionModel$p(this.this$0).getSelectionEnd()) : false;
                        if (bl) {
                            this.$result.add(o);
                        }
                    }
                }.visitObject(rootObj);
            }
            result.add(rootObj);
            return result;
        }

        private final MongoDBJsonObject findRootObject() {
            MongoDBJsonObject initObj = (MongoDBJsonObject)PsiTreeUtil.getParentOfType((PsiElement)this.contextElement, MongoDBJsonObject.class);
            if (initObj == null || !this.selectionModel.hasSelection()) {
                return initObj;
            }
            MongoDBJsonObject obj = initObj;
            while (true) {
                TextRange textRange = obj.getTextRange();
                boolean bl = textRange != null ? !textRange.containsRange(this.selectionModel.getSelectionStart(), this.selectionModel.getSelectionEnd()) : false;
                if (!bl || (MongoDBJsonObject)PsiTreeUtil.getParentOfType((PsiElement)obj, MongoDBJsonObject.class) == null) break;
            }
            return obj;
        }

        public final boolean hasUnsortedObjects() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.objects;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        MongoDBJsonObject it = (MongoDBJsonObject)element$iv;
                        boolean bl2 = false;
                        if (!(!MongoDBJsonSortPropertiesIntentionKt.access$isSorted(it))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public final void sort() {
            Iterable $this$forEach$iv = this.objects;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MongoDBJsonObject it = (MongoDBJsonObject)element$iv;
                boolean bl = false;
                if (MongoDBJsonSortPropertiesIntentionKt.access$isSorted(it)) continue;
                MongoDBJsonSortPropertiesIntentionKt.access$cycleSortProperties(it);
            }
        }

        public static final /* synthetic */ SelectionModel access$getSelectionModel$p(Session $this) {
            return $this.selectionModel;
        }
    }
}

