/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.mongodb.json.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.mongodb.json.MongoDBJsonDialectUtilKt;
import com.intellij.persistence.mongodb.json.MongoDBJsonElementTypes;
import com.intellij.persistence.mongodb.json.MongoDBJsonLanguage;
import com.intellij.persistence.mongodb.json.MongoDBJsonTokenSetsKt;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonArray;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonBooleanLiteral;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonLiteral;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonNumberLiteral;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonObject;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonProperty;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonReferenceExpression;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonStringLiteral;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J$\u0010\u001d\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u001eH\u0007J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u001eH\u0007J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001eH\u0007J\u0010\u0010\u0011\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\"H\u0007J\u0010\u0010\u0011\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020$H\u0007J\u0018\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0002R)\u0010\u0004\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u001c\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/persistence/mongodb/json/psi/impl/MongoDBJsonPsiImplUtils;", "", "<init>", "()V", "STRING_FRAGMENTS", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/util/TextRange;", "", "getSTRING_FRAGMENTS", "()Lcom/intellij/openapi/util/Key;", "getName", "property", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonProperty;", "getNameElement", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonValue;", "getValue", "isQuotedString", "", "literal", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonLiteral;", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "jsonArray", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonArray;", "jsonObject", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonObject;", "ourEscapesTable", "getTextFragments", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonStringLiteral;", "delete", "", "isPropertyName", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonBooleanLiteral;", "", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonNumberLiteral;", "removeCommaSeparatedFromList", "myNode", "Lcom/intellij/lang/ASTNode;", "parent", "intellij.javaee.persistence.impl"})
public final class MongoDBJsonPsiImplUtils {
    @NotNull
    public static final MongoDBJsonPsiImplUtils INSTANCE = new MongoDBJsonPsiImplUtils();
    @NotNull
    private static final Key<List<Pair<TextRange, String>>> STRING_FRAGMENTS = new Key("JSON string fragments");
    @NotNull
    private static final String ourEscapesTable = "\"\"\\\\//b\bf\fn\nr\rt\t";

    private MongoDBJsonPsiImplUtils() {
    }

    @NotNull
    public final Key<List<Pair<TextRange, String>>> getSTRING_FRAGMENTS() {
        return STRING_FRAGMENTS;
    }

    @JvmStatic
    @Nullable
    public static final String getName(@NotNull MongoDBJsonProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return StringUtil.unescapeStringCharacters((String)JsonPsiUtil.stripQuotes((String)property.getNameElement().getText()));
    }

    @JvmStatic
    @NotNull
    public static final MongoDBJsonValue getNameElement(@NotNull MongoDBJsonProperty property) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        PsiElement firstChild = property.getFirstChild();
        boolean bl2 = bl = firstChild instanceof MongoDBJsonLiteral || firstChild instanceof MongoDBJsonReferenceExpression;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Intrinsics.checkNotNull((Object)firstChild, (String)"null cannot be cast to non-null type com.intellij.persistence.mongodb.json.psi.MongoDBJsonValue");
        return (MongoDBJsonValue)firstChild;
    }

    @JvmStatic
    @Nullable
    public static final MongoDBJsonValue getValue(@NotNull MongoDBJsonProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return (MongoDBJsonValue)PsiTreeUtil.getNextSiblingOfType((PsiElement)MongoDBJsonPsiImplUtils.getNameElement(property), MongoDBJsonValue.class);
    }

    @JvmStatic
    public static final boolean isQuotedString(@NotNull MongoDBJsonLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        return literal.getNode().findChildByType(MongoDBJsonTokenSetsKt.getSTRING_LITERALS()) != null;
    }

    @JvmStatic
    @Nullable
    public static final ItemPresentation getPresentation(@NotNull MongoDBJsonProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return new ItemPresentation(property){
            final /* synthetic */ MongoDBJsonProperty $property;
            {
                this.$property = $property;
            }

            public String getPresentableText() {
                return this.$property.getName();
            }

            public String getLocationString() {
                MongoDBJsonValue value = this.$property.getValue();
                MongoDBJsonLiteral mongoDBJsonLiteral = value instanceof MongoDBJsonLiteral ? (MongoDBJsonLiteral)value : null;
                return mongoDBJsonLiteral != null ? mongoDBJsonLiteral.getText() : null;
            }

            public Icon getIcon(boolean unused) {
                if (this.$property.getValue() instanceof MongoDBJsonArray) {
                    return AllIcons.Json.Array;
                }
                return this.$property.getValue() instanceof MongoDBJsonObject ? AllIcons.Json.Object : PlatformIcons.PROPERTY_ICON;
            }
        };
    }

    @JvmStatic
    @Nullable
    public static final ItemPresentation getPresentation(@NotNull MongoDBJsonArray jsonArray) {
        Intrinsics.checkNotNullParameter((Object)jsonArray, (String)"jsonArray");
        return new ItemPresentation(){

            public String getPresentableText() {
                String string = JsonBundle.message((String)"json.array", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public Icon getIcon(boolean unused) {
                Icon icon = AllIcons.Json.Array;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Array");
                return icon;
            }
        };
    }

    @JvmStatic
    @Nullable
    public static final ItemPresentation getPresentation(@NotNull MongoDBJsonObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        return new ItemPresentation(){

            public String getPresentableText() {
                String string = JsonBundle.message((String)"json.object", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public Icon getIcon(boolean unused) {
                Icon icon = AllIcons.Json.Object;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Object");
                return icon;
            }
        };
    }

    @JvmStatic
    @Nullable
    public static final List<Pair<TextRange, String>> getTextFragments(@NotNull MongoDBJsonStringLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        List result = (List)literal.getUserData(STRING_FRAGMENTS);
        if (result == null) {
            int contentEnd;
            result = new ArrayList();
            String text = literal.getText();
            int length = text.length();
            int pos = 1;
            int unescapedSequenceStart = 1;
            block5: while (pos < length) {
                if (text.charAt(pos) == '\\') {
                    if (unescapedSequenceStart != pos) {
                        ArrayList arrayList = (ArrayList)result;
                        TextRange textRange = new TextRange(unescapedSequenceStart, pos);
                        Intrinsics.checkNotNull((Object)text);
                        String string = text.substring(unescapedSequenceStart, pos);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        arrayList.add(Pair.create((Object)textRange, (Object)string));
                    }
                    if (pos == length - 1) {
                        ((ArrayList)result).add(Pair.create((Object)new TextRange(pos, pos + 1), (Object)"\\"));
                        break;
                    }
                    char next = text.charAt(pos + 1);
                    switch (next) {
                        case '\"': 
                        case '/': 
                        case '\\': 
                        case 'b': 
                        case 'f': 
                        case 'n': 
                        case 'r': 
                        case 't': {
                            int idx = StringsKt.indexOf$default((CharSequence)ourEscapesTable, (char)next, (int)0, (boolean)false, (int)6, null);
                            ArrayList arrayList = (ArrayList)result;
                            TextRange textRange = new TextRange(pos, pos + 2);
                            String string = ourEscapesTable.substring(idx + 1, idx + 2);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            arrayList.add(Pair.create((Object)textRange, (Object)string));
                            pos += 2;
                            break;
                        }
                        case 'u': {
                            int i;
                            for (i = pos + 2; i < pos + 6 && i != length && StringUtil.isHexDigit((char)text.charAt(i)); ++i) {
                            }
                            ArrayList arrayList = (ArrayList)result;
                            TextRange textRange = new TextRange(pos, i);
                            Intrinsics.checkNotNull((Object)text);
                            String string = text.substring(pos, i);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            arrayList.add(Pair.create((Object)textRange, (Object)string));
                            pos = i;
                            break;
                        }
                        case 'x': {
                            Language language = MongoDBJsonDialectUtilKt.getLanguageOrDefaultJson(literal);
                            if (language instanceof MongoDBJsonLanguage) {
                                int i2;
                                for (i2 = pos + 2; i2 < pos + 4 && i2 != length && StringUtil.isHexDigit((char)text.charAt(i2)); ++i2) {
                                }
                                ArrayList arrayList = (ArrayList)result;
                                TextRange textRange = new TextRange(pos, i2);
                                Intrinsics.checkNotNull((Object)text);
                                String string = text.substring(pos, i2);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                                arrayList.add(Pair.create((Object)textRange, (Object)string));
                                break block5;
                            }
                            ArrayList arrayList = (ArrayList)result;
                            TextRange textRange = new TextRange(pos, pos + 2);
                            Intrinsics.checkNotNull((Object)text);
                            String string = text.substring(pos, pos + 2);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            arrayList.add(Pair.create((Object)textRange, (Object)string));
                            pos += 2;
                            break;
                        }
                        default: {
                            ArrayList arrayList = (ArrayList)result;
                            TextRange textRange = new TextRange(pos, pos + 2);
                            Intrinsics.checkNotNull((Object)text);
                            String string = text.substring(pos, pos + 2);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            arrayList.add(Pair.create((Object)textRange, (Object)string));
                            pos += 2;
                        }
                    }
                    unescapedSequenceStart = pos;
                    continue;
                }
                ++pos;
            }
            int n = contentEnd = text.charAt(0) == text.charAt(length - 1) ? length - 1 : length;
            if (unescapedSequenceStart < contentEnd) {
                ArrayList arrayList = (ArrayList)result;
                TextRange textRange = new TextRange(unescapedSequenceStart, contentEnd);
                Intrinsics.checkNotNull((Object)text);
                String string = text.substring(unescapedSequenceStart, contentEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                arrayList.add(Pair.create((Object)textRange, (Object)string));
            }
            result = Collections.unmodifiableList(result);
            literal.putUserData(STRING_FRAGMENTS, result);
        }
        return result;
    }

    public final void delete(@NotNull MongoDBJsonProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        ASTNode myNode = property.getNode();
        Intrinsics.checkNotNull((Object)myNode);
        ASTNode aSTNode = myNode.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getTreeParent(...)");
        this.removeCommaSeparatedFromList(myNode, aSTNode);
    }

    @JvmStatic
    @NotNull
    public static final String getValue(@NotNull MongoDBJsonStringLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        String string = StringUtil.unescapeStringCharacters((String)JsonPsiUtil.stripQuotes((String)literal.getText()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unescapeStringCharacters(...)");
        return string;
    }

    @JvmStatic
    public static final boolean isPropertyName(@NotNull MongoDBJsonStringLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        PsiElement parent = literal.getParent();
        return parent instanceof MongoDBJsonProperty && ((MongoDBJsonProperty)parent).getNameElement() == literal;
    }

    @JvmStatic
    public static final boolean getValue(@NotNull MongoDBJsonBooleanLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        return literal.textMatches("true");
    }

    @JvmStatic
    public static final double getValue(@NotNull MongoDBJsonNumberLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        String string = literal.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return Double.parseDouble(string);
    }

    private final void removeCommaSeparatedFromList(ASTNode myNode, ASTNode parent) {
        ASTNode toCandidate;
        ASTNode from = myNode;
        ASTNode to = myNode.getTreeNext();
        boolean seenComma = false;
        for (toCandidate = to; toCandidate != null && toCandidate.getElementType() == TokenType.WHITE_SPACE; toCandidate = toCandidate.getTreeNext()) {
        }
        if (toCandidate != null && toCandidate.getElementType() == MongoDBJsonElementTypes.COMMA) {
            to = toCandidate = toCandidate.getTreeNext();
            seenComma = true;
            if (to != null && to.getElementType() == TokenType.WHITE_SPACE) {
                to = to.getTreeNext();
            }
        }
        if (!seenComma) {
            ASTNode treePrev;
            for (treePrev = from.getTreePrev(); treePrev != null && treePrev.getElementType() == TokenType.WHITE_SPACE; treePrev = treePrev.getTreePrev()) {
                from = treePrev;
            }
            if (treePrev != null && treePrev.getElementType() == MongoDBJsonElementTypes.COMMA) {
                from = treePrev;
            }
        }
        parent.removeRange(from, to);
    }
}

