/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.mongodb.json.surroundWith;

import com.intellij.json.surroundWith.JsonSurrounderBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonElementGenerator;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonPsiUtilKt;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0002\u0010\tJ-\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/persistence/mongodb/json/surroundWith/MongoDBJsonSurrounderBase;", "Lcom/intellij/json/surroundWith/JsonSurrounderBase;", "<init>", "()V", "isApplicable", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "([Lcom/intellij/psi/PsiElement;)Z", "surroundElements", "Lcom/intellij/openapi/util/TextRange;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;[Lcom/intellij/psi/PsiElement;)Lcom/intellij/openapi/util/TextRange;", "intellij.javaee.persistence.impl"})
public abstract class MongoDBJsonSurrounderBase
extends JsonSurrounderBase {
    public boolean isApplicable(@NotNull PsiElement[] elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        return !(elements.length == 0) && elements[0] instanceof MongoDBJsonValue && !MongoDBJsonPsiUtilKt.isPropertyKey(elements[0]);
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        if (!this.isApplicable(elements)) {
            return null;
        }
        FileType fileType = ((PsiElement)ArraysKt.first((Object[])elements)).getContainingFile().getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        MongoDBJsonElementGenerator generator = new MongoDBJsonElementGenerator(project, fileType);
        if (elements.length == 1) {
            String string = this.createReplacementText(elements[0].getText());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"createReplacementText(...)");
            Object replacement = generator.createValue(string);
            v2 = elements[0].replace((PsiElement)replacement);
        } else {
            String string = JsonSurrounderBase.getTextAndRemoveMisc((PsiElement)elements[0], (PsiElement)elements[elements.length - 1]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextAndRemoveMisc(...)");
            String propertiesText = string;
            String string2 = this.createReplacementText(propertiesText);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"createReplacementText(...)");
            Object replacement = generator.createValue(string2);
            v2 = elements[0].replace((PsiElement)replacement);
        }
        return null;
    }
}

