/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.mongodb.json.surroundWith;

import com.intellij.json.JsonBundle;
import com.intellij.json.surroundWith.JsonSurrounderBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonElementGenerator;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonObject;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonProperty;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonPsiUtilKt;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonValue;
import com.intellij.persistence.mongodb.json.surroundWith.MongoDBJsonSurrounderBase;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001b\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0002\u0010\u000bJ-\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/persistence/mongodb/json/surroundWith/MongoDBJsonWithObjectLiteralSurrounder;", "Lcom/intellij/persistence/mongodb/json/surroundWith/MongoDBJsonSurrounderBase;", "<init>", "()V", "getTemplateDescription", "", "isApplicable", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "([Lcom/intellij/psi/PsiElement;)Z", "surroundElements", "Lcom/intellij/openapi/util/TextRange;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;[Lcom/intellij/psi/PsiElement;)Lcom/intellij/openapi/util/TextRange;", "createReplacementText", "textInRange", "intellij.javaee.persistence.impl"})
@SourceDebugExtension(value={"SMAP\nMongoDBJsonWithObjectLiteralSurrounder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoDBJsonWithObjectLiteralSurrounder.kt\ncom/intellij/persistence/mongodb/json/surroundWith/MongoDBJsonWithObjectLiteralSurrounder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
public final class MongoDBJsonWithObjectLiteralSurrounder
extends MongoDBJsonSurrounderBase {
    @NotNull
    public String getTemplateDescription() {
        String string = JsonBundle.message((String)"surround.with.object.literal.desc", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement[] elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        return !(elements.length == 0) && !MongoDBJsonPsiUtilKt.isPropertyKey(elements[0]) && (elements[0] instanceof MongoDBJsonProperty || elements.length == 1);
    }

    @Override
    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        if (!this.isApplicable(elements)) {
            return null;
        }
        FileType fileType = ((PsiElement)ArraysKt.first((Object[])elements)).getContainingFile().getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        MongoDBJsonElementGenerator generator = new MongoDBJsonElementGenerator(project, fileType);
        PsiElement firstElement = elements[0];
        MongoDBJsonValue newNameElement = null;
        if (firstElement instanceof MongoDBJsonValue) {
            boolean bl;
            boolean bl2 = bl = elements.length == 1;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-MongoDBJsonWithObjectLiteralSurrounder$surroundElements$22 = false;
                String $i$a$-assert-MongoDBJsonWithObjectLiteralSurrounder$surroundElements$22 = "Only single JSON value can be wrapped in object literal";
                throw new AssertionError((Object)$i$a$-assert-MongoDBJsonWithObjectLiteralSurrounder$surroundElements$22);
            }
            String string = firstElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            MongoDBJsonObject replacement = (MongoDBJsonObject)generator.createValue(this.createReplacementText(string));
            PsiElement psiElement = firstElement.replace((PsiElement)replacement);
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.persistence.mongodb.json.psi.MongoDBJsonObject");
            replacement = (MongoDBJsonObject)psiElement;
            newNameElement = replacement.getPropertyList().get(0).getNameElement();
        } else {
            boolean replacement = firstElement instanceof MongoDBJsonProperty;
            if (_Assertions.ENABLED && !replacement) {
                String $i$a$-assert-MongoDBJsonWithObjectLiteralSurrounder$surroundElements$22 = "Assertion failed";
                throw new AssertionError((Object)$i$a$-assert-MongoDBJsonWithObjectLiteralSurrounder$surroundElements$22);
            }
            String string = JsonSurrounderBase.getTextAndRemoveMisc((PsiElement)firstElement, (PsiElement)elements[elements.length - 1]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextAndRemoveMisc(...)");
            String propertiesText = string;
            MongoDBJsonObject tempJsonObject = (MongoDBJsonObject)generator.createValue(StringsKt.trimIndent((String)(this.createReplacementText("{\n" + propertiesText) + "}")));
            MongoDBJsonProperty replacement2 = tempJsonObject.getPropertyList().get(0);
            PsiElement psiElement = firstElement.replace((PsiElement)replacement2);
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.persistence.mongodb.json.psi.MongoDBJsonProperty");
            replacement2 = (MongoDBJsonProperty)psiElement;
            newNameElement = replacement2.getNameElement();
        }
        TextRange rangeWithQuotes = newNameElement.getTextRange();
        return new TextRange(rangeWithQuotes.getStartOffset() + 1, rangeWithQuotes.getEndOffset() - 1);
    }

    @NotNull
    protected String createReplacementText(@NotNull String textInRange) {
        Intrinsics.checkNotNullParameter((Object)textInRange, (String)"textInRange");
        return "{\n\"property\": " + textInRange + "\n}";
    }
}

