/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.roles;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.facet.ModifiablePersistenceFacet;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceListener;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistenceQuery;
import com.intellij.persistence.model.PersistentEmbeddable;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentSuperclass;
import com.intellij.persistence.model.helpers.PersistenceMappingsModelHelper;
import com.intellij.persistence.model.helpers.PersistentEntityBaseModelHelper;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.roles.PersistenceClassRoleImpl;
import com.intellij.persistence.roles.PersistenceRoleHolder;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PerformanceAssertions;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.GenericValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PersistenceRoleHolderImpl
extends PersistenceRoleHolder {
    private static final NotNullFunction<PersistenceFacet, Info> MERGED_GETTER = facet -> PersistenceRoleHolderImpl.getFacetMergedInfo(facet);
    private static final NotNullFunction<PersistenceFacet, Info> XML_GETTER = facet -> PersistenceRoleHolderImpl.getFacetXmlInfo(facet);
    private final Project myProject;

    public PersistenceRoleHolderImpl(@NotNull Project project) {
        if (project == null) {
            PersistenceRoleHolderImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Override
    public boolean processAllRoles(@NotNull PsiClass psiClass, @NotNull Processor<? super PersistenceClassRole> processor) {
        if (psiClass == null) {
            PersistenceRoleHolderImpl.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            PersistenceRoleHolderImpl.$$$reportNull$$$0(2);
        }
        return this.processRoles(psiClass, MERGED_GETTER, processor);
    }

    @Override
    public boolean processXmlRoles(@NotNull PsiClass aClass, @NotNull Processor<? super PersistenceClassRole> processor) {
        if (aClass == null) {
            PersistenceRoleHolderImpl.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            PersistenceRoleHolderImpl.$$$reportNull$$$0(4);
        }
        return this.processRoles(aClass, XML_GETTER, processor);
    }

    @Override
    public boolean processModuleRoles(@NotNull Module module, @NotNull PsiClass psiClass, @NotNull Processor<? super PersistenceClassRole> processor) {
        if (module == null) {
            PersistenceRoleHolderImpl.$$$reportNull$$$0(5);
        }
        if (psiClass == null) {
            PersistenceRoleHolderImpl.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            PersistenceRoleHolderImpl.$$$reportNull$$$0(7);
        }
        String fqn = PersistenceRoleHolderImpl.getFQN(psiClass);
        for (Info info : PersistenceRoleHolderImpl.getModuleFacetInfos(module)) {
            for (PersistenceClassRole role : info.map.get((Object)fqn)) {
                if (processor.process((Object)role)) continue;
                return false;
            }
        }
        return true;
    }

    private static Collection<Info> getModuleFacetInfos(@NotNull Module module) {
        if (module == null) {
            PersistenceRoleHolderImpl.$$$reportNull$$$0(8);
        }
        return (Collection)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            List infos = ContainerUtil.map(PersistenceCommonUtil.getAllPersistenceFacets(module), PersistenceRoleHolderImpl::findFacetMergedInfo);
            return CachedValueProvider.Result.create(List.copyOf(infos), (Object[])PersistenceCommonUtil.getPersistenceModificationTrackerDependencies(module.getProject()));
        });
    }

    private boolean processRoles(@NotNull PsiClass psiClass, @NotNull NotNullFunction<? super PersistenceFacet, Info> infoGetter, @NotNull Processor<? super PersistenceClassRole> processor) {
        Module module;
        if (psiClass == null) {
            PersistenceRoleHolderImpl.$$$reportNull$$$0(9);
        }
        if (infoGetter == null) {
            PersistenceRoleHolderImpl.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            PersistenceRoleHolderImpl.$$$reportNull$$$0(11);
        }
        List<PersistenceFacet> facets = (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass)) != null ? PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies(module) : PersistenceCommonUtil.getAllPersistenceFacets(this.myProject);
        return PersistenceRoleHolderImpl.processPersistenceFacets(psiClass, infoGetter, processor, facets);
    }

    private static boolean processPersistenceFacets(@NotNull PsiClass psiClass, @NotNull NotNullFunction<? super PersistenceFacet, Info> infoGetter, @NotNull Processor<? super PersistenceClassRole> processor, List<? extends PersistenceFacet> facets) {
        if (psiClass == null) {
            PersistenceRoleHolderImpl.$$$reportNull$$$0(12);
        }
        if (infoGetter == null) {
            PersistenceRoleHolderImpl.$$$reportNull$$$0(13);
        }
        if (processor == null) {
            PersistenceRoleHolderImpl.$$$reportNull$$$0(14);
        }
        String fqn = PersistenceRoleHolderImpl.getFQN(psiClass);
        for (PersistenceFacet persistenceFacet : facets) {
            for (PersistenceClassRole role : ((Info)infoGetter.fun((Object)persistenceFacet)).map.get((Object)fqn)) {
                if (processor.process((Object)role)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean processAllRoles(@NotNull Processor<? super PersistenceClassRole> processor) {
        if (processor == null) {
            PersistenceRoleHolderImpl.$$$reportNull$$$0(15);
        }
        for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacets(this.myProject)) {
            for (PersistenceClassRole role : ((Info)PersistenceRoleHolderImpl.MERGED_GETTER.fun((Object)facet)).map.values()) {
                if (processor.process((Object)role)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean processMergedQueries(PersistenceFacet facet, @NotNull Processor<? super PersistenceQuery> processor) {
        if (processor == null) {
            PersistenceRoleHolderImpl.$$$reportNull$$$0(16);
        }
        for (NotNullLazyValue<List<PersistenceQuery>> producer : ((Info)PersistenceRoleHolderImpl.MERGED_GETTER.fun((Object)facet)).queryProducers) {
            for (PersistenceQuery query : (List)producer.getValue()) {
                if (processor.process((Object)query)) continue;
                return false;
            }
        }
        return true;
    }

    private static Info getFacetXmlInfo(PersistenceFacet facet) {
        if (facet.getModule().isDisposed()) {
            return new Info();
        }
        PerformanceAssertions.assertDoesNotAffectHighlighting();
        return (Info)CachedValuesManager.getManager((Project)facet.getModule().getProject()).getCachedValue((UserDataHolder)facet, () -> {
            Info info = new Info();
            HashSet<Object> dependencies = new HashSet<Object>();
            Project project = facet.getModule().getProject();
            dependencies.add(JavaLibraryModificationTracker.getInstance((Project)project));
            dependencies.addAll(Arrays.asList(PersistenceCommonUtil.getFacetCacheDependencies(project)));
            if (facet instanceof ModifiablePersistenceFacet) {
                ContainerUtil.addIfNotNull(dependencies, (Object)((ModifiablePersistenceFacet)facet).getDescriptorsContainer());
            }
            for (PersistencePackage unit : facet.getExplicitPersistenceUnits()) {
                ContainerUtil.addIfNotNull(dependencies, (Object)unit.getContainingFile());
                dependencies.addAll(unit.getModelHelper().getCacheDependencies());
                for (GenericValue<PersistenceMappings> value : unit.getModelHelper().getMappingFiles(PersistenceMappings.class)) {
                    PersistenceMappings mappings = (PersistenceMappings)value.getValue();
                    if (mappings == null) continue;
                    ContainerUtil.addIfNotNull(dependencies, (Object)mappings.getContainingFile());
                    PersistenceRoleHolderImpl.processMappings(info, facet, unit, mappings);
                }
            }
            return new CachedValueProvider.Result((Object)info, ArrayUtil.toObjectArray(dependencies));
        });
    }

    private static Info getFacetMergedInfo(PersistenceFacet facet) {
        Module module = facet.getModule();
        if (module.isDisposed()) {
            return new Info();
        }
        return (Info)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)facet, () -> {
            HashSet<Object> dependencies = new HashSet<Object>();
            dependencies.add(PsiModificationTracker.MODIFICATION_COUNT);
            Project project = facet.getModule().getProject();
            dependencies.add(JavaLibraryModificationTracker.getInstance((Project)project));
            dependencies.addAll(Arrays.asList(PersistenceCommonUtil.getFacetCacheDependencies(project)));
            Info info = new Info();
            for (PersistencePackage persistencePackage : facet.getPersistenceUnits()) {
                dependencies.addAll(persistencePackage.getModelHelper().getCacheDependencies());
                if (!persistencePackage.isValid()) continue;
                PersistenceRoleHolderImpl.processMappings(info, facet, persistencePackage, facet.getEntityMappings(persistencePackage));
            }
            return CachedValueProvider.Result.create((Object)info, (Object[])ArrayUtil.toObjectArray(dependencies));
        });
    }

    @NotNull
    private static Info findFacetMergedInfo(PersistenceFacet facet) {
        Info info = new Info();
        for (PersistencePackage persistencePackage : facet.getPersistenceUnits()) {
            if (!persistencePackage.isValid()) continue;
            PersistenceRoleHolderImpl.processMappings(info, facet, persistencePackage, facet.getEntityMappings(persistencePackage));
        }
        Info info2 = info;
        if (info2 == null) {
            PersistenceRoleHolderImpl.$$$reportNull$$$0(17);
        }
        return info2;
    }

    private static void processMappings(Info info, PersistenceFacet facet, PersistencePackage unit, PersistenceMappings mappings) {
        PersistenceMappingsModelHelper mappingsModelHelper = mappings.getModelHelper();
        List<NotNullLazyValue<List<PersistenceQuery>>> producers = info.queryProducers;
        for (PersistentEntity persistentEntity : mappingsModelHelper.getPersistentEntities()) {
            PersistenceRoleHolderImpl.processClass(info, (PsiClass)persistentEntity.getClazz().getValue(), PersistenceClassRoleEnum.ENTITY, persistentEntity, unit, facet);
            producers.add(PersistenceRoleHolderImpl.createProducer(persistentEntity.getObjectModelHelper()));
        }
        for (PersistentEmbeddable persistentEmbeddable : mappingsModelHelper.getPersistentEmbeddables()) {
            PersistenceRoleHolderImpl.processClass(info, (PsiClass)persistentEmbeddable.getClazz().getValue(), PersistenceClassRoleEnum.EMBEDDABLE, persistentEmbeddable, unit, facet);
        }
        for (PersistentSuperclass persistentSuperclass : mappingsModelHelper.getPersistentSuperclasses()) {
            PersistenceRoleHolderImpl.processClass(info, (PsiClass)persistentSuperclass.getClazz().getValue(), PersistenceClassRoleEnum.MAPPED_SUPERCLASS, persistentSuperclass, unit, facet);
            producers.add(PersistenceRoleHolderImpl.createProducer(persistentSuperclass.getObjectModelHelper()));
        }
        for (PersistenceListener persistenceListener : mappingsModelHelper.getPersistentListeners()) {
            PersistenceRoleHolderImpl.processEntityListenerClass(info, (PsiClass)persistenceListener.getClazz().getValue(), persistenceListener, unit, facet);
        }
        producers.add(PersistenceRoleHolderImpl.createProducer(mappingsModelHelper));
    }

    public static void processEntityListenerClass(Info info, PsiClass psiClass, PersistenceListener entityListener, PersistencePackage unit, PersistenceFacet facet) {
        PersistenceRoleHolderImpl.processClass(info, psiClass, new PersistenceClassRoleImpl(PersistenceClassRoleEnum.ENTITY_LISTENER, facet, unit, entityListener));
    }

    private static void processClass(Info info, PsiClass psiClass, PersistenceClassRoleEnum classRoleEnum, PersistentObject persistentObject, PersistencePackage unit, PersistenceFacet facet) {
        PersistenceRoleHolderImpl.processClass(info, psiClass, new PersistenceClassRoleImpl(classRoleEnum, facet, unit, persistentObject));
    }

    private static void processClass(Info info, PsiClass psiClass, PersistenceClassRole classRole) {
        ProgressManager.checkCanceled();
        if (psiClass == null) {
            return;
        }
        info.map.putValue((Object)PersistenceRoleHolderImpl.getFQN(psiClass), (Object)classRole);
    }

    private static String getFQN(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PersistenceRoleHolderImpl.$$$reportNull$$$0(18);
        }
        String name = psiClass.getQualifiedName();
        VirtualFile virtualFile = psiClass.getContainingFile().getOriginalFile().getVirtualFile();
        return virtualFile == null ? name : name + ":" + virtualFile.getPath();
    }

    private static NotNullLazyValue<List<PersistenceQuery>> createProducer(PersistenceMappingsModelHelper helper) {
        return NotNullLazyValue.atomicLazy(() -> {
            SmartList queries = new SmartList();
            queries.addAll(helper.getNamedQueries());
            queries.addAll(helper.getNamedNativeQueries());
            return queries;
        });
    }

    private static NotNullLazyValue<List<PersistenceQuery>> createProducer(@NotNull PersistentEntityBaseModelHelper helper) {
        if (helper == null) {
            PersistenceRoleHolderImpl.$$$reportNull$$$0(19);
        }
        return NotNullLazyValue.atomicLazy(() -> {
            SmartList queries = new SmartList();
            queries.addAll(helper.getNamedQueries());
            queries.addAll(helper.getNamedNativeQueries());
            return queries;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoGetter";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/persistence/roles/PersistenceRoleHolderImpl";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/persistence/roles/PersistenceRoleHolderImpl";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findFacetMergedInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processAllRoles";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processXmlRoles";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processModuleRoles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getModuleFacetInfos";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processRoles";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processPersistenceFacets";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processMergedQueries";
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFQN";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createProducer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17 -> new IllegalStateException(string);
        };
    }

    private static final class Info {
        final MultiMap<String, PersistenceClassRole> map = MultiMap.createSet();
        final List<NotNullLazyValue<List<PersistenceQuery>>> queryProducers = new SmartList();

        private Info() {
        }
    }
}

