/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.visibility;

import com.intellij.concurrency.ThreadContext;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.diagram.state.DiagramRealizersSnapshot;
import com.intellij.diagram.util.DiagramUpdateService;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.uml.core.actions.UmlCategorySwitcher;
import com.intellij.uml.core.actions.visibility.DeselectedVisibilityIcon;
import com.intellij.uml.core.actions.visibility.SelectedVisibilityIcon;
import com.intellij.uml.utils.DiagramBundle;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ChangeVisibilityLevelAction
extends DiagramAction {
    @NotNull
    private static final SelectedVisibilityIcon SELECTED_ICON = new SelectedVisibilityIcon();
    @NotNull
    private static final DeselectedVisibilityIcon DESELECTED_ICON = new DeselectedVisibilityIcon();
    @NotNull
    private final VisibilityLevel myLevel;
    @NotNull
    private final DiagramBuilder myBuilder;

    public ChangeVisibilityLevelAction(@NotNull VisibilityLevel level, @NotNull DiagramBuilder builder) {
        if (level == null) {
            ChangeVisibilityLevelAction.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            ChangeVisibilityLevelAction.$$$reportNull$$$0(1);
        }
        super(level.getDisplayName(), "", ChangeVisibilityLevelAction.getActionIcon(builder.getDataModel().getVisibilityManager(), level));
        this.myLevel = level;
        this.myBuilder = builder;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ChangeVisibilityLevelAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setIcon(ChangeVisibilityLevelAction.getActionIcon(this.myBuilder.getDataModel().getVisibilityManager(), this.myLevel));
    }

    @Override
    public void perform(@NotNull AnActionEvent e) {
        if (e == null) {
            ChangeVisibilityLevelAction.$$$reportNull$$$0(3);
        }
        DiagramDataModel<?> dataModel = this.myBuilder.getDataModel();
        DiagramVisibilityManager visibilityManager = dataModel.getVisibilityManager();
        VisibilityLevel oldVisibilityLevel = visibilityManager.getCurrentVisibilityLevel();
        boolean wasVisibilityExtended = visibilityManager.getComparator().compare(this.myLevel, oldVisibilityLevel) >= 0;
        visibilityManager.setCurrentVisibilityLevel(this.myLevel);
        DiagramRealizersSnapshot oldRealizers = DiagramRealizersSnapshot.Factory.getInstance().makeSnapshot(this.myBuilder);
        ((CompletableFuture)((CompletableFuture)DiagramUpdateService.getInstance().requestDataModelRefreshPreservingLayout(this.myBuilder).runAsync().thenComposeAsync(__ -> oldRealizers.restoreAsync(this.myBuilder), Futures.inEdt())).thenComposeAsync(ThreadContext.captureThreadContext(__ -> UmlCategorySwitcher.relayoutOnCategorySwitchAsync(this.myBuilder, wasVisibilityExtended, () -> this.myBuilder.queryUpdate().withPresentationUpdate().withAllNodeSizeUpdate().run())))).thenComposeAsync(ThreadContext.captureThreadContext(__ -> UmlCategorySwitcher.updateModelBuilderIfNeededAsync(this.myBuilder, wasVisibilityExtended)));
    }

    private static Icon getActionIcon(@NotNull DiagramVisibilityManager mgr, @NotNull VisibilityLevel level) {
        if (mgr == null) {
            ChangeVisibilityLevelAction.$$$reportNull$$$0(4);
        }
        if (level == null) {
            ChangeVisibilityLevelAction.$$$reportNull$$$0(5);
        }
        return level == mgr.getCurrentVisibilityLevel() ? SELECTED_ICON : DESELECTED_ICON;
    }

    @Override
    @NotNull
    public String getActionName() {
        String string = DiagramBundle.message("action.name.change.visibility.to.0", this.myLevel.getDisplayName());
        if (string == null) {
            ChangeVisibilityLevelAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mgr";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/visibility/ChangeVisibilityLevelAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/visibility/ChangeVisibilityLevelAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getActionIcon";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

