/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.admin;

import com.intellij.javaee.appServers.deployment.DeploymentMethod;
import com.intellij.javaee.appServers.deployment.DeploymentModel;
import com.intellij.javaee.oss.admin.JavaeeAgentAdminServerBase;
import com.intellij.javaee.oss.agent.ParametersMap;
import com.intellij.javaee.oss.agent.VendorSpecificAgent;
import com.intellij.javaee.oss.jboss.config.Jboss7DomainHostConfig;
import com.intellij.javaee.oss.jboss.config.Jboss7DomainServersConfig;
import com.intellij.javaee.oss.jboss.server.JBossDeploymentProvider;
import com.intellij.javaee.oss.jboss.server.JBossLocalModel;
import com.intellij.javaee.oss.jboss.server.JBossRemoteModel;
import com.intellij.javaee.oss.jboss.server.JBossServerModel;
import com.intellij.javaee.oss.jboss.version.JBossVersion7Handler;
import com.intellij.javaee.oss.server.WslSupportUtil;
import com.intellij.javaee.ui.packaging.ExplodedEarArtifactType;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JBossModernAdminServerBase
extends JavaeeAgentAdminServerBase {
    private static final String CLIENT_TIMEOUT_VM_OPTION_NAME = "idea.wildfly.client.timeout";
    private static final Logger LOG = Logger.getInstance(JBossModernAdminServerBase.class);
    private static final String TAG_CHILDREN_DEPLOYMENT = "deployment";
    private static final String TAG_CHILD_DEPLOYMENTS = "deployments";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String WAR_EXTENSION = "war";
    private static final String EAR_EXTENSION = "ear";
    private final JBossServerModel myServerModel;
    private final boolean myLocal;

    public JBossModernAdminServerBase(JBossServerModel serverModel, VendorSpecificAgent agent) {
        super(agent);
        this.myLocal = serverModel instanceof JBossLocalModel;
        this.myServerModel = serverModel;
    }

    protected void setupInitParameters(ParametersMap initParameters) {
        initParameters.put((Object)"is.local", (Object)Boolean.toString(this.myLocal));
        initParameters.put((Object)"is.domain", (Object)Boolean.toString(this.myServerModel.isDomain()));
        initParameters.put((Object)"server.group", (Object)this.myServerModel.getServerGroup());
        initParameters.put((Object)"is.secured", (Object)Boolean.toString(this.myServerModel.isSecured()));
        int clientTimeout = SystemProperties.getIntProperty((String)CLIENT_TIMEOUT_VM_OPTION_NAME, (int)0);
        if (clientTimeout > 0) {
            initParameters.put((Object)"client.timeout", (Object)String.valueOf(clientTimeout));
        }
        if (this.myLocal && this.myServerModel.isDomain()) {
            List<String> servers = Jboss7DomainServersConfig.getDomainServers(this.myServerModel);
            initParameters.put((Object)"server.names", (Object)StringUtil.join(servers, (String)";"));
            initParameters.put((Object)"domain.host", (Object)Jboss7DomainHostConfig.getDomainHost(this.myServerModel));
        }
    }

    protected void setupDeployParameters(DeploymentModel deployment, File source, ParametersMap deployParameters) throws Exception {
        JBossLocalModel localModel;
        String home;
        JBossServerModel jBossServerModel;
        String sourcePath = source.getAbsolutePath();
        DeploymentMethod deploymentMethod = deployment.getDeploymentMethod();
        if (!this.myLocal) {
            JBossRemoteModel remoteServerModel = (JBossRemoteModel)this.myServerModel;
            if (deploymentMethod == JBossDeploymentProvider.STAGING) {
                sourcePath = remoteServerModel.prepareDeployment(sourcePath, false);
            }
        }
        if ((jBossServerModel = this.myServerModel) instanceof JBossLocalModel && WslSupportUtil.isWslPath((String)(home = (localModel = (JBossLocalModel)jBossServerModel).getHome()))) {
            sourcePath = WslSupportUtil.fromWinToLinuxMntPath((String)home, (String)sourcePath);
        }
        deployParameters.put((Object)"source.path", (Object)sourcePath);
        deployParameters.put((Object)"native.deployment.method", (Object)Boolean.toString(!source.isDirectory() && deployment.getDeploymentMethod() == JBossDeploymentProvider.NATIVE));
        Artifact artifact = deployment.getArtifact();
        if (artifact != null) {
            String extension;
            ArtifactType type = artifact.getArtifactType();
            String string = extension = type == ExplodedWarArtifactType.getInstance() ? WAR_EXTENSION : this.computeExtensionExtra(type);
            if (extension != null && !FileUtilRt.extensionEquals((String)source.getName(), (String)extension)) {
                deployParameters.put((Object)"runtime.name.extension", (Object)extension);
            }
        }
    }

    @Nullable
    protected String computeExtensionExtra(@NotNull ArtifactType type) {
        if (type == null) {
            JBossModernAdminServerBase.$$$reportNull$$$0(0);
        }
        return null;
    }

    @NotNull
    protected String getDeploymentName(DeploymentModel deployment, File source) {
        String string = JBossModernAdminServerBase.doGetDeploymentName(source);
        if (string == null) {
            JBossModernAdminServerBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    protected static String computeExtensionEar(@NotNull ArtifactType type) {
        if (type == null) {
            JBossModernAdminServerBase.$$$reportNull$$$0(2);
        }
        return type == ExplodedEarArtifactType.getInstance() ? EAR_EXTENSION : null;
    }

    private static String doGetDeploymentName(File source) {
        return source.getName();
    }

    public void cleanDeployments(List<DeploymentModel> deploymentModels) {
        File configFile = this.myServerModel.isDomain() ? JBossVersion7Handler.getDomainConfigFile(this.myServerModel) : JBossVersion7Handler.getConfigFile(this.myServerModel);
        try {
            Namespace namespace;
            if (deploymentModels.isEmpty()) {
                return;
            }
            Element rootElement = JDOMUtil.load((File)configFile);
            Element deployments = rootElement.getChild(TAG_CHILD_DEPLOYMENTS, namespace = rootElement.getNamespace());
            if (deployments == null) {
                return;
            }
            List listDeployment = deployments.getChildren(TAG_CHILDREN_DEPLOYMENT, namespace);
            block2: for (DeploymentModel deploymentModel : deploymentModels) {
                File deploymentFile = deploymentModel.getDeploymentSource().getFile();
                if (deploymentFile == null) continue;
                String deploymentName = JBossModernAdminServerBase.doGetDeploymentName(deploymentFile);
                for (Element deployment : new ArrayList(listDeployment)) {
                    if (!deploymentName.equals(deployment.getAttributeValue(ATTRIBUTE_NAME))) continue;
                    deployment.detach();
                    continue block2;
                }
            }
            if (listDeployment.size() == 0) {
                deployments.detach();
            }
            JDOMUtil.write((Element)rootElement, (Path)configFile.toPath());
        }
        catch (IOException | JDOMException e) {
            LOG.info(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/oss/jboss/admin/JBossModernAdminServerBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/oss/jboss/admin/JBossModernAdminServerBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeExtensionExtra";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeExtensionEar";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

